/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud;

import io.github.darkkronicle.advancedchatcore.chat.ChatMessage;
import io.github.darkkronicle.advancedchathud.AdvancedChatHud;
import io.github.darkkronicle.advancedchathud.tabs.AbstractChatTab;
import io.github.darkkronicle.advancedchathud.tabs.CustomChatTab;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class HudChatMessage {
    private List<AbstractChatTab> tabs;
    private final ChatMessage message;

    public HudChatMessage(ChatMessage message) {
        this(message, new ArrayList<AbstractChatTab>());
        boolean forward = true;
        if (AdvancedChatHud.MAIN_CHAT_TAB.getCustomChatTabs().size() > 0) {
            for (CustomChatTab customChatTab : AdvancedChatHud.MAIN_CHAT_TAB.getCustomChatTabs()) {
                if (!customChatTab.shouldAdd(message.getOriginalText()) || this.tabs.contains(customChatTab)) continue;
                this.tabs.add(customChatTab);
                if (customChatTab.isForward()) continue;
                forward = false;
                break;
            }
        }
        if (forward) {
            this.tabs.add(AdvancedChatHud.MAIN_CHAT_TAB);
        }
        for (AbstractChatTab abstractChatTab : this.tabs) {
            abstractChatTab.addNewUnread();
        }
    }

    public HudChatMessage(ChatMessage message, List<AbstractChatTab> tabs) {
        this.message = message;
        this.tabs = tabs;
    }

    public void setTabs(List<AbstractChatTab> tabs) {
        this.tabs = tabs;
    }

    public List<AbstractChatTab> getTabs() {
        return this.tabs;
    }

    public ChatMessage getMessage() {
        return this.message;
    }
}

