/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.toml.TomlParser;
import io.github.darkkronicle.advancedchatcore.AdvancedChatCore;
import java.io.File;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.logging.log4j.Level;

@Environment(value=EnvType.CLIENT)
public final class TomlUtil {
    public static FileConfig loadFile(File file) {
        FileConfig config = FileConfig.of((File)file);
        config.load();
        return config;
    }

    public static FileConfig loadFileWithDefaults(File file, String defaultName) {
        TomlFormat tomlFormat = TomlFormat.instance();
        TomlParser tomlParser = tomlFormat.createParser();
        FileConfig config = TomlUtil.loadFile(file);
        try {
            tomlParser.parse(AdvancedChatCore.getResource(defaultName), (Config)config, ParsingMode.ADD);
        }
        catch (Exception e) {
            AdvancedChatCore.LOGGER.log(Level.ERROR, "Could not load default settings into " + defaultName, (Throwable)e);
        }
        return config;
    }

    private TomlUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

