/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.util.RawText;
import io.github.darkkronicle.advancedchatcore.util.StringInsert;
import io.github.darkkronicle.advancedchatcore.util.StringMatch;
import io.github.darkkronicle.advancedchatcore.util.TextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public final class TextUtil {
    private static final char[] SUPERSCRIPTS = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};

    public static double similarity(String s1, String s2) {
        int longerLength;
        String longer = s1;
        String shorter = s2;
        if (s1.length() < s2.length()) {
            longer = s2;
            shorter = s1;
        }
        if ((longerLength = longer.length()) == 0) {
            return 1.0;
        }
        return (double)(longerLength - TextUtil.editDistance(longer, shorter)) / (double)longerLength;
    }

    public static int editDistance(String s1, String s2) {
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        int[] costs = new int[s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= s2.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[s2.length()] = lastValue;
        }
        return costs[s2.length()];
    }

    public static String toSuperscript(int num) {
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(SUPERSCRIPTS[num % 10]);
        } while ((num /= 10) > 0);
        return sb.reverse().toString();
    }

    public static int getMaxLengthTranslation(Collection<String> translations) {
        return TextUtil.getMaxLengthTranslation(translations.toArray(new String[0]));
    }

    public static int getMaxLengthTranslation(String ... translations) {
        ArrayList<String> translated = new ArrayList<String>();
        for (String translation : translations) {
            translated.add(StringUtils.translate((String)translation, (Object[])new Object[0]));
        }
        return TextUtil.getMaxLengthString(translated);
    }

    public static int getMaxLengthString(Collection<String> strings) {
        return TextUtil.getMaxLengthString(strings.toArray(new String[0]));
    }

    public static int getMaxLengthString(String ... strings) {
        int max = 0;
        for (String text : strings) {
            int width = StringUtils.getStringWidth((String)text);
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    private static TreeMap<StringMatch, StringInsert> filterMatches(Map<StringMatch, StringInsert> matches) {
        TreeMap<StringMatch, StringInsert> map = new TreeMap<StringMatch, StringInsert>(matches);
        Iterator<StringMatch> search = new TreeMap<StringMatch, StringInsert>((SortedMap<StringMatch, StringInsert>)map).keySet().iterator();
        int lastEnd = 0;
        while (search.hasNext()) {
            StringMatch m = search.next();
            if (m.start < lastEnd) {
                map.remove(m);
                continue;
            }
            lastEnd = m.end;
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static class_2561 replaceStrings(class_2561 input, Map<StringMatch, StringInsert> matches) {
        if (matches.size() == 0) {
            return input;
        }
        Iterator<Map.Entry<StringMatch, StringInsert>> sortedMatches = TextUtil.filterMatches(matches).entrySet().iterator();
        if (!sortedMatches.hasNext()) {
            return input;
        }
        TextBuilder newSiblings = new TextBuilder();
        Map.Entry<StringMatch, StringInsert> match = sortedMatches.next();
        int totalchar = 0;
        boolean inMatch = false;
        Iterator<RawText> iterator = new TextBuilder().append(input).getTexts().iterator();
        while (iterator.hasNext()) {
            RawText text = iterator.next();
            if (text.getString() == null || text.getString().length() <= 0) continue;
            if (match == null) {
                newSiblings.append(text);
                continue;
            }
            int length = text.getString().length();
            int last = 0;
            do {
                if (length + totalchar <= match.getKey().start) {
                    newSiblings.append(text.getString().substring(last), text.method_10866());
                    break;
                }
                int start = match.getKey().start - totalchar;
                int end = match.getKey().end - totalchar;
                if (inMatch) {
                    if (end > length) break;
                    inMatch = false;
                    newSiblings.append(text.getString().substring(end), text.method_10866());
                    last = end;
                    if (!sortedMatches.hasNext()) {
                        match = null;
                        break;
                    }
                    match = sortedMatches.next();
                    continue;
                }
                if (start >= length) break;
                if (start > 0) {
                    newSiblings.append(text.getString().substring(last, start), text.method_10866());
                }
                if (end >= length) {
                    newSiblings.append((class_2561)match.getValue().getText(text, match.getKey()));
                    if (end == length) {
                        if (!sortedMatches.hasNext()) {
                            match = null;
                            break;
                        }
                        match = sortedMatches.next();
                        break;
                    }
                    inMatch = true;
                    break;
                }
                newSiblings.append((class_2561)match.getValue().getText(text, match.getKey()));
                match = !sortedMatches.hasNext() ? null : sortedMatches.next();
                last = end;
                if (match != null && match.getKey().start - totalchar <= length) continue;
                newSiblings.append(text.getString().substring(end), text.method_10866());
                break;
            } while (match != null);
            totalchar += length;
        }
        return newSiblings.build();
    }

    public static class_5250 truncate(class_2561 input, StringMatch match) {
        ArrayList<Object> newSiblings = new ArrayList<Object>();
        boolean start = false;
        int totalchar = 0;
        List siblings = input.method_10855();
        siblings.add(0, class_5250.method_43477((class_7417)input.method_10851()).method_27696(input.method_10866()));
        for (class_2561 text : siblings) {
            if (text.method_10851() == null || text.getString().length() <= 0) continue;
            int n = text.getString().length();
            if (totalchar + n > match.start) {
                if (totalchar + n >= match.end) {
                    if (!start) {
                        newSiblings.add(class_2561.method_43470((String)text.getString().substring(match.start - totalchar, match.end - totalchar)).method_27696(text.method_10866()));
                    } else {
                        newSiblings.add(class_2561.method_43470((String)text.getString().substring(0, match.end - totalchar)).method_27696(text.method_10866()));
                    }
                    class_5250 newtext = class_2561.method_43473();
                    for (class_2561 class_25612 : newSiblings) {
                        newtext.method_10852(class_25612);
                    }
                    return newtext;
                }
                if (!start) {
                    newSiblings.add(class_2561.method_43470((String)text.getString().substring(match.start - totalchar)).method_27696(text.method_10866()));
                    start = true;
                } else {
                    newSiblings.add(text);
                }
            }
            totalchar += n;
        }
        class_5250 newtext = class_2561.method_43473();
        for (class_2561 class_25613 : newSiblings) {
            newtext.method_10852(class_25613);
        }
        return newtext;
    }

    public static boolean styleChanges(class_2561 text) {
        class_2583 style = null;
        if (text.method_10855().size() == 1) {
            return false;
        }
        for (class_2561 raw : text.method_10855()) {
            if (style == null) {
                style = raw.method_10866();
                continue;
            }
            if (style.equals((Object)raw.method_10866())) continue;
            return true;
        }
        return false;
    }

    public static boolean styleChanges(class_2561 text, BiFunction<class_2583, class_2583, Boolean> predicate) {
        class_2583 previous = null;
        if (text.method_10855().size() == 1) {
            return predicate.apply(((class_2561)text.method_10855().get(0)).method_10866(), ((class_2561)text.method_10855().get(0)).method_10866()) == false;
        }
        for (class_2561 raw : text.method_10855()) {
            if (previous == null) {
                previous = raw.method_10866();
                continue;
            }
            if (previous.equals((Object)raw.method_10866())) continue;
            if (!predicate.apply(previous, raw.method_10866()).booleanValue()) {
                return true;
            }
            previous = raw.method_10866();
        }
        return false;
    }

    public static String getContent(class_7417 content) {
        StringBuilder builder = new StringBuilder();
        content.method_27659(s -> {
            builder.append(s);
            return Optional.empty();
        });
        return builder.toString();
    }

    private TextUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

