/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class SyncTaskQueue {
    private static final SyncTaskQueue INSTANCE = new SyncTaskQueue();
    private int lastTick = 0;
    private final TreeSet<QueuedTask> queue = new TreeSet();

    public static SyncTaskQueue getInstance() {
        return INSTANCE;
    }

    public void add(int after, Runnable runnable) {
        this.queue.add(new QueuedTask(this.lastTick + after, runnable));
    }

    public void update(int tick) {
        this.lastTick = tick;
        if (this.queue.size() == 0) {
            return;
        }
        QueuedTask task = this.queue.first();
        while (task != null && task.tick <= this.lastTick) {
            task.task.run();
            this.queue.pollFirst();
            if (this.queue.size() == 0) break;
            task = this.queue.first();
        }
    }

    public static final class QueuedTask
    implements Comparable<QueuedTask> {
        private final int tick;
        private final Runnable task;

        @Override
        public int compareTo(@NotNull QueuedTask o) {
            return Integer.compare(this.tick, o.tick);
        }

        public int getTick() {
            return this.tick;
        }

        public Runnable getTask() {
            return this.task;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueuedTask)) {
                return false;
            }
            QueuedTask other = (QueuedTask)o;
            if (this.getTick() != other.getTick()) {
                return false;
            }
            Runnable this$task = this.getTask();
            Runnable other$task = other.getTask();
            return !(this$task == null ? other$task != null : !this$task.equals(other$task));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTick();
            Runnable $task = this.getTask();
            result = result * 59 + ($task == null ? 43 : $task.hashCode());
            return result;
        }

        public String toString() {
            return "SyncTaskQueue.QueuedTask(tick=" + this.getTick() + ", task=" + this.getTask() + ")";
        }

        public QueuedTask(int tick, Runnable task) {
            this.tick = tick;
            this.task = task;
        }
    }
}

