/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.FindType;
import io.github.darkkronicle.advancedchatcore.util.SearchUtils;
import io.github.darkkronicle.advancedchatcore.util.TextBuilder;
import io.github.darkkronicle.advancedchatcore.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_341;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class StyleFormatter {
    private int currentIndex;
    private int realIndex;
    private int skipBy = 0;
    private class_2583 currentStyle;
    private class_2583 lastTextStyle = null;
    private final FormattingVisitable visitor;
    private final int length;

    public StyleFormatter(FormattingVisitable visitor, int length) {
        this.visitor = visitor;
        this.currentIndex = 0;
        this.realIndex = 0;
        this.currentStyle = class_2583.field_24360;
        this.length = length;
    }

    private boolean sendToVisitor(char c, class_2583 textStyle) {
        return this.visitor.accept(c, this.currentIndex, this.realIndex, textStyle, this.currentStyle);
    }

    private Result updateSection(class_2583 textStyle, Character nextChar, String rest) {
        if (nextChar == null) {
            return Result.SKIP;
        }
        if (nextChar.charValue() == '#') {
            if (rest.length() > 6) {
                String format = rest.substring(1, 7);
                if (!SearchUtils.isMatch(format, "^[0-9a-fA-F]{6}", FindType.REGEX)) {
                    ++this.currentIndex;
                    return Result.INCREMENT;
                }
                int red = Integer.parseInt(format.substring(0, 2), 16);
                int green = Integer.parseInt(format.substring(2, 4), 16);
                int blue = Integer.parseInt(format.substring(4, 6), 16);
                class_5251 color = class_5251.method_27717((int)new Color(red, green, blue, 255).color());
                this.currentStyle = this.currentStyle.equals((Object)class_2583.field_24360) || this.currentStyle.equals((Object)textStyle) ? textStyle.method_27707(class_124.field_1074) : this.currentStyle.method_27707(class_124.field_1074);
                this.currentStyle = this.currentStyle.method_27703(color);
                this.currentIndex += 7;
                this.skipBy = 6;
            }
            return Result.INCREMENT;
        }
        class_124 formatting = class_124.method_544((char)nextChar.charValue());
        if (formatting != null) {
            this.currentStyle = formatting == class_124.field_1070 ? textStyle : (this.currentStyle.equals((Object)class_2583.field_24360) || this.currentStyle.equals((Object)textStyle) ? textStyle.method_27707(formatting) : this.currentStyle.method_27707(formatting));
            if (this.currentStyle.equals((Object)class_2583.field_24360)) {
                this.currentStyle = textStyle;
            }
        }
        ++this.currentIndex;
        return Result.INCREMENT;
    }

    public Optional<Optional<class_3902>> updateStyle(class_2583 textStyle, String string) {
        if (this.lastTextStyle == null) {
            this.lastTextStyle = textStyle;
        }
        this.currentStyle = textStyle;
        int stringLength = string.length();
        for (int i = 0; i < stringLength; ++i) {
            char c = string.charAt(i);
            Character nextChar = null;
            if (i + 1 < stringLength) {
                nextChar = Character.valueOf(string.charAt(i + 1));
            }
            if (c == '\u00a7') {
                this.skipBy = 0;
                switch (this.updateSection(textStyle, nextChar, string.substring(i + 1))) {
                    case SKIP: {
                        return Optional.empty();
                    }
                    case TERMINATE: {
                        return Optional.of(class_5348.field_25309);
                    }
                    case INCREMENT: {
                        ++i;
                    }
                }
                i += this.skipBy;
            } else if (this.sendToVisitor(c, textStyle)) {
                ++this.realIndex;
            } else {
                return Optional.of(class_5348.field_25309);
            }
            ++this.currentIndex;
        }
        this.lastTextStyle = textStyle;
        return Optional.empty();
    }

    public static class_5250 formatText(class_2561 text) {
        class_5250 t = class_2561.method_43473();
        int length = text.getString().length();
        StyleFormatter formatter = new StyleFormatter((c, index, formattedIndex, style, formattedStyle) -> {
            t.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(c)).method_27696(formattedStyle));
            return true;
        }, length);
        text.method_27658(formatter::updateStyle, class_2583.field_24360);
        return StyleFormatter.flattenText((class_2561)t);
    }

    public static class_5250 flattenText(class_2561 text) {
        ArrayList<class_5250> newSiblings = new ArrayList<class_5250>();
        class_2583 last = text.method_10866();
        StringBuilder content = new StringBuilder(TextUtil.getContent(text.method_10851()));
        for (class_2561 t : text.method_10855()) {
            if (t.method_10866().equals((Object)last)) {
                content.append(TextUtil.getContent(t.method_10851()));
                continue;
            }
            newSiblings.add(class_2561.method_43470((String)content.toString()).method_27696(last));
            content = new StringBuilder(TextUtil.getContent(t.method_10851()));
            last = t.method_10866();
        }
        newSiblings.add(class_2561.method_43470((String)content.toString()).method_27696(last));
        class_5250 newText = class_2561.method_43473();
        for (class_2561 class_25612 : newSiblings) {
            newText.method_10852(class_25612);
        }
        return newText;
    }

    public static List<class_2561> wrapText(class_327 textRenderer, int scaledWidth, class_2561 text) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        for (class_5481 breakRenderedChatMessageLine : class_341.method_1850((class_5348)text, (int)scaledWidth, (class_327)textRenderer)) {
            lines.add((class_2561)new TextBuilder().append(breakRenderedChatMessageLine).build());
        }
        return lines;
    }

    public static interface FormattingVisitable {
        public boolean accept(char var1, int var2, int var3, class_2583 var4, class_2583 var5);
    }

    private static enum Result {
        INCREMENT,
        SKIP,
        TERMINATE;

    }
}

