/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import fi.dy.masa.malilib.config.options.ConfigString;
import io.github.darkkronicle.advancedchatcore.chat.MessageOwner;
import io.github.darkkronicle.advancedchatcore.config.ConfigStorage;
import io.github.darkkronicle.advancedchatcore.interfaces.IFinder;
import io.github.darkkronicle.advancedchatcore.util.FindType;
import io.github.darkkronicle.advancedchatcore.util.StringMatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_634;
import net.minecraft.class_640;

@Environment(value=EnvType.CLIENT)
public final class SearchUtils {
    private static final TreeMap<Integer, String> map = new TreeMap();

    public static boolean isMatch(String input, String toMatch, FindType type) {
        IFinder finder = type.getFinder();
        if (finder == null) {
            return false;
        }
        return finder.isMatch(input, toMatch);
    }

    public static boolean isMatch(class_2561 input, String toMatch, FindType type) {
        IFinder finder = type.getFinder();
        if (finder == null) {
            return false;
        }
        return finder.isMatch(input, toMatch);
    }

    public static String replaceGroups(List<StringMatch> groups, String input) {
        if (input.length() < 2 || !input.contains("$")) {
            return input;
        }
        Optional<List<StringMatch>> replace = SearchUtils.findMatches(input, "\\$[0-9]", FindType.REGEX);
        if (replace.isEmpty()) {
            return input;
        }
        TreeSet replaceMatches = new TreeSet(replace.get());
        int last = 0;
        StringBuilder edited = new StringBuilder();
        for (StringMatch m : replaceMatches) {
            int digit = Integer.parseInt(m.match.substring(1, 2));
            if (digit == 0 || digit > groups.size()) continue;
            edited.append(input, last, (int)m.start).append(groups.get(digit));
            last = m.end;
        }
        if (last != input.length()) {
            edited.append(input.substring(last));
        }
        return edited.toString();
    }

    public static Optional<List<StringMatch>> findMatches(String input, String toMatch, FindType type) {
        IFinder finder = type.getFinder();
        if (finder == null) {
            return Optional.empty();
        }
        TreeSet<StringMatch> matches = new TreeSet<StringMatch>(finder.getMatches(input, toMatch));
        if (matches.size() != 0) {
            return Optional.of(new ArrayList<StringMatch>(matches));
        }
        return Optional.empty();
    }

    public static Optional<List<StringMatch>> findMatches(class_2561 input, String toMatch, FindType type) {
        IFinder finder = type.getFinder();
        if (finder == null) {
            return Optional.empty();
        }
        TreeSet<StringMatch> matches = new TreeSet<StringMatch>(finder.getMatches(input, toMatch));
        if (matches.size() != 0) {
            return Optional.of(new ArrayList<StringMatch>(matches));
        }
        return Optional.empty();
    }

    public static Optional<StringMatch> getMatch(String input, String toMatch, FindType type) {
        IFinder finder = type.getFinder();
        if (finder == null) {
            return Optional.empty();
        }
        TreeSet<StringMatch> matches = new TreeSet<StringMatch>(finder.getMatches(input, toMatch));
        if (matches.size() != 0) {
            return Optional.of(matches.toArray(new StringMatch[0])[0]);
        }
        return Optional.empty();
    }

    public static Optional<StringMatch> getMatch(class_2561 input, String toMatch, FindType type) {
        IFinder finder = type.getFinder();
        if (finder == null) {
            return Optional.empty();
        }
        TreeSet<StringMatch> matches = new TreeSet<StringMatch>(finder.getMatches(input, toMatch));
        if (matches.size() != 0) {
            return Optional.of(matches.toArray(new StringMatch[0])[0]);
        }
        return Optional.empty();
    }

    public static MessageOwner getAuthor(class_634 networkHandler, String text) {
        if (networkHandler == null) {
            return null;
        }
        Optional<List<StringMatch>> words = SearchUtils.findMatches(SearchUtils.stripColorCodes(text), ((ConfigString)ConfigStorage.General.MESSAGE_OWNER_REGEX.config).getStringValue(), FindType.REGEX);
        if (!words.isPresent()) {
            return null;
        }
        class_640 player = null;
        StringMatch match = null;
        block0: for (StringMatch m : words.get()) {
            if (player != null) break;
            for (class_640 e : networkHandler.method_2880()) {
                if ((e.method_2971() == null || !m.match.equals(SearchUtils.stripColorCodes(e.method_2971().getString()))) && !m.match.equals(e.method_2966().getName())) continue;
                player = e;
                match = m;
                continue block0;
            }
        }
        HashMap<class_640, List<StringMatch>> entryMatches = new HashMap<class_640, List<StringMatch>>();
        for (class_640 e : networkHandler.method_2880()) {
            String name = SearchUtils.stripColorCodes(e.method_2971() == null ? e.method_2966().getName() : e.method_2971().getString());
            Optional<List<StringMatch>> nameWords = SearchUtils.findMatches(name, ((ConfigString)ConfigStorage.General.MESSAGE_OWNER_REGEX.config).getStringValue(), FindType.REGEX);
            if (!nameWords.isPresent()) continue;
            entryMatches.put(e, nameWords.get());
        }
        for (StringMatch m : words.get()) {
            for (Map.Entry entry : entryMatches.entrySet()) {
                for (StringMatch nm : (List)entry.getValue()) {
                    if (!nm.match.equals(m.match)) continue;
                    if (player != null && match.start <= m.start) {
                        return new MessageOwner(match.match, player);
                    }
                    return new MessageOwner(nm.match, (class_640)entry.getKey());
                }
            }
        }
        return null;
    }

    public static String stripColorCodes(String string) {
        return string.replaceAll("\u00a7.", "");
    }

    public static String toRoman(int number) {
        int l;
        boolean neg = false;
        if (number == 0) {
            return "O";
        }
        if (number < 0) {
            neg = true;
            number = -1 * number;
        }
        if (number == (l = map.floorKey(number).intValue())) {
            return map.get(number);
        }
        if (neg) {
            return "-" + map.get(l) + SearchUtils.toRoman(number - l);
        }
        return map.get(l) + SearchUtils.toRoman(number - l);
    }

    private SearchUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
    }
}

