/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import io.github.darkkronicle.advancedchatcore.finder.RegexFinder;
import io.github.darkkronicle.advancedchatcore.interfaces.IFinder;
import io.github.darkkronicle.advancedchatcore.util.FindType;
import io.github.darkkronicle.advancedchatcore.util.SearchUtils;
import io.github.darkkronicle.advancedchatcore.util.StringMatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class SearchResult {
    private final List<StringMatch> matches;
    private final IFinder finder;
    private final String input;
    private final String search;

    public SearchResult(String input, String search, IFinder finder, List<StringMatch> matches) {
        this.input = input;
        this.search = search;
        this.finder = finder;
        this.matches = new ArrayList<StringMatch>(matches);
        Collections.sort(this.matches);
    }

    public int size() {
        return this.matches.size();
    }

    public StringMatch getGroup(StringMatch match, int num) {
        if (!this.matches.contains(match)) {
            return null;
        }
        if (!(this.finder instanceof RegexFinder)) {
            return match;
        }
        try {
            RegexFinder regex = (RegexFinder)this.finder;
            Pattern p = regex.getPattern(this.input);
            if (p == null) {
                return null;
            }
            Matcher matcher = p.matcher(match.match);
            String group = matcher.group(num);
            int start = matcher.start(num);
            int end = matcher.start(num);
            return new StringMatch(group, start, end);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getGroupReplacements(String string, int matchIndex) {
        if (matchIndex >= 0) {
            IFinder iFinder = this.finder;
            if (iFinder instanceof RegexFinder) {
                RegexFinder regex = (RegexFinder)iFinder;
                try {
                    Pattern p = regex.getPattern(this.search);
                    if (p != null) {
                        return p.matcher(this.matches.get((int)matchIndex).match).replaceAll(string);
                    }
                }
                catch (Exception p) {
                    // empty catch block
                }
            }
            return SearchUtils.replaceGroups(Collections.singletonList(this.matches.get(0)), string);
        }
        Object p = this.finder;
        if (p instanceof RegexFinder) {
            RegexFinder regex = (RegexFinder)p;
            try {
                p = regex.getPattern(this.search);
                if (p != null) {
                    return ((Pattern)p).matcher(this.input).replaceAll(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return SearchUtils.replaceGroups(this.matches, string);
    }

    public static SearchResult searchOf(String input, String match, FindType type) {
        IFinder finder = type.getFinder();
        List<StringMatch> matches = finder.getMatches(input, match);
        return new SearchResult(input, match, finder, matches);
    }

    public static SearchResult searchOf(class_2561 input, String match, FindType type) {
        IFinder finder = type.getFinder();
        List<StringMatch> matches = finder.getMatches(input, match);
        return new SearchResult(input.getString(), match, finder, matches);
    }

    public List<StringMatch> getMatches() {
        return this.matches;
    }

    public IFinder getFinder() {
        return this.finder;
    }

    public String getInput() {
        return this.input;
    }

    public String getSearch() {
        return this.search;
    }
}

