/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import fi.dy.masa.malilib.util.FileUtils;
import io.github.darkkronicle.advancedchatcore.AdvancedChatCore;
import io.github.darkkronicle.advancedchatcore.util.FindType;
import io.github.darkkronicle.advancedchatcore.util.SearchUtils;
import io.github.darkkronicle.advancedchatcore.util.StringMatch;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.Level;

@Environment(value=EnvType.CLIENT)
public class ProfanityUtil {
    private final Map<Float, List<String>> words = new HashMap<Float, List<String>>();
    private int largestWordLength = 0;
    private static final ProfanityUtil INSTANCE = new ProfanityUtil();

    public static ProfanityUtil getInstance() {
        return INSTANCE;
    }

    private ProfanityUtil() {
    }

    public void loadConfigs() {
        try {
            File file = FileUtils.getConfigDirectory().toPath().resolve("advancedchat").resolve("swear_words.csv").toFile();
            InputStreamReader fileReader = !file.exists() ? new InputStreamReader(AdvancedChatCore.getResource("swear_words.csv"), StandardCharsets.UTF_8) : new FileReader(file);
            CSVParser csv = new CSVParser((Reader)fileReader, CSVFormat.DEFAULT.withFirstRecordAsHeader().withIgnoreHeaderCase());
            int counter = 0;
            for (CSVRecord record : csv) {
                ++counter;
                try {
                    String word = record.get("text");
                    float severity = Float.parseFloat(record.get("severity_rating"));
                    if (word.length() > this.largestWordLength) {
                        this.largestWordLength = word.length();
                    }
                    if (!this.words.containsKey(Float.valueOf(severity))) {
                        this.words.put(Float.valueOf(severity), new ArrayList());
                    }
                    this.words.get(Float.valueOf(severity)).add(word);
                }
                catch (Exception e) {
                    AdvancedChatCore.LOGGER.log(Level.ERROR, "Error while initializing profanity words", (Throwable)e);
                }
            }
            AdvancedChatCore.LOGGER.log(Level.INFO, "Loaded " + counter + " words to profanity filter.");
        }
        catch (IOException | URISyntaxException e) {
            AdvancedChatCore.LOGGER.log(Level.ERROR, "Error loading swear_words.csv", (Throwable)e);
        }
    }

    public List<StringMatch> getBadWords(String input, float severity, boolean onlyWordBoundaries) {
        int index;
        List wordBoundaries;
        if (input == null) {
            return new ArrayList<StringMatch>();
        }
        ArrayList<StringMatch> badWords = new ArrayList<StringMatch>();
        input = input.toLowerCase();
        if (onlyWordBoundaries) {
            wordBoundaries = SearchUtils.findMatches(input, "\\b", FindType.REGEX).map(matches -> matches.stream().map(m -> m.start).toList()).orElseGet(ArrayList::new);
            if (wordBoundaries.size() == 0) {
                return new ArrayList<StringMatch>();
            }
        } else {
            wordBoundaries = new ArrayList();
        }
        List<String> wordsToFind = this.getAboveSeverity(severity);
        int boundaryIndex = 0;
        int n = index = onlyWordBoundaries ? (Integer)wordBoundaries.get(0) : 0;
        while (index < input.length()) {
            for (int offset = 1; offset < input.length() + 1 - index && offset < this.largestWordLength; ++offset) {
                String wordToCheck = input.substring(index, index + offset);
                if (!wordsToFind.contains(wordToCheck) || onlyWordBoundaries && !wordBoundaries.contains(index + offset)) continue;
                badWords.add(new StringMatch(wordToCheck, index, index + offset));
            }
            if (onlyWordBoundaries) {
                if (++boundaryIndex >= wordBoundaries.size()) break;
                index = (Integer)wordBoundaries.get(boundaryIndex);
                continue;
            }
            ++index;
        }
        return badWords;
    }

    public List<String> getAboveSeverity(float severity) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<Float, List<String>> entry : this.words.entrySet()) {
            if (!(entry.getKey().floatValue() >= severity)) continue;
            list.addAll((Collection<String>)entry.getValue());
        }
        return list;
    }

    public Map<Float, List<String>> getWords() {
        return this.words;
    }

    public int getLargestWordLength() {
        return this.largestWordLength;
    }
}

