/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

public class LimitedInteger {
    private Integer value;
    private Integer limit;

    public LimitedInteger(int limit) {
        this(limit, 0);
    }

    public LimitedInteger(int limit, int start) {
        this.limit = limit;
        this.value = start;
    }

    public boolean incrementIfLimited(int increment) {
        if (this.value >= this.limit) {
            return false;
        }
        this.value = this.value + increment;
        return true;
    }

    public boolean incrementAndCheck(int increment) {
        this.value = this.value + increment;
        return this.value >= this.limit;
    }

    public boolean incrementIfPossible(int increment) {
        if (this.value + increment >= this.limit) {
            return false;
        }
        this.value = this.value + increment;
        return true;
    }

    public boolean isPossible(int increment) {
        return this.value + increment < this.limit;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public Integer getValue() {
        return this.value;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

