/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.finder.CustomFinder;
import io.github.darkkronicle.advancedchatcore.finder.LiteralFinder;
import io.github.darkkronicle.advancedchatcore.finder.RegexFinder;
import io.github.darkkronicle.advancedchatcore.finder.UpperLowerFinder;
import io.github.darkkronicle.advancedchatcore.interfaces.IFinder;
import java.util.function.Supplier;

public enum FindType implements IConfigOptionListEntry
{
    LITERAL("literal", LiteralFinder::new),
    UPPERLOWER("upperlower", UpperLowerFinder::new),
    REGEX("regex", RegexFinder::new),
    CUSTOM("custom", CustomFinder::getInstance);

    public final String configString;
    private final Supplier<IFinder> finder;

    private static String translate(String key) {
        return StringUtils.translate((String)("advancedchat.config.findtype." + key), (Object[])new Object[0]);
    }

    private FindType(String configString, Supplier<IFinder> finder) {
        this.configString = configString;
        this.finder = finder;
    }

    public IFinder getFinder() {
        return this.finder.get();
    }

    public String getStringValue() {
        return this.configString;
    }

    public String getDisplayName() {
        return FindType.translate(this.configString);
    }

    public FindType cycle(boolean forward) {
        int id = this.ordinal();
        id = forward ? ++id : --id;
        if (id >= FindType.values().length) {
            id = 0;
        } else if (id < 0) {
            id = FindType.values().length - 1;
        }
        return FindType.values()[id % FindType.values().length];
    }

    public FindType fromString(String value) {
        return FindType.fromFindType(value);
    }

    public static FindType fromFindType(String findtype) {
        for (FindType r : FindType.values()) {
            if (!r.configString.equals(findtype)) continue;
            return r;
        }
        return LITERAL;
    }
}

