/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

public interface EasingMethod {
    public double apply(double var1);

    public static enum Method implements EasingMethod
    {
        LINEAR(x -> x),
        SINE(x -> 1.0 - Math.cos(x * Math.PI / 2.0)),
        QUAD(x -> x * x),
        QUART(x -> x * x * x * x),
        CIRC(x -> 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0)));

        private final EasingMethod method;

        private Method(EasingMethod method) {
            this.method = method;
        }

        @Override
        public double apply(double x) {
            if (x < 0.0) {
                return 0.0;
            }
            if (x > 1.0) {
                return 1.0;
            }
            return this.method.apply(x);
        }
    }
}

