/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import io.github.darkkronicle.advancedchatcore.AdvancedChatCore;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.TomlUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

@Environment(value=EnvType.CLIENT)
public class Colors {
    private static final Colors INSTANCE = new Colors();
    private final Map<String, Color> colors = new HashMap<String, Color>();
    private final Map<String, Palette> palettes = new HashMap<String, Palette>();
    private String defaultPalette = "";

    public static Colors getInstance() {
        return INSTANCE;
    }

    private Colors() {
    }

    public void load() {
        Optional palettes;
        FileConfig config;
        Optional customColors;
        this.colors.clear();
        this.palettes.clear();
        File file = fi.dy.masa.malilib.util.FileUtils.getConfigDirectory().toPath().resolve("advancedchat").resolve("colors.toml").toFile();
        if (!file.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)AdvancedChatCore.getResource("colors.toml"), (File)file);
            }
            catch (Exception e) {
                AdvancedChatCore.LOGGER.log(Level.ERROR, "Colors could not be loaded correctly!", (Throwable)e);
                return;
            }
        }
        if ((customColors = (config = TomlUtil.loadFileWithDefaults(file, "colors.toml")).getOptional("color")).isPresent()) {
            for (Object entry : ((Config)customColors.get()).entrySet()) {
                this.colors.put(entry.getKey(), Colors.hexToSimple((String)entry.getValue()));
            }
        }
        if ((palettes = config.getOptional("palettes")).isPresent()) {
            for (Config.Entry entry : ((Config)palettes.get()).entrySet()) {
                ArrayList<Color> colors = new ArrayList<Color>();
                for (String c : (List)entry.getValue()) {
                    if (this.colors.containsKey(c)) {
                        colors.add(this.colors.get(c));
                        continue;
                    }
                    colors.add(Colors.hexToSimple(c));
                }
                this.palettes.put(entry.getKey(), new Palette(colors));
            }
        }
        Optional defaultPalette = config.getOptional("default_palette");
        defaultPalette.ifPresent(s -> {
            this.defaultPalette = s;
        });
        config.close();
    }

    public Palette getDefault() {
        if (this.palettes.containsKey(this.defaultPalette)) {
            return this.palettes.get(this.defaultPalette);
        }
        AdvancedChatCore.LOGGER.log(Level.WARN, "Default Palette " + this.defaultPalette + " does not exist!");
        return this.palettes.values().toArray(new Palette[0])[0];
    }

    public Optional<Palette> get(String name) {
        Palette palette = this.palettes.get(name);
        if (palette != null) {
            return Optional.of(palette);
        }
        return Optional.empty();
    }

    private static Color hexToSimple(String string) {
        if (string.length() != 7 && string.length() != 9) {
            AdvancedChatCore.LOGGER.log(Level.WARN, "Color " + string + " isn't formatted correctly! (#ffffff) (#ffffffff)");
            return new Color(255, 255, 255, 255);
        }
        string = string.substring(1);
        try {
            int red = Integer.parseInt(string.substring(0, 2), 16);
            int green = Integer.parseInt(string.substring(2, 4), 16);
            int blue = Integer.parseInt(string.substring(4, 6), 16);
            int alpha = 255;
            if (string.length() == 8) {
                alpha = Integer.parseInt(string.substring(6));
            }
            return new Color(red, green, blue, alpha);
        }
        catch (Exception e) {
            AdvancedChatCore.LOGGER.log(Level.WARN, "Couldn't convert " + string + " into a color!", (Throwable)e);
            return new Color(255, 255, 255, 255);
        }
    }

    public Optional<Color> getColor(String key) {
        if (this.colors.containsKey(key)) {
            return Optional.of(this.colors.get(key));
        }
        return Optional.empty();
    }

    public Color getColorOrWhite(String key) {
        return this.getColor(key).orElse(new Color(255, 255, 255, 255));
    }

    public Map<String, Color> getColors() {
        return this.colors;
    }

    public Map<String, Palette> getPalettes() {
        return this.palettes;
    }

    public static class Palette {
        private final List<Color> colors;

        public Palette(List<Color> colors) {
            this.colors = colors;
        }

        public List<Color> getColors() {
            return this.colors;
        }
    }
}

