/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import io.github.darkkronicle.advancedchatcore.util.ColorUtil;

public final class Color {
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;
    private final int color;

    public Color(int color) {
        this.color = color;
        Color completeColor = ColorUtil.intToColor4f(color);
        this.red = completeColor.red();
        this.green = completeColor.green();
        this.blue = completeColor.blue();
        this.alpha = completeColor.alpha();
    }

    public Color(int red, int green, int blue, int alpha) {
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.color = ColorUtil.colorToInt4f(this);
    }

    public Color(int red, int green, int blue, int alpha, int color) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.color = ColorUtil.colorToInt4f(this);
    }

    public String getString() {
        return String.format("#%08X", this.color);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Color)) {
            return false;
        }
        Color other = (Color)o;
        if (this.red() != other.red()) {
            return false;
        }
        if (this.green() != other.green()) {
            return false;
        }
        if (this.blue() != other.blue()) {
            return false;
        }
        if (this.alpha() != other.alpha()) {
            return false;
        }
        return this.color() == other.color();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.red();
        result = result * 59 + this.green();
        result = result * 59 + this.blue();
        result = result * 59 + this.alpha();
        result = result * 59 + this.color();
        return result;
    }

    public String toString() {
        return "Color(red=" + this.red() + ", green=" + this.green() + ", blue=" + this.blue() + ", alpha=" + this.alpha() + ", color=" + this.color() + ")";
    }

    public int red() {
        return this.red;
    }

    public int green() {
        return this.green;
    }

    public int blue() {
        return this.blue;
    }

    public int alpha() {
        return this.alpha;
    }

    public Color withAlpha(int alpha) {
        return this.alpha == alpha ? this : new Color(this.red, this.green, this.blue, alpha, this.color);
    }

    public int color() {
        return this.color;
    }
}

