/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.util;

import io.github.darkkronicle.advancedchatcore.interfaces.RegistryOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;

public abstract class AbstractRegistry<TYPE, OPTION extends RegistryOption<TYPE>> {
    private List<OPTION> options = new ArrayList<OPTION>();
    private OPTION defaultOption;

    public List<OPTION> getAll() {
        return this.options;
    }

    protected void add(OPTION option) {
        if (this.defaultOption == null) {
            this.defaultOption = option;
        }
        this.options.add(option);
    }

    public void register(Supplier<TYPE> replace, String saveString, String translation, String infoTranslation) {
        this.register(replace, saveString, translation, infoTranslation, true, false);
    }

    public void register(Supplier<TYPE> replace, String saveString, String translation, String infoTranslation, boolean active, boolean setDefault) {
        this.register(replace, saveString, translation, infoTranslation, active, setDefault, false);
    }

    public void register(Supplier<TYPE> replace, String saveString, String translation, String infoTranslation, boolean active, boolean setDefault, boolean hidden) {
        OPTION option = this.constructOption(replace, saveString, translation, infoTranslation, active, setDefault, hidden);
        this.options.add(option);
        if (setDefault || this.defaultOption == null) {
            this.defaultOption = option;
        }
    }

    public abstract AbstractRegistry<TYPE, OPTION> clone();

    public abstract OPTION constructOption(Supplier<TYPE> var1, String var2, String var3, String var4, boolean var5, boolean var6, boolean var7);

    public void setDefaultOption(@NonNull OPTION newDefault) {
        if (newDefault == null) {
            throw new NullPointerException("newDefault is marked non-null but is null");
        }
        this.defaultOption = newDefault;
    }

    public OPTION fromString(String string) {
        for (RegistryOption m : this.options) {
            if (!m.getSaveString().equals(string)) continue;
            return (OPTION)m;
        }
        return this.defaultOption;
    }

    public OPTION getNext(OPTION option, boolean forward) {
        if (this.options.size() == 0) {
            return null;
        }
        int i = this.options.indexOf(option);
        if (i < 0) {
            return (OPTION)((RegistryOption)this.options.get(0));
        }
        if (forward) {
            if (++i >= this.options.size()) {
                return (OPTION)((RegistryOption)this.options.get(0));
            }
        } else if (--i < 0) {
            return (OPTION)((RegistryOption)this.options.get(this.options.size() - 1));
        }
        return (OPTION)((RegistryOption)this.options.get(i));
    }

    public OPTION getDefaultOption() {
        return this.defaultOption;
    }
}

