/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.konstruct;

import io.github.darkkronicle.Konstruct.functions.Function;
import io.github.darkkronicle.Konstruct.functions.NamedFunction;
import io.github.darkkronicle.Konstruct.functions.Variable;
import io.github.darkkronicle.Konstruct.nodes.Node;
import io.github.darkkronicle.Konstruct.parser.IntRange;
import io.github.darkkronicle.Konstruct.parser.NodeProcessor;
import io.github.darkkronicle.Konstruct.parser.ParseContext;
import io.github.darkkronicle.Konstruct.parser.ParseResult;
import io.github.darkkronicle.Konstruct.parser.Result;
import io.github.darkkronicle.Konstruct.reader.builder.NodeBuilder;
import io.github.darkkronicle.Konstruct.type.IntegerObject;
import io.github.darkkronicle.Konstruct.type.StringObject;
import io.github.darkkronicle.addons.CalculatorFunction;
import io.github.darkkronicle.addons.IsMatchFunction;
import io.github.darkkronicle.addons.OwOFunction;
import io.github.darkkronicle.addons.RandomFunction;
import io.github.darkkronicle.addons.ReplaceFunction;
import io.github.darkkronicle.addons.RomanNumeralFunction;
import io.github.darkkronicle.addons.RoundFunction;
import io.github.darkkronicle.addons.TimeFunction;
import io.github.darkkronicle.advancedchatcore.AdvancedChatCore;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.Colors;
import io.github.darkkronicle.advancedchatcore.util.TextUtil;
import java.util.List;
import net.minecraft.class_156;
import org.mariuszgromada.math.mxparser.PrimitiveElement;

public class AdvancedChatKonstruct {
    private static final AdvancedChatKonstruct INSTANCE = new AdvancedChatKonstruct();
    private NodeProcessor processor;

    public static AdvancedChatKonstruct getInstance() {
        return INSTANCE;
    }

    private AdvancedChatKonstruct() {
        this.reset();
        this.addFunction((NamedFunction)new CalculatorFunction(new PrimitiveElement[0]));
        this.addFunction((NamedFunction)new RandomFunction());
        this.addFunction((NamedFunction)new ReplaceFunction());
        this.addFunction((NamedFunction)new RoundFunction());
        this.addFunction((NamedFunction)new OwOFunction());
        this.addFunction((NamedFunction)new RomanNumeralFunction());
        this.addFunction((NamedFunction)new IsMatchFunction());
        this.addFunction((NamedFunction)new TimeFunction());
        this.addVariable("server", () -> new StringObject(AdvancedChatCore.getServer()));
        this.addFunction("randomString", new Function(){

            public Result parse(ParseContext context, List<Node> input) {
                return Result.success((String)AdvancedChatCore.getRandomString());
            }

            public IntRange getArgumentCount() {
                return IntRange.none();
            }
        });
        this.addFunction("getColor", new Function(){

            public Result parse(ParseContext context, List<Node> input) {
                Result res = Function.parseArgument((ParseContext)context, input, (int)0);
                if (Function.shouldReturn((Result)res)) {
                    return res;
                }
                Color color = Colors.getInstance().getColorOrWhite(res.getContent().getString());
                return Result.success((String)color.getString());
            }

            public IntRange getArgumentCount() {
                return IntRange.of((int)1);
            }
        });
        this.addFunction("superscript", new Function(){

            public Result parse(ParseContext context, List<Node> input) {
                int number;
                try {
                    Result res = Function.parseArgument((ParseContext)context, input, (int)0);
                    if (Function.shouldReturn((Result)res)) {
                        return res;
                    }
                    number = Integer.parseInt(res.getContent().getString().strip());
                }
                catch (NumberFormatException e) {
                    return Result.success((String)"NaN");
                }
                return Result.success((String)TextUtil.toSuperscript(number));
            }

            public IntRange getArgumentCount() {
                return IntRange.of((int)1);
            }
        });
        this.addVariable("ms", () -> new IntegerObject((int)class_156.method_658()));
    }

    public ParseResult parse(Node node) {
        return this.processor.parse(node);
    }

    public Node getNode(String string) {
        return new NodeBuilder(string).build();
    }

    public NodeProcessor copy() {
        return this.processor.copy();
    }

    public void reset() {
        this.processor = new NodeProcessor();
    }

    public void addVariable(String key, Variable variable) {
        this.processor.addVariable(key, variable);
    }

    public void addFunction(NamedFunction function) {
        this.processor.addFunction(function);
    }

    public void addFunction(String key, Function function) {
        this.processor.addFunction(key, function);
    }

    public NodeProcessor getProcessor() {
        return this.processor;
    }
}

