/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.hotkeys;

import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputHandler
implements IKeybindProvider,
IKeyboardInputHandler,
IMouseInputHandler {
    private static final InputHandler INSTANCE = new InputHandler();
    private final Map<String, List<ConfigHotkey>> hotkeys = new HashMap<String, List<ConfigHotkey>>();
    private final Map<String, String> translation = new HashMap<String, String>();

    public static InputHandler getInstance() {
        return INSTANCE;
    }

    private InputHandler() {
    }

    public void clear(String modId) {
        this.hotkeys.remove(modId);
    }

    public void addDisplayName(String modId, String displayName) {
        this.translation.put(modId, displayName);
    }

    public void add(String modId, ConfigHotkey hotkey) {
        if (!this.hotkeys.containsKey(modId)) {
            this.hotkeys.put(modId, new ArrayList());
        }
        this.hotkeys.get(modId).add(hotkey);
    }

    public void add(String modId, ConfigHotkey hotkey, IHotkeyCallback callback) {
        hotkey.getKeybind().setCallback(callback);
        this.add(modId, hotkey);
    }

    public void addKeysToMap(IKeybindManager manager) {
        for (List<ConfigHotkey> hots : this.hotkeys.values()) {
            for (IHotkey iHotkey : hots) {
                manager.addKeybindToMap(iHotkey.getKeybind());
            }
        }
    }

    public void addHotkeys(IKeybindManager manager) {
        for (Map.Entry<String, List<ConfigHotkey>> hots : this.hotkeys.entrySet()) {
            manager.addHotkeysForCategory(hots.getKey(), "hotkeys", hots.getValue());
        }
    }

    public void reload() {
        InputEventHandler.getKeybindManager().updateUsedKeys();
    }

    public String getDisplayName(String key) {
        return this.translation.getOrDefault(key, key);
    }

    public Map<String, List<ConfigHotkey>> getHotkeys() {
        return this.hotkeys;
    }

    public Map<String, String> getTranslation() {
        return this.translation;
    }
}

