/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.render.RenderUtils;
import io.github.darkkronicle.advancedchatcore.util.Colors;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public abstract class WidgetConfigListEntry<TYPE>
extends WidgetListEntryBase<TYPE> {
    private final boolean odd;
    private final List<String> hoverLines;
    private int buttonStartX;

    public WidgetConfigListEntry(int x, int y, int width, int height, boolean isOdd, TYPE entry, int listIndex) {
        this(x, y, width, height, isOdd, entry, listIndex, null);
    }

    public WidgetConfigListEntry(int x, int y, int width, int height, boolean isOdd, TYPE entry, int listIndex, List<String> hoverLines) {
        super(x, y, width, height, entry, listIndex);
        this.odd = isOdd;
        this.hoverLines = hoverLines;
        this.buttonStartX = x + width;
    }

    public String getName() {
        return "";
    }

    public List<TextFieldWrapper<GuiTextFieldGeneric>> getTextFields() {
        return null;
    }

    public void render(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (selected || this.isMouseOver(mouseX, mouseY)) {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)Colors.getInstance().getColorOrWhite("white").withAlpha(150).color());
        } else if (this.odd) {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)Colors.getInstance().getColorOrWhite("white").withAlpha(70).color());
        } else {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)Colors.getInstance().getColorOrWhite("white").withAlpha(50).color());
        }
        this.renderEntry(mouseX, mouseY, selected, matrixStack);
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        this.drawTextFields(mouseX, mouseY, matrixStack);
        super.render(mouseX, mouseY, selected, matrixStack);
        RenderUtils.disableDiffuseLighting();
    }

    public void renderEntry(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
        String name = this.getName();
        this.drawString(this.x + 4, this.y + 7, Colors.getInstance().getColorOrWhite("white").color(), name, matrixStack);
    }

    public void postRenderHovered(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
        super.postRenderHovered(mouseX, mouseY, selected, matrixStack);
        if (this.hoverLines == null) {
            return;
        }
        if (mouseX >= this.x && mouseX < this.buttonStartX && mouseY >= this.y && mouseY <= this.y + this.height) {
            RenderUtils.drawHoverText((int)mouseX, (int)mouseY, this.hoverLines, (class_4587)matrixStack);
        }
    }

    protected boolean onKeyTypedImpl(int keyCode, int scanCode, int modifiers) {
        if (this.getTextFields() == null) {
            return false;
        }
        for (TextFieldWrapper<GuiTextFieldGeneric> field : this.getTextFields()) {
            if (field == null || !field.isFocused()) continue;
            return field.onKeyTyped(keyCode, scanCode, modifiers);
        }
        return false;
    }

    protected boolean onCharTypedImpl(char charIn, int modifiers) {
        if (this.getTextFields() != null) {
            for (TextFieldWrapper<GuiTextFieldGeneric> field : this.getTextFields()) {
                if (field == null || !field.onCharTyped(charIn, modifiers)) continue;
                return true;
            }
        }
        return super.onCharTypedImpl(charIn, modifiers);
    }

    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClickedImpl(mouseX, mouseY, mouseButton)) {
            return true;
        }
        boolean ret = false;
        if (this.getTextFields() != null) {
            for (TextFieldWrapper<GuiTextFieldGeneric> field : this.getTextFields()) {
                if (field == null) continue;
                ret = field.getTextField().method_25402((double)mouseX, (double)mouseY, mouseButton);
            }
        }
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                ret |= widget.isMouseOver(mouseX, mouseY) && widget.onMouseClicked(mouseX, mouseY, mouseButton);
            }
        }
        return ret;
    }

    protected void drawTextFields(int mouseX, int mouseY, class_4587 matrixStack) {
        if (this.getTextFields() == null) {
            return;
        }
        for (TextFieldWrapper<GuiTextFieldGeneric> field : this.getTextFields()) {
            field.getTextField().method_25394(matrixStack, mouseX, mouseY, 0.0f);
        }
    }

    public void setButtonStartX(int buttonStartX) {
        this.buttonStartX = buttonStartX;
    }

    public int getButtonStartX() {
        return this.buttonStartX;
    }
}

