/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.gui;

import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.TextUtil;
import java.util.LinkedHashMap;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class ContextMenu
extends WidgetBase {
    private final LinkedHashMap<class_2561, ContextConsumer> options;
    private class_2561 hoveredEntry = null;
    private final int contextX;
    private final int contextY;
    private Runnable close;
    private Color background;
    private Color hover;

    public ContextMenu(int x, int y, LinkedHashMap<class_2561, ContextConsumer> options, Runnable close) {
        this(x, y, options, close, new Color(0, 0, 0, 200), new Color(255, 255, 255, 100));
    }

    public ContextMenu(int x, int y, LinkedHashMap<class_2561, ContextConsumer> options, Runnable close, Color background, Color hover) {
        super(x, y, 10, 10);
        this.contextX = x;
        this.contextY = y;
        this.options = options;
        this.updateDimensions();
        this.close = close;
        this.background = background;
        this.hover = hover;
    }

    public void updateDimensions() {
        this.setWidth(TextUtil.getMaxLengthString(this.options.keySet().stream().map(class_2561::getString).toList()) + 4);
        int n = this.options.size();
        Objects.requireNonNull(this.textRenderer);
        this.setHeight(n * (9 + 2));
        int windowWidth = class_310.method_1551().method_22683().method_4486();
        int windowHeight = class_310.method_1551().method_22683().method_4502();
        if (this.x + this.width > windowWidth) {
            this.x = windowWidth - this.width;
        }
        if (this.y + this.height > windowHeight) {
            this.y = windowHeight - this.height;
        }
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean success = super.onMouseClicked(mouseX, mouseY, mouseButton);
        if (success) {
            return true;
        }
        this.close.run();
        return false;
    }

    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return false;
        }
        if (this.hoveredEntry == null) {
            return false;
        }
        this.options.get(this.hoveredEntry).takeAction(this.contextX, this.contextY);
        this.close.run();
        return true;
    }

    public void render(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
        ContextMenu.drawRect(matrixStack, this.x, this.y, this.width, this.height, this.background.color());
        int rX = this.x + 2;
        int rY = this.y + 2;
        this.hoveredEntry = null;
        for (class_2561 option : this.options.keySet()) {
            if (mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= rY - 2 && mouseY < rY + this.fontHeight + 1) {
                this.hoveredEntry = option;
                Objects.requireNonNull(this.textRenderer);
                ContextMenu.drawRect(matrixStack, rX - 2, rY - 2, this.width, 9 + 2, this.hover.color());
            }
            this.textRenderer.method_30881(matrixStack, option, (float)rX, (float)rY, -1);
            Objects.requireNonNull(this.textRenderer);
            rY += 9 + 2;
        }
    }

    private static void drawRect(class_4587 stack, int x, int y, int width, int height, int color) {
        class_332.method_25294((class_4587)stack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public int getContextX() {
        return this.contextX;
    }

    public int getContextY() {
        return this.contextY;
    }

    public Runnable getClose() {
        return this.close;
    }

    public void setClose(Runnable close) {
        this.close = close;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setHover(Color hover) {
        this.hover = hover;
    }

    public Color getHover() {
        return this.hover;
    }

    public static interface ContextConsumer {
        public void takeAction(int var1, int var2);
    }
}

