/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.finder;

import io.github.darkkronicle.advancedchatcore.AdvancedChatCore;
import io.github.darkkronicle.advancedchatcore.finder.PatternFinder;
import io.github.darkkronicle.advancedchatcore.util.FindType;
import io.github.darkkronicle.advancedchatcore.util.SearchUtils;
import io.github.darkkronicle.advancedchatcore.util.StringMatch;
import io.github.darkkronicle.advancedchatcore.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class RegexFinder
extends PatternFinder {
    @Override
    public Pattern getPattern(String toMatch) {
        try {
            return Pattern.compile(toMatch);
        }
        catch (PatternSyntaxException e) {
            AdvancedChatCore.LOGGER.error("The regex " + toMatch + " is invalid!");
            return null;
        }
    }

    @Override
    public List<StringMatch> getMatches(class_2561 input, String toMatch) {
        Optional<List<StringMatch>> optionalGroups = SearchUtils.findMatches(toMatch, "\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>", FindType.REGEX);
        if (optionalGroups.isEmpty()) {
            return this.getMatches(input.getString(), toMatch);
        }
        String string = input.getString();
        Pattern pattern = this.getPattern(toMatch);
        if (pattern == null) {
            return new ArrayList<StringMatch>();
        }
        Matcher matcher = pattern.matcher(string);
        List<String> groups = optionalGroups.get().stream().map(match -> match.match.substring(3, match.end - match.start - 1)).filter(match -> match.startsWith("adv")).toList();
        ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
        while (matcher.find()) {
            String total = matcher.group();
            int start = matcher.start();
            int stop = matcher.end();
            if (groups.isEmpty()) {
                matches.add(new StringMatch(total, start, stop));
                continue;
            }
            boolean stillMatches = true;
            for (String group : groups) {
                try {
                    if (RegexFinder.isAllowed(input, group, matcher)) continue;
                    stillMatches = false;
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            if (!stillMatches) continue;
            matches.add(new StringMatch(total, start, stop));
        }
        matcher.reset();
        return matches;
    }

    public static boolean isAllowed(class_2561 input, String group, Matcher matcher) {
        group = group.toLowerCase(Locale.ROOT);
        String groupText = matcher.group(group);
        String groupCondition = group.substring(3);
        if (groupText == null || groupCondition.isEmpty() || groupText.isEmpty()) {
            return true;
        }
        int start = matcher.start(group);
        int end = matcher.end(group);
        if (groupCondition.startsWith("0")) {
            groupCondition = groupCondition.substring(1);
            while (groupCondition.length() != 0) {
                class_124 formatting;
                class_2583 current;
                class_5251 color;
                class_5250 truncated = TextUtil.truncate(input, new StringMatch("", start, end));
                char val = groupCondition.charAt(0);
                groupCondition = groupCondition.substring(1);
                if (!(val == 'l' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10984() && style2.method_10984()) : (val == 'o' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10966() && style2.method_10966()) : (val == 'k' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10987() && style2.method_10987()) : (val == 'n' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10965() && style2.method_10965()) : (val == 'm' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10986() && style2.method_10986()) : (val == 'z' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10970() != null && style1.method_10970().method_10845() == class_2558.class_2559.field_11749 && style2.method_10970() != null && style2.method_10970().method_10845() == class_2558.class_2559.field_11749) : (val == 'x' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10970() != null && style1.method_10970().method_10845() == class_2558.class_2559.field_21462 && style2.method_10970() != null && style2.method_10970().method_10845() == class_2558.class_2559.field_21462) : (val == 'y' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10970() != null && style1.method_10970().method_10845() == class_2558.class_2559.field_11746 && style2.method_10970() != null && style2.method_10970().method_10845() == class_2558.class_2559.field_11746) : (val == 'w' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10970() != null && style1.method_10970().method_10845() == class_2558.class_2559.field_11750 && style2.method_10970() != null && style2.method_10970().method_10845() == class_2558.class_2559.field_11750) : (val == 'v' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10970() != null && style1.method_10970().method_10845() == class_2558.class_2559.field_11745 && style2.method_10970() != null && style2.method_10970().method_10845() == class_2558.class_2559.field_11745) : (val == 'h' ? !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> style1.method_10969() != null && style2.method_10969() != null) : !TextUtil.styleChanges((class_2561)truncated, (style1, style2) -> Objects.equals(style1.method_10973(), style2.method_10973())) && ((color = (current = truncated.method_10866()).method_10973()) == null ? val == 'f' : (formatting = class_124.method_544((char)val)) != null && formatting.method_543() && color.method_27716() == formatting.method_532().intValue()))))))))))))) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

