/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.finder;

import io.github.darkkronicle.advancedchatcore.interfaces.IFinder;
import io.github.darkkronicle.advancedchatcore.util.StringMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public abstract class PatternFinder
implements IFinder {
    @Nullable
    public abstract Pattern getPattern(String var1);

    @Override
    public boolean isMatch(String input, String toMatch) {
        Pattern pattern = this.getPattern(toMatch);
        if (pattern == null) {
            return false;
        }
        return pattern.matcher(input).find();
    }

    @Override
    public List<StringMatch> getMatches(String input, String toMatch) {
        ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
        Pattern pattern = this.getPattern(toMatch);
        if (pattern == null) {
            return matches;
        }
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            matches.add(new StringMatch(matcher.group(), matcher.start(), matcher.end()));
        }
        matcher.reset();
        return matches;
    }
}

