/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.config.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.Colors;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ConfigColor
extends fi.dy.masa.malilib.config.options.ConfigColor {
    private Color color;
    private final String defaultReference;
    private String reference = null;

    public ConfigColor(String name, Color defaultValue, String comment) {
        super(name, defaultValue.getString(), comment);
        this.color = defaultValue;
        this.defaultReference = null;
    }

    public ConfigColor(String name, String referenceDefault, String comment) {
        super(name, Colors.getInstance().getColorOrWhite(referenceDefault).toString(), comment);
        this.color = Colors.getInstance().getColorOrWhite(referenceDefault);
        this.defaultReference = referenceDefault;
    }

    public void resetToDefault() {
        if (this.defaultReference != null) {
            this.setValueFromString(this.defaultReference);
        } else {
            this.setValueFromString(new Color(this.defaultValue).getString());
        }
        this.onValueChanged();
    }

    public String getDefaultStringValue() {
        if (this.defaultReference == null) {
            return super.getDefaultStringValue();
        }
        return this.defaultReference;
    }

    public void setValueFromString(String value) {
        Optional<Color> color = Colors.getInstance().getColor(value);
        if (color.isPresent()) {
            this.setIntegerValue(color.get().color());
            this.reference = value;
            this.setColor();
            return;
        }
        this.reference = null;
        super.setValueFromString(value);
        this.setColor();
    }

    public String getStringValue() {
        if (this.reference != null) {
            return this.reference;
        }
        return super.getStringValue();
    }

    private void setColor() {
        this.color = new Color(this.getIntegerValue());
    }

    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                String value = element.getAsString();
                Optional<Color> color = Colors.getInstance().getColor(value);
                if (color.isPresent()) {
                    this.setIntegerValue(color.get().color());
                    this.reference = value;
                    this.setColor();
                    return;
                }
                this.value = this.getClampedValue(StringUtils.getColor((String)value, (int)0));
                this.setIntegerValue(this.value);
                this.setColor();
            } else {
                MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(this.getStringValue());
    }

    public Color get() {
        return this.color;
    }
}

