/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.config.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ButtonOnOff;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.config.gui.widgets.WidgetListRegistryOption;
import io.github.darkkronicle.advancedchatcore.interfaces.ConfigRegistryOption;
import io.github.darkkronicle.advancedchatcore.util.Colors;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class WidgetRegistryOptionEntry<T extends ConfigRegistryOption<?>>
extends WidgetListEntryBase<T> {
    private final WidgetListRegistryOption<T> parent;
    private final boolean isOdd;
    private final List<String> hoverLines;
    private final int buttonStartX;
    private final T option;

    public WidgetRegistryOptionEntry(int x, int y, int width, int height, boolean isOdd, T registryOption, int listIndex, WidgetListRegistryOption<T> parent) {
        super(x, y, width, height, registryOption, listIndex);
        this.parent = parent;
        this.isOdd = isOdd;
        this.hoverLines = registryOption.getHoverLines();
        this.option = registryOption;
        int pos = x + width - 2;
        pos -= this.addOnOffButton(pos, ++y, ButtonListener.Type.ACTIVE, this.option.isActive());
        if (this.option.getScreen((class_437)parent) != null) {
            pos -= this.addButton(pos, y, ButtonListener.Type.CONFIGURE);
        }
        this.buttonStartX = pos;
    }

    protected int addButton(int x, int y, ButtonListener.Type type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, true, type.getDisplayName(), new Object[0]);
        this.addButton((ButtonBase)button, new ButtonListener(type, this));
        return button.getWidth() + 1;
    }

    private int addOnOffButton(int xRight, int y, ButtonListener.Type type, boolean isCurrentlyOn) {
        ButtonOnOff button = new ButtonOnOff(xRight, y, -1, true, type.translate, isCurrentlyOn, new String[0]);
        this.addButton((ButtonBase)button, new ButtonListener(type, this));
        return button.getWidth() + 1;
    }

    public void render(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (selected || this.isMouseOver(mouseX, mouseY)) {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)Colors.getInstance().getColorOrWhite("white").withAlpha(150).color());
        } else if (this.isOdd) {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)Colors.getInstance().getColorOrWhite("white").withAlpha(70).color());
        } else {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)Colors.getInstance().getColorOrWhite("white").withAlpha(50).color());
        }
        String name = this.option.getDisplayName();
        this.drawString(this.x + 4, this.y + 7, Colors.getInstance().getColorOrWhite("white").color(), name, matrixStack);
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        super.render(mouseX, mouseY, selected, matrixStack);
        RenderUtils.disableDiffuseLighting();
    }

    public void postRenderHovered(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
        super.postRenderHovered(mouseX, mouseY, selected, matrixStack);
        if (this.hoverLines == null) {
            return;
        }
        if (mouseX >= this.x && mouseX < this.buttonStartX && mouseY >= this.y && mouseY <= this.y + this.height) {
            RenderUtils.drawHoverText((int)mouseX, (int)mouseY, this.hoverLines, (class_4587)matrixStack);
        }
    }

    private static class ButtonListener<T extends ConfigRegistryOption<?>>
    implements IButtonActionListener {
        private final Type type;
        private final WidgetRegistryOptionEntry<T> parent;

        public ButtonListener(Type type, WidgetRegistryOptionEntry<T> parent) {
            this.parent = parent;
            this.type = type;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            class_437 screen;
            if (this.type == Type.ACTIVE) {
                ((ConfigBoolean)this.parent.option.getActive().config).setBooleanValue(!this.parent.option.isActive());
                this.parent.parent.refreshEntries();
            } else if (this.type == Type.CONFIGURE && (screen = this.parent.option.getScreen(this.parent.parent.getParent()).get()) != null) {
                GuiBase.openGui((class_437)screen);
            }
        }

        public static enum Type {
            CONFIGURE("configure"),
            ACTIVE("active");

            private final String translate;

            private Type(String name) {
                this.translate = Type.translate(name);
            }

            private static String translate(String key) {
                return "advancedchat.config.button." + key;
            }

            public String getDisplayName() {
                return StringUtils.translate((String)this.translate, (Object[])new Object[0]);
            }
        }
    }
}

