/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.config.gui;

import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import io.github.darkkronicle.advancedchatcore.config.gui.widgets.WidgetToggle;
import io.github.darkkronicle.advancedchatcore.interfaces.Translatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OnOffListListener<T extends Translatable>
implements IButtonActionListener {
    private final ButtonGeneric button;
    private final WidgetToggle toggle;
    private T current;
    private HashMap<T, Boolean> onOff;
    private final List<T> order;

    public OnOffListListener(ButtonGeneric button, WidgetToggle toggle, HashMap<T, Boolean> onOff) {
        this.button = button;
        this.toggle = toggle;
        this.onOff = new HashMap<T, Boolean>(onOff);
        this.order = new ArrayList<T>(onOff.keySet());
        this.next();
    }

    public IButtonActionListener getButtonListener() {
        return (button1, mouseButton) -> this.onToggled();
    }

    private void onToggled() {
        this.onOff.put(this.current, this.toggle.isCurrentlyOn());
    }

    private void next() {
        int i = this.order.indexOf(this.current) + 1;
        if (i >= this.order.size()) {
            i = 0;
        }
        this.current = (Translatable)this.order.get(i);
        this.button.setDisplayString(this.current.translate());
        this.toggle.setOn(this.onOff.get(this.current));
    }

    public List<T> getOn() {
        ArrayList<Translatable> list = new ArrayList<Translatable>();
        for (Map.Entry<T, Boolean> entry : this.onOff.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            list.add((Translatable)entry.getKey());
        }
        return list;
    }

    public static <T extends Translatable> HashMap<T, Boolean> getOnOff(List<T> all, List<T> active) {
        HashMap<Translatable, Boolean> map = new HashMap<Translatable, Boolean>();
        for (Translatable a : all) {
            map.put(a, active.contains(a));
        }
        return map;
    }

    public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
        this.next();
    }
}

