/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.config.SaveableConfig;
import io.github.darkkronicle.advancedchatcore.config.options.ConfigColor;
import io.github.darkkronicle.advancedchatcore.interfaces.ConfigRegistryOption;
import io.github.darkkronicle.advancedchatcore.util.AbstractRegistry;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.Colors;
import io.github.darkkronicle.advancedchatcore.util.EasingMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ConfigStorage
implements IConfigHandler {
    public static final String CONFIG_FILE_NAME = "advancedchatcore.json";
    private static final int CONFIG_VERSION = 1;

    public static void loadFromFile() {
        JsonElement element;
        File v3 = FileUtils.getConfigDirectory().toPath().resolve(CONFIG_FILE_NAME).toFile();
        File configFile = v3.exists() && !FileUtils.getConfigDirectory().toPath().resolve("advancedchat").resolve(CONFIG_FILE_NAME).toFile().exists() ? v3 : FileUtils.getConfigDirectory().toPath().resolve("advancedchat").resolve(CONFIG_FILE_NAME).toFile();
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = ConfigStorage.parseJsonFile(configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigStorage.readOptions(root, "general", General.OPTIONS);
            ConfigStorage.readOptions(root, "chatscreen", ChatScreen.OPTIONS);
            ConfigStorage.readOptions(root, "hotkeys", Hotkeys.OPTIONS);
            int n = JsonUtils.getIntegerOrDefault((JsonObject)root, (String)"configVersion", (int)0);
        }
    }

    public static void applyRegistry(JsonElement element, AbstractRegistry<?, ? extends ConfigRegistryOption<?>> registry) {
        if (element == null || !element.isJsonObject()) {
            return;
        }
        JsonObject obj = element.getAsJsonObject();
        for (ConfigRegistryOption<?> option : registry.getAll()) {
            if (!obj.has(option.getSaveString())) continue;
            option.load(obj.get(option.getSaveString()));
        }
    }

    public static JsonObject saveRegistry(AbstractRegistry<?, ? extends ConfigRegistryOption<?>> registry) {
        JsonObject object = new JsonObject();
        for (ConfigRegistryOption<?> option : registry.getAll()) {
            object.add(option.getSaveString(), (JsonElement)option.save());
        }
        return object;
    }

    public static void saveFromFile() {
        File dir = FileUtils.getConfigDirectory().toPath().resolve("advancedchat").toFile();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigStorage.writeOptions(root, "general", General.OPTIONS);
            ConfigStorage.writeOptions(root, "chatscreen", ChatScreen.OPTIONS);
            ConfigStorage.writeOptions(root, "hotkeys", Hotkeys.OPTIONS);
            root.add("config_version", (JsonElement)new JsonPrimitive((Number)1));
            ConfigStorage.writeJsonToFile(root, new File(dir, CONFIG_FILE_NAME));
        }
    }

    public static void readOptions(JsonObject root, String category, List<SaveableConfig<?>> options) {
        JsonObject obj = JsonUtils.getNestedObject((JsonObject)root, (String)category, (boolean)false);
        if (obj != null) {
            for (SaveableConfig<?> conf : options) {
                Object option = conf.config;
                if (!obj.has(conf.key)) continue;
                option.setValueFromJsonElement(obj.get(conf.key));
            }
        }
    }

    public static JsonElement parseJsonFile(File file) {
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            String fileName = file.getAbsolutePath();
            try {
                Charset[] sets;
                JsonParser parser = new JsonParser();
                for (Charset s : sets = new Charset[]{StandardCharsets.UTF_8, Charset.defaultCharset()}) {
                    JsonElement element;
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), s);
                    try {
                        element = parser.parse((Reader)reader);
                    }
                    catch (Exception e) {
                        reader.close();
                        MaLiLib.logger.error("Failed to parse the JSON file '{}'. Attempting different charset. ", (Object)fileName, (Object)e);
                        continue;
                    }
                    reader.close();
                    return element;
                }
            }
            catch (Exception e) {
                MaLiLib.logger.error("Failed to parse the JSON file '{}'", (Object)fileName, (Object)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeJsonToFile(JsonObject root, File file) {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            writer.write(JsonUtils.GSON.toJson((JsonElement)root));
            writer.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            MaLiLib.logger.warn("Failed to write JSON data to file '{}'", (Object)file.getAbsolutePath(), (Object)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                MaLiLib.logger.warn("Failed to close JSON file", (Throwable)e);
            }
        }
        return false;
    }

    public static void writeOptions(JsonObject root, String category, List<SaveableConfig<?>> options) {
        JsonObject obj = JsonUtils.getNestedObject((JsonObject)root, (String)category, (boolean)true);
        for (SaveableConfig<?> option : options) {
            obj.add(option.key, option.config.getAsJsonElement());
        }
    }

    public void load() {
        ConfigStorage.loadFromFile();
    }

    public void save() {
        ConfigStorage.saveFromFile();
    }

    public static class General {
        public static final String NAME = "general";
        public static final SaveableConfig<ConfigString> TIME_FORMAT = SaveableConfig.fromConfig("timeFormat", new ConfigString(General.translate("timeformat"), "hh:mm", General.translate("info.timeformat")));
        public static final SaveableConfig<ConfigString> TIME_TEXT_FORMAT = SaveableConfig.fromConfig("timeTextFormat", new ConfigString(General.translate("timetextformat"), "[%TIME%] ", General.translate("info.timetextformat")));
        public static final SaveableConfig<ConfigColor> TIME_COLOR = SaveableConfig.fromConfig("time_color", new ConfigColor(General.translate("timecolor"), Colors.getInstance().getColor("white").get(), General.translate("info.timecolor")));
        public static final SaveableConfig<ConfigBoolean> SHOW_TIME = SaveableConfig.fromConfig("show_time", new ConfigBoolean(General.translate("showtime"), false, General.translate("info.showtime")));
        public static final SaveableConfig<ConfigBoolean> CLEAR_ON_DISCONNECT = SaveableConfig.fromConfig("clearOnDisconnect", new ConfigBoolean(General.translate("clearondisconnect"), true, General.translate("info.clearondisconnect")));
        public static final SaveableConfig<ConfigInteger> CHAT_STACK = SaveableConfig.fromConfig("chatStack", new ConfigInteger(General.translate("chatstack"), 0, 0, 20, General.translate("info.chatstack")));
        public static final SaveableConfig<ConfigBoolean> CHAT_STACK_UPDATE = SaveableConfig.fromConfig("chatStackUpdate", new ConfigBoolean(General.translate("chatstackupdate"), false, General.translate("info.chatstackupdate")));
        public static final SaveableConfig<ConfigString> MESSAGE_OWNER_REGEX = SaveableConfig.fromConfig("messageOwnerRegex", new ConfigString(General.translate("messageownerregex"), "(?<!\\[)\\b[A-Za-z0-9_\u00a7]{3,16}\\b(?!\\])", General.translate("info.messageownerregex")));
        public static final SaveableConfig<ConfigBoolean> FILTER_PROFANITY = SaveableConfig.fromConfig("filterProfanity", new ConfigBoolean(General.translate("filterprofanity"), false, General.translate("info.filterprofanity")));
        public static final SaveableConfig<ConfigBoolean> PROFANITY_ON_WORD_BOUNDARIES = SaveableConfig.fromConfig("profanityWordBoundaries", new ConfigBoolean(General.translate("profanitywordboundaries"), false, General.translate("info.profanitywordboundaries")));
        public static final SaveableConfig<ConfigDouble> PROFANITY_ABOVE = SaveableConfig.fromConfig("profanityAbove", new ConfigDouble(General.translate("profanityabove"), 0.0, 0.0, 3.0, General.translate("info.profanityabove")));
        public static final ImmutableList<SaveableConfig<? extends IConfigBase>> OPTIONS = ImmutableList.of(TIME_FORMAT, TIME_TEXT_FORMAT, TIME_COLOR, SHOW_TIME, CLEAR_ON_DISCONNECT, CHAT_STACK, CHAT_STACK_UPDATE, MESSAGE_OWNER_REGEX, FILTER_PROFANITY, PROFANITY_ABOVE, PROFANITY_ON_WORD_BOUNDARIES);

        public static String translate(String key) {
            return StringUtils.translate((String)("advancedchat.config.general." + key), (Object[])new Object[0]);
        }
    }

    public static class ChatScreen {
        public static final String NAME = "chatscreen";
        public static final SaveableConfig<ConfigBoolean> PERSISTENT_TEXT = SaveableConfig.fromConfig("persistentText", new ConfigBoolean(ChatScreen.translate("persistenttext"), false, ChatScreen.translate("info.persistenttext")));
        public static final SaveableConfig<ConfigColor> COLOR = SaveableConfig.fromConfig("color", new ConfigColor(ChatScreen.translate("color"), Colors.getInstance().getColor("black").get().withAlpha(100), ChatScreen.translate("info.color")));
        public static final SaveableConfig<ConfigBoolean> MORE_TEXT = SaveableConfig.fromConfig("moreText", new ConfigBoolean(ChatScreen.translate("moretext"), false, ChatScreen.translate("info.moretext")));
        public static final SaveableConfig<ConfigBoolean> SHOW_CHAT_ICONS = SaveableConfig.fromConfig("showChatIcons", new ConfigBoolean(ChatScreen.translate("showchaticons"), true, ChatScreen.translate("info.showchaticons")));
        public static final SaveableConfig<ConfigColor> MODIFIED = SaveableConfig.fromConfig("modified", new ConfigColor(ChatScreen.translate("modified"), new Color(15386724), ChatScreen.translate("info.modified")));
        public static final SaveableConfig<ConfigColor> SYSTEM = SaveableConfig.fromConfig("system", new ConfigColor(ChatScreen.translate("system"), new Color(0xA0A0A0), ChatScreen.translate("info.system")));
        public static final SaveableConfig<ConfigColor> FILTERED = SaveableConfig.fromConfig("filtered", new ConfigColor(ChatScreen.translate("filtered"), new Color(15386724), ChatScreen.translate("info.filtered")));
        public static final SaveableConfig<ConfigColor> NOT_SECURE = SaveableConfig.fromConfig("notSecure", new ConfigColor(ChatScreen.translate("notsecure"), new Color(15224664), ChatScreen.translate("info.notsecure")));
        public static final ImmutableList<SaveableConfig<? extends IConfigBase>> OPTIONS = ImmutableList.of(PERSISTENT_TEXT, COLOR, MORE_TEXT, SHOW_CHAT_ICONS, MODIFIED, SYSTEM, FILTERED, NOT_SECURE);

        public static String translate(String key) {
            return StringUtils.translate((String)("advancedchat.config.chatscreen." + key), (Object[])new Object[0]);
        }
    }

    public static class Hotkeys {
        public static final String NAME = "hotkeys";
        public static final SaveableConfig<ConfigHotkey> OPEN_CHAT = SaveableConfig.fromConfig("openChat", new ConfigHotkey(Hotkeys.translate("openchat"), "", KeybindSettings.create((KeybindSettings.Context)KeybindSettings.Context.INGAME, (KeyAction)KeyAction.PRESS, (boolean)false, (boolean)true, (boolean)false, (boolean)true), Hotkeys.translate("info.openchat")));
        public static final SaveableConfig<ConfigHotkey> TOGGLE_PERMANENT = SaveableConfig.fromConfig("togglePermanent", new ConfigHotkey(Hotkeys.translate("togglepermanentfocus"), "", KeybindSettings.create((KeybindSettings.Context)KeybindSettings.Context.INGAME, (KeyAction)KeyAction.PRESS, (boolean)false, (boolean)true, (boolean)false, (boolean)true), Hotkeys.translate("info.togglepermanentfocus")));
        public static final SaveableConfig<ConfigHotkey> OPEN_CHAT_WITH_LAST = SaveableConfig.fromConfig("openChatWithLast", new ConfigHotkey(Hotkeys.translate("openchatwithlast"), "UP", KeybindSettings.create((KeybindSettings.Context)KeybindSettings.Context.INGAME, (KeyAction)KeyAction.PRESS, (boolean)true, (boolean)true, (boolean)false, (boolean)true), Hotkeys.translate("info.openchatwithlast")));
        public static final SaveableConfig<ConfigHotkey> OPEN_CHAT_FREE_MOVEMENT = SaveableConfig.fromConfig("openChatFreeMovement", new ConfigHotkey(Hotkeys.translate("openchatfreemovement"), "", KeybindSettings.create((KeybindSettings.Context)KeybindSettings.Context.INGAME, (KeyAction)KeyAction.PRESS, (boolean)true, (boolean)true, (boolean)false, (boolean)true), Hotkeys.translate("info.openchatfreemovement")));
        public static final SaveableConfig<ConfigHotkey> OPEN_SETTINGS = SaveableConfig.fromConfig("openSettings", new ConfigHotkey(Hotkeys.translate("opensettings"), "", KeybindSettings.create((KeybindSettings.Context)KeybindSettings.Context.ANY, (KeyAction)KeyAction.PRESS, (boolean)false, (boolean)true, (boolean)false, (boolean)true), Hotkeys.translate("info.opensettings")));
        public static final ImmutableList<SaveableConfig<? extends IConfigBase>> OPTIONS = ImmutableList.of(OPEN_SETTINGS, OPEN_CHAT, OPEN_CHAT_FREE_MOVEMENT, TOGGLE_PERMANENT, OPEN_CHAT_WITH_LAST);

        public static String translate(String key) {
            return StringUtils.translate((String)("advancedchat.config.hotkeys." + key), (Object[])new Object[0]);
        }
    }

    public static enum Easing implements IConfigOptionListEntry,
    EasingMethod
    {
        LINEAR("linear", EasingMethod.Method.LINEAR),
        SINE("sine", EasingMethod.Method.SINE),
        QUAD("quad", EasingMethod.Method.QUAD),
        QUART("quart", EasingMethod.Method.QUART),
        CIRC("circ", EasingMethod.Method.CIRC);

        public final EasingMethod ease;
        public final String configString;

        private static String translate(String key) {
            return StringUtils.translate((String)("advancedchat.config.easing." + key), (Object[])new Object[0]);
        }

        private Easing(String configString, EasingMethod ease) {
            this.ease = ease;
            this.configString = configString;
        }

        public String getStringValue() {
            return this.configString;
        }

        public String getDisplayName() {
            return Easing.translate(this.configString);
        }

        public IConfigOptionListEntry cycle(boolean forward) {
            int id = this.ordinal();
            id = forward ? ++id : --id;
            if (id >= Easing.values().length) {
                id = 0;
            } else if (id < 0) {
                id = Easing.values().length - 1;
            }
            return Easing.values()[id % Easing.values().length];
        }

        public IConfigOptionListEntry fromString(String value) {
            return Easing.fromEasingString(value);
        }

        public static Easing fromEasingString(String visibility) {
            for (Easing e : Easing.values()) {
                if (!e.configString.equals(visibility)) continue;
                return e;
            }
            return LINEAR;
        }

        @Override
        public double apply(double v) {
            return this.ease.apply(v);
        }
    }
}

