/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.chat;

import io.github.darkkronicle.advancedchatcore.AdvancedChatCore;
import io.github.darkkronicle.advancedchatcore.interfaces.IStringFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_310;
import org.apache.logging.log4j.Level;

public class MessageSender {
    private static final MessageSender INSTANCE = new MessageSender();
    private final class_310 client = class_310.method_1551();
    private final List<IStringFilter> filters = new ArrayList<IStringFilter>();

    public static MessageSender getInstance() {
        return INSTANCE;
    }

    private MessageSender() {
    }

    public void addFilter(IStringFilter filter) {
        this.filters.add(filter);
    }

    public void addFilter(IStringFilter filter, int index) {
        this.filters.add(index, filter);
    }

    public void sendMessage(String string) {
        String unfiltered = string;
        for (IStringFilter filter : this.filters) {
            Optional<String> filtered = filter.filter(string);
            if (!filtered.isPresent()) continue;
            string = filtered.get().strip();
        }
        if (string.length() > 256) {
            string = string.substring(0, 256);
        }
        this.client.field_1705.method_1743().method_1803(unfiltered);
        if (string.length() == 0) {
            AdvancedChatCore.LOGGER.log(Level.WARN, "Blank message was attempted to be sent. " + unfiltered);
            return;
        }
        if (this.client.field_1724 != null) {
            if (string.startsWith("/")) {
                this.client.method_1562().method_45730(string.substring(1));
            } else {
                this.client.method_1562().method_45729(string);
            }
        }
    }
}

