/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.chat;

import io.github.darkkronicle.advancedchatcore.interfaces.IMessageFilter;
import io.github.darkkronicle.advancedchatcore.interfaces.IMessageProcessor;
import io.github.darkkronicle.advancedchatcore.util.FindType;
import io.github.darkkronicle.advancedchatcore.util.SearchResult;
import io.github.darkkronicle.advancedchatcore.util.SearchUtils;
import io.github.darkkronicle.advancedchatcore.util.StringInsert;
import io.github.darkkronicle.advancedchatcore.util.StringMatch;
import io.github.darkkronicle.advancedchatcore.util.StyleFormatter;
import io.github.darkkronicle.advancedchatcore.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MessageDispatcher {
    private static final MessageDispatcher INSTANCE = new MessageDispatcher();
    private ArrayList<IMessageProcessor> processors = new ArrayList();
    private ArrayList<IMessageFilter> preFilters = new ArrayList();

    public static MessageDispatcher getInstance() {
        return INSTANCE;
    }

    private MessageDispatcher() {
        this.registerPreFilter(text -> Optional.of(StyleFormatter.formatText(text)), -1);
        this.registerPreFilter(text -> {
            String string = text.getString();
            if (string.isEmpty()) {
                return Optional.empty();
            }
            SearchResult search = SearchResult.searchOf(string, "(http(s)?:\\/\\/.)?(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{2,256}\\.[a-z]{2,6}\\b([-a-zA-Z0-9@:%_\\+.~#?&\\/=]*)", FindType.REGEX);
            if (search.size() == 0) {
                return Optional.empty();
            }
            HashMap<StringMatch, StringInsert> insert = new HashMap<StringMatch, StringInsert>();
            for (StringMatch match : search.getMatches()) {
                insert.put(match, (current, match1) -> {
                    Object url = match1.match;
                    if (!SearchUtils.isMatch(match1.match, "(http(s)?:\\/\\/.)", FindType.REGEX)) {
                        url = "https://" + (String)url;
                    }
                    if (current.method_10866().method_10970() == null) {
                        return class_2561.method_43470((String)match1.match).method_27696(current.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, (String)url)));
                    }
                    return class_5250.method_43477((class_7417)current.method_10851()).method_27696(current.method_10866());
                });
            }
            text = TextUtil.replaceStrings(text, insert);
            return Optional.of(text);
        }, -1);
        this.registerPreFilter((text, orig) -> {
            LogManager.getLogger().info("[CHAT] {}", (Object)text.getString().replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n"));
            return true;
        }, -1);
    }

    public void handleText(class_2561 text, @Nullable class_7469 signature, @Nullable class_7591 indicator) {
        boolean previouslyBlank = text.getString().length() == 0;
        if ((text = this.preFilter(text, signature, indicator)).getString().length() == 0 && !previouslyBlank) {
            return;
        }
        this.process(text, signature, indicator);
    }

    private class_2561 preFilter(class_2561 text, @Nullable class_7469 signature, @Nullable class_7591 indicator) {
        for (IMessageFilter f : this.preFilters) {
            Optional<class_2561> t = f.filter(text);
            if (!t.isPresent()) continue;
            text = t.get();
        }
        return text;
    }

    private void process(class_2561 text, @Nullable class_7469 signature, @Nullable class_7591 indicator) {
        for (IMessageFilter iMessageFilter : this.processors) {
            iMessageFilter.filter(text);
        }
    }

    public void registerPreFilter(IMessageFilter processor, int index) {
        if (index < 0) {
            index = this.preFilters.size();
        }
        if (!this.preFilters.contains(processor)) {
            this.preFilters.add(index, processor);
        }
    }

    public void register(IMessageProcessor processor, int index) {
        if (index < 0) {
            index = this.processors.size();
        }
        if (!this.processors.contains(processor)) {
            this.processors.add(index, processor);
        }
    }
}

