/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.chat;

import io.github.darkkronicle.advancedchatcore.chat.MessageOwner;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.StyleFormatter;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5348;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ChatMessage {
    protected int creationTick;
    protected class_2561 displayText;
    protected class_2561 originalText;
    protected int id;
    protected LocalTime time;
    protected Color backgroundColor;
    protected int stacks;
    protected UUID uuid;
    @Nullable
    protected MessageOwner owner;
    protected List<AdvancedChatLine> lines;
    @Nullable
    protected class_7469 signature;
    protected class_7591 indicator;

    public void setDisplayText(class_2561 text, int width) {
        this.displayText = text;
        this.formatChildren(width);
    }

    public ChatMessage shallowClone(int width) {
        ChatMessage message = new ChatMessage(this.creationTick, this.displayText, this.originalText, this.id, this.time, this.backgroundColor, width, this.owner, this.signature, this.indicator);
        message.setStacks(this.getStacks());
        return message;
    }

    protected ChatMessage(int creationTick, class_2561 displayText, class_2561 originalText, int id, LocalTime time, Color backgroundColor, int width, MessageOwner owner, @Nullable class_7469 signature, @Nullable class_7591 indicator) {
        this.creationTick = creationTick;
        this.displayText = displayText;
        this.id = id;
        this.time = time;
        this.backgroundColor = backgroundColor;
        this.stacks = 0;
        this.uuid = UUID.randomUUID();
        this.owner = owner;
        this.originalText = originalText == null ? displayText : originalText;
        this.signature = signature;
        this.indicator = indicator == null ? class_7591.method_44751() : indicator;
        this.formatChildren(width);
    }

    public void formatChildren(int width) {
        this.lines = new ArrayList<AdvancedChatLine>();
        if (width == 0) {
            this.lines.add(new AdvancedChatLine(this, this.displayText));
        } else {
            for (class_2561 t : StyleFormatter.wrapText(class_310.method_1551().field_1772, width, this.displayText)) {
                this.lines.add(new AdvancedChatLine(this, t));
            }
        }
    }

    public boolean isSimilar(ChatMessage message) {
        return message.getOriginalText().getString().equals(this.getOriginalText().getString());
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public static ChatMessageBuilder builder() {
        return new ChatMessageBuilder();
    }

    public int getCreationTick() {
        return this.creationTick;
    }

    public class_2561 getDisplayText() {
        return this.displayText;
    }

    public class_2561 getOriginalText() {
        return this.originalText;
    }

    public int getId() {
        return this.id;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getStacks() {
        return this.stacks;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public MessageOwner getOwner() {
        return this.owner;
    }

    public List<AdvancedChatLine> getLines() {
        return this.lines;
    }

    @Nullable
    public class_7469 getSignature() {
        return this.signature;
    }

    public class_7591 getIndicator() {
        return this.indicator;
    }

    public void setCreationTick(int creationTick) {
        this.creationTick = creationTick;
    }

    public void setDisplayText(class_2561 displayText) {
        this.displayText = displayText;
    }

    public void setOriginalText(class_2561 originalText) {
        this.originalText = originalText;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setTime(LocalTime time) {
        this.time = time;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setStacks(int stacks) {
        this.stacks = stacks;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setOwner(@Nullable MessageOwner owner) {
        this.owner = owner;
    }

    public void setLines(List<AdvancedChatLine> lines) {
        this.lines = lines;
    }

    public void setSignature(@Nullable class_7469 signature) {
        this.signature = signature;
    }

    public void setIndicator(class_7591 indicator) {
        this.indicator = indicator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreationTick() != other.getCreationTick()) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getStacks() != other.getStacks()) {
            return false;
        }
        class_2561 this$displayText = this.getDisplayText();
        class_2561 other$displayText = other.getDisplayText();
        if (this$displayText == null ? other$displayText != null : !this$displayText.equals(other$displayText)) {
            return false;
        }
        class_2561 this$originalText = this.getOriginalText();
        class_2561 other$originalText = other.getOriginalText();
        if (this$originalText == null ? other$originalText != null : !this$originalText.equals(other$originalText)) {
            return false;
        }
        LocalTime this$time = this.getTime();
        LocalTime other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        MessageOwner this$owner = this.getOwner();
        MessageOwner other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        List<AdvancedChatLine> this$lines = this.getLines();
        List<AdvancedChatLine> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        class_7469 this$signature = this.getSignature();
        class_7469 other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        class_7591 this$indicator = this.getIndicator();
        class_7591 other$indicator = other.getIndicator();
        return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCreationTick();
        result = result * 59 + this.getId();
        result = result * 59 + this.getStacks();
        class_2561 $displayText = this.getDisplayText();
        result = result * 59 + ($displayText == null ? 43 : $displayText.hashCode());
        class_2561 $originalText = this.getOriginalText();
        result = result * 59 + ($originalText == null ? 43 : $originalText.hashCode());
        LocalTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        MessageOwner $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        List<AdvancedChatLine> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        class_7469 $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        class_7591 $indicator = this.getIndicator();
        result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
        return result;
    }

    public String toString() {
        return "ChatMessage(creationTick=" + this.getCreationTick() + ", displayText=" + this.getDisplayText() + ", originalText=" + this.getOriginalText() + ", id=" + this.getId() + ", time=" + this.getTime() + ", backgroundColor=" + this.getBackgroundColor() + ", stacks=" + this.getStacks() + ", uuid=" + this.getUuid() + ", owner=" + this.getOwner() + ", lines=" + this.getLines() + ", signature=" + this.getSignature() + ", indicator=" + this.getIndicator() + ")";
    }

    public static class AdvancedChatLine {
        private class_2561 text;
        private final ChatMessage parent;
        private int width;

        private AdvancedChatLine(ChatMessage parent, class_2561 text) {
            this.parent = parent;
            this.text = text;
            this.width = class_310.method_1551().field_1772.method_27525((class_5348)text);
        }

        public String toString() {
            return "AdvancedChatLine{text=" + this.text + ", width=" + this.width + "}";
        }

        public class_2561 getText() {
            return this.text;
        }

        public ChatMessage getParent() {
            return this.parent;
        }

        public int getWidth() {
            return this.width;
        }

        public void setText(class_2561 text) {
            this.text = text;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdvancedChatLine)) {
                return false;
            }
            AdvancedChatLine other = (AdvancedChatLine)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            class_2561 this$text = this.getText();
            class_2561 other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            ChatMessage this$parent = this.getParent();
            ChatMessage other$parent = other.getParent();
            return !(this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AdvancedChatLine;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWidth();
            class_2561 $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            ChatMessage $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            return result;
        }
    }

    public static class ChatMessageBuilder {
        private int creationTick;
        private class_2561 displayText;
        private class_2561 originalText;
        private int id;
        private LocalTime time;
        private Color backgroundColor;
        private int width;
        private MessageOwner owner;
        private class_7469 signature;
        private class_7591 indicator;

        ChatMessageBuilder() {
        }

        public ChatMessageBuilder creationTick(int creationTick) {
            this.creationTick = creationTick;
            return this;
        }

        public ChatMessageBuilder displayText(class_2561 displayText) {
            this.displayText = displayText;
            return this;
        }

        public ChatMessageBuilder originalText(class_2561 originalText) {
            this.originalText = originalText;
            return this;
        }

        public ChatMessageBuilder id(int id) {
            this.id = id;
            return this;
        }

        public ChatMessageBuilder time(LocalTime time) {
            this.time = time;
            return this;
        }

        public ChatMessageBuilder backgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public ChatMessageBuilder width(int width) {
            this.width = width;
            return this;
        }

        public ChatMessageBuilder owner(MessageOwner owner) {
            this.owner = owner;
            return this;
        }

        public ChatMessageBuilder signature(@Nullable class_7469 signature) {
            this.signature = signature;
            return this;
        }

        public ChatMessageBuilder indicator(@Nullable class_7591 indicator) {
            this.indicator = indicator;
            return this;
        }

        public ChatMessage build() {
            return new ChatMessage(this.creationTick, this.displayText, this.originalText, this.id, this.time, this.backgroundColor, this.width, this.owner, this.signature, this.indicator);
        }

        public String toString() {
            return "ChatMessage.ChatMessageBuilder(creationTick=" + this.creationTick + ", displayText=" + this.displayText + ", originalText=" + this.originalText + ", id=" + this.id + ", time=" + this.time + ", backgroundColor=" + this.backgroundColor + ", width=" + this.width + ", owner=" + this.owner + ", signature=" + this.signature + ", indicator=" + this.indicator + ")";
        }
    }
}

