/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.chat;

import fi.dy.masa.malilib.config.options.ConfigInteger;
import io.github.darkkronicle.advancedchatcore.chat.ChatMessage;
import io.github.darkkronicle.advancedchatcore.config.ConfigStorage;
import io.github.darkkronicle.advancedchatcore.interfaces.IChatMessageProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ChatHistory {
    private static final ChatHistory INSTANCE = new ChatHistory();
    private final List<ChatMessage> messages = new ArrayList<ChatMessage>();
    private int maxLines = 500;
    private final List<Runnable> onClear = new ArrayList<Runnable>();
    private final List<IChatMessageProcessor> onUpdate = new ArrayList<IChatMessageProcessor>();

    public static ChatHistory getInstance() {
        return INSTANCE;
    }

    private ChatHistory() {
    }

    public void addOnClear(Runnable runnable) {
        this.onClear.add(runnable);
    }

    public void addOnUpdate(IChatMessageProcessor processor) {
        this.onUpdate.add(processor);
    }

    public void clearAll() {
        this.messages.clear();
        for (Runnable r : this.onClear) {
            r.run();
        }
    }

    public void clear() {
        this.messages.clear();
    }

    private void sendUpdate(ChatMessage message, IChatMessageProcessor.UpdateType type) {
        for (IChatMessageProcessor consumer : this.onUpdate) {
            consumer.onMessageUpdate(message, type);
        }
    }

    public boolean add(ChatMessage message) {
        this.sendUpdate(message, IChatMessageProcessor.UpdateType.NEW);
        for (int i = 0; i < ((ConfigInteger)ConfigStorage.General.CHAT_STACK.config).getIntegerValue() && i < this.messages.size(); ++i) {
            ChatMessage chatLine = this.messages.get(i);
            if (!message.isSimilar(chatLine)) continue;
            chatLine.setStacks(chatLine.getStacks() + 1);
            this.sendUpdate(chatLine, IChatMessageProcessor.UpdateType.STACK);
            return false;
        }
        this.sendUpdate(message, IChatMessageProcessor.UpdateType.ADDED);
        this.messages.add(0, message);
        while (this.messages.size() > this.maxLines) {
            this.sendUpdate(this.messages.remove(this.messages.size() - 1), IChatMessageProcessor.UpdateType.REMOVE);
        }
        return true;
    }

    public void removeMessage(int messageId) {
        List toRemove = this.messages.stream().filter(line -> line.getId() == messageId).collect(Collectors.toList());
        this.messages.removeAll(toRemove);
        for (ChatMessage m : toRemove) {
            this.sendUpdate(m, IChatMessageProcessor.UpdateType.REMOVE);
        }
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public List<Runnable> getOnClear() {
        return this.onClear;
    }

    public List<IChatMessageProcessor> getOnUpdate() {
        return this.onUpdate;
    }
}

