/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.chat;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.darkkronicle.advancedchatcore.config.ConfigStorage;
import io.github.darkkronicle.advancedchatcore.config.options.ConfigColor;
import io.github.darkkronicle.advancedchatcore.util.StringMatch;
import io.github.darkkronicle.advancedchatcore.util.StyleFormatter;
import io.github.darkkronicle.advancedchatcore.util.TextBuilder;
import io.github.darkkronicle.advancedchatcore.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class AdvancedTextField
extends class_342 {
    private static final int MAX_HISTORY = 50;
    private String lastSaved = "";
    private final List<String> history = new ArrayList<String>();
    private int focusedTicks = 0;
    private List<class_2561> renderLines = new ArrayList<class_2561>();
    private class_327 textRenderer;
    private String suggestion = null;
    private int maxLength = 32;
    private int selectionEnd;
    private int selectionStart;
    private BiFunction<String, Integer, class_5481> renderTextProvider = (string, firstCharacterIndex) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);
    private int historyIndex = -1;

    public AdvancedTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
        this(textRenderer, x, y, width, height, null, text);
    }

    public AdvancedTextField(class_327 textRenderer, int x, int y, int width, int height, @Nullable class_342 copyFrom, class_2561 text) {
        super(textRenderer, x, y, width, height, copyFrom, text);
        this.history.add("");
        this.textRenderer = textRenderer;
        this.updateRender();
    }

    public void method_1865() {
        ++this.focusedTicks;
    }

    public void method_1854(BiFunction<String, Integer, class_5481> renderTextProvider) {
        this.renderTextProvider = renderTextProvider;
    }

    public void method_1880(int maxLength) {
        this.maxLength = maxLength;
        super.method_1880(maxLength);
    }

    public static boolean isUndo(int code) {
        return code == 90 && class_437.method_25441() && !class_437.method_25443();
    }

    public void undo() {
        if (!this.lastSaved.equals(this.method_1882()) && this.historyIndex < 0) {
            this.addToHistory(this.method_1882());
        }
        if (this.historyIndex < 0) {
            this.historyIndex = this.history.size() - 1;
        }
        if (this.historyIndex != 0) {
            --this.historyIndex;
        }
        this.setText(this.history.get(this.historyIndex), false);
    }

    public void redo() {
        if (this.historyIndex < 0 || this.historyIndex >= this.history.size() - 1) {
            return;
        }
        ++this.historyIndex;
        this.setText(this.history.get(this.historyIndex), false);
    }

    public void method_1867(String text) {
        super.method_1867(text);
        this.updateHistory();
        this.updateRender();
    }

    public void method_1878(int characterOffset) {
        super.method_1878(characterOffset);
        this.updateHistory();
        this.updateRender();
    }

    public void method_1887(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int n = this.method_46427();
        int n2 = this.renderLines.size() - 1;
        Objects.requireNonNull(this.textRenderer);
        int renderY = n - n2 * (9 + 2);
        if (mouseY < (double)(renderY - 2) || mouseY > (double)(this.method_46427() + this.field_22759 + 2) || mouseX < (double)(this.method_46426() - 2) || mouseX > (double)(this.method_46426() + this.field_22758 + 4)) {
            return false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
        boolean cursorAtEnd;
        int selEnd;
        int selStart;
        int color = 0xE0E0E0;
        int cursor = this.method_1881();
        int cursorRow = this.renderLines.size() - 1;
        boolean renderCursor = this.method_25370() && this.focusedTicks / 6 % 2 == 0;
        int n = this.method_46427();
        int n2 = this.renderLines.size() - 1;
        Objects.requireNonNull(this.textRenderer);
        int renderY = n - n2 * (9 + 2);
        int endX = 0;
        int charCount = 0;
        int cursorX = -1;
        boolean selection = this.selectionStart != this.selectionEnd;
        boolean started = false;
        boolean ended = false;
        if (this.selectionStart < this.selectionEnd) {
            selStart = this.selectionStart;
            selEnd = this.selectionEnd;
        } else {
            selStart = this.selectionEnd;
            selEnd = this.selectionStart;
        }
        int x = this.method_46426();
        int y = this.method_46427();
        AdvancedTextField.method_25294((class_4587)matrices, (int)(this.method_46426() - 2), (int)(renderY - 2), (int)(this.method_46426() + this.field_22758 + 4), (int)(this.method_46427() + this.field_22759 + 4), (int)((ConfigColor)((Object)ConfigStorage.ChatScreen.COLOR.config)).get().color());
        for (int line = 0; line < this.renderLines.size(); ++line) {
            class_2561 text = this.renderLines.get(line);
            if (cursor >= charCount && cursor < text.getString().length() + charCount) {
                cursorX = this.textRenderer.method_1727(text.getString().substring(0, cursor - charCount));
                cursorRow = line;
            }
            endX = this.textRenderer.method_30881(matrices, text, (float)x, (float)renderY, color);
            if (selection) {
                if (!started && selStart >= charCount && selStart <= text.getString().length() + charCount) {
                    started = true;
                    int startX = this.textRenderer.method_27525((class_5348)TextUtil.truncate(text, new StringMatch("", 0, selStart - charCount)));
                    if (selEnd > charCount && selEnd <= text.getString().length() + charCount) {
                        ended = true;
                        sEndX = this.textRenderer.method_27525((class_5348)TextUtil.truncate(text, new StringMatch("", 0, selEnd - charCount)));
                        Objects.requireNonNull(this.textRenderer);
                        this.drawSelectionHighlight(x + startX, renderY - 1, x + sEndX, renderY + 9);
                    } else {
                        sEndX = this.textRenderer.method_27525((class_5348)text);
                        Objects.requireNonNull(this.textRenderer);
                        this.drawSelectionHighlight(x + startX, renderY - 1, x + sEndX, renderY + 9);
                    }
                } else if (started && !ended) {
                    if (selEnd >= charCount && selEnd <= text.getString().length() + charCount) {
                        ended = true;
                        sEndX = this.textRenderer.method_27525((class_5348)TextUtil.truncate(text, new StringMatch("", 0, selEnd - charCount)));
                        Objects.requireNonNull(this.textRenderer);
                        this.drawSelectionHighlight(x, renderY - 1, x + sEndX, renderY + 9);
                    } else {
                        sEndX = this.textRenderer.method_27525((class_5348)text);
                        Objects.requireNonNull(this.textRenderer);
                        this.drawSelectionHighlight(x, renderY - 1, x + sEndX, renderY + 9);
                    }
                }
            }
            Objects.requireNonNull(this.textRenderer);
            renderY += 9 + 2;
            charCount += text.getString().length();
        }
        if (cursorX < 0) {
            cursorX = endX;
        }
        boolean bl = cursorAtEnd = this.method_1881() == this.method_1882().length();
        if (!cursorAtEnd && this.suggestion != null) {
            this.textRenderer.method_1720(matrices, this.suggestion, (float)(endX - 1), (float)y, -8355712);
        }
        if (renderCursor) {
            int n3 = this.renderLines.size() - 1 - cursorRow;
            Objects.requireNonNull(this.textRenderer);
            int cursorY = y - n3 * (9 + 2);
            if (cursorAtEnd) {
                Objects.requireNonNull(this.textRenderer);
                class_332.method_25294((class_4587)matrices, (int)cursorX, (int)(cursorY - 1), (int)(cursorX + 1), (int)(cursorY + 1 + 9), (int)-3092272);
            } else {
                this.textRenderer.method_1720(matrices, "_", (float)(x + cursorX), (float)cursorY, color);
            }
        }
    }

    private void drawSelectionHighlight(int x1, int y1, int x2, int y2) {
        int i;
        int x = this.method_46426();
        int y = this.method_46427();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        if (x2 > x + this.field_22758) {
            x2 = x + this.field_22758;
        }
        if (x1 > x + this.field_22758) {
            x1 = x + this.field_22758;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22912((double)x1, (double)y2, 0.0).method_1344();
        bufferBuilder.method_22912((double)x2, (double)y2, 0.0).method_1344();
        bufferBuilder.method_22912((double)x2, (double)y1, 0.0).method_1344();
        bufferBuilder.method_22912((double)x1, (double)y1, 0.0).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public void method_1875(int cursor) {
        this.selectionStart = class_3532.method_15340((int)cursor, (int)0, (int)this.method_1882().length());
        super.method_1875(cursor);
    }

    public void method_1884(int index) {
        int i = this.method_1882().length();
        this.selectionEnd = class_3532.method_15340((int)index, (int)0, (int)i);
        super.method_1884(index);
    }

    public class_6379.class_6380 method_37018() {
        return super.method_37018();
    }

    public void setText(String text, boolean update) {
        super.method_1852(text);
        if (update) {
            this.updateHistory();
        }
        this.updateRender();
    }

    public void method_1852(String text) {
        this.setText(text, true);
    }

    private void updateRender() {
        class_5481 formatted = this.renderTextProvider.apply(this.method_1882(), 0);
        this.renderLines = StyleFormatter.wrapText(this.textRenderer, this.method_25368(), (class_2561)new TextBuilder().append(formatted).build());
    }

    private void updateHistory() {
        if (this.historyIndex >= 0) {
            this.pruneHistory(this.historyIndex + 1);
            this.historyIndex = -1;
        }
        int dif = this.method_1882().length() - this.lastSaved.length();
        double sim = TextUtil.similarity(this.method_1882(), this.lastSaved);
        if (sim >= 0.3 && dif < 5 && dif * -1 < 5 || sim >= 0.9) {
            return;
        }
        this.addToHistory(this.method_1882());
    }

    private void addToHistory(String text) {
        this.lastSaved = text;
        this.history.add(text);
        while (this.history.size() > 50) {
            this.history.remove(0);
        }
    }

    private void pruneHistory(int index) {
        if (index == 0) {
            this.history.clear();
            return;
        }
        while (this.history.size() > index) {
            this.history.remove(this.history.size() - 1);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_20315()) {
            return false;
        }
        if (!AdvancedTextField.isUndo(keyCode)) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (class_437.method_25442()) {
            this.redo();
        } else {
            this.undo();
        }
        return true;
    }

    public void method_47399(class_6382 builder) {
    }
}

