/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore.chat;

import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import io.github.darkkronicle.advancedchatcore.chat.AdvancedTextField;
import io.github.darkkronicle.advancedchatcore.chat.ChatScreenSectionHolder;
import io.github.darkkronicle.advancedchatcore.chat.MessageSender;
import io.github.darkkronicle.advancedchatcore.config.ConfigStorage;
import io.github.darkkronicle.advancedchatcore.config.gui.GuiConfigHandler;
import io.github.darkkronicle.advancedchatcore.config.options.ConfigColor;
import io.github.darkkronicle.advancedchatcore.gui.IconButton;
import io.github.darkkronicle.advancedchatcore.interfaces.AdvancedChatScreenSection;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.RowList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class AdvancedChatScreen
extends GuiBase {
    public static boolean PERMANENT_FOCUS = false;
    private String finalHistory = "";
    private int messageHistorySize = -1;
    private int startHistory = -1;
    private boolean passEvents = false;
    protected AdvancedTextField chatField;
    private String originalChatText = "";
    private static String last = "";
    private final List<AdvancedChatScreenSection> sections = new ArrayList<AdvancedChatScreenSection>();
    private final RowList<ButtonBase> rightSideButtons = new RowList();
    private final RowList<ButtonBase> leftSideButtons = new RowList();

    protected void closeGui(boolean showParent) {
        if (((ConfigBoolean)ConfigStorage.ChatScreen.PERSISTENT_TEXT.config).getBooleanValue()) {
            last = this.chatField.method_1882();
        }
        super.closeGui(showParent);
    }

    public AdvancedChatScreen() {
        this.setupSections();
    }

    public AdvancedChatScreen(boolean passEvents) {
        this();
        this.passEvents = passEvents;
    }

    public AdvancedChatScreen(int indexOfLast) {
        this();
        this.startHistory = indexOfLast;
    }

    public AdvancedChatScreen(String originalChatText) {
        this();
        this.originalChatText = originalChatText;
    }

    private void setupSections() {
        for (Function<AdvancedChatScreen, AdvancedChatScreenSection> supplier : ChatScreenSectionHolder.getInstance().getSectionSuppliers()) {
            AdvancedChatScreenSection section = supplier.apply(this);
            if (section == null) continue;
            this.sections.add(section);
        }
    }

    private Color getColor() {
        return ((ConfigColor)((Object)ConfigStorage.ChatScreen.COLOR.config)).get();
    }

    public void resetCurrentMessage() {
        this.messageHistorySize = this.field_22787.field_1705.method_1743().method_1809().size();
    }

    public boolean method_25400(char charIn, int modifiers) {
        if (this.passEvents) {
            return true;
        }
        return super.method_25400(charIn, modifiers);
    }

    public void initGui() {
        int x;
        int maxHeight;
        List<ButtonBase> buttonList;
        int i;
        super.initGui();
        this.rightSideButtons.clear();
        this.leftSideButtons.clear();
        this.resetCurrentMessage();
        this.chatField = new AdvancedTextField(this.textRenderer, 4, this.field_22790 - 12, this.field_22789 - 10, 12, (class_2561)class_2561.method_43471((String)"chat.editBox")){

            protected class_5250 method_25360() {
                return null;
            }
        };
        if (((ConfigBoolean)ConfigStorage.ChatScreen.MORE_TEXT.config).getBooleanValue()) {
            this.chatField.method_1880(64000);
        } else {
            this.chatField.method_1880(256);
        }
        this.chatField.method_1858(false);
        if (!this.originalChatText.equals("")) {
            this.chatField.method_1852(this.originalChatText);
        } else if (((ConfigBoolean)ConfigStorage.ChatScreen.PERSISTENT_TEXT.config).getBooleanValue() && !last.equals("")) {
            this.chatField.method_1852(last);
        }
        this.chatField.method_1863(this::onChatFieldUpdate);
        this.rightSideButtons.add("settings", new IconButton(0, 0, 14, 64, new class_2960("advancedchatcore", "textures/gui/settings.png"), button -> GuiBase.openGui((class_437)GuiConfigHandler.getInstance().getDefaultScreen())));
        this.method_25429((class_364)this.chatField);
        this.method_20085((class_364)this.chatField);
        for (AdvancedChatScreenSection section : this.sections) {
            section.initGui();
        }
        int originalX = this.field_22787.method_22683().method_4486() - 1;
        int y = this.field_22787.method_22683().method_4502() - 30;
        for (i = 0; i < this.rightSideButtons.rowSize(); ++i) {
            buttonList = this.rightSideButtons.get(i);
            maxHeight = 0;
            x = originalX;
            for (ButtonBase button2 : buttonList) {
                maxHeight = Math.max(maxHeight, button2.getHeight());
                button2.setPosition(x -= button2.getWidth() + 1, y);
                this.addButton(button2, null);
            }
            y -= maxHeight + 1;
        }
        originalX = 1;
        y = this.field_22787.method_22683().method_4502() - 30;
        for (i = 0; i < this.leftSideButtons.rowSize(); ++i) {
            buttonList = this.leftSideButtons.get(i);
            maxHeight = 0;
            x = originalX;
            for (ButtonBase button2 : buttonList) {
                maxHeight = Math.max(maxHeight, button2.getHeight());
                button2.setPosition(x, y);
                this.addButton(button2, null);
                x += button2.getWidth() + 1;
            }
            y -= maxHeight + 1;
        }
        if (this.startHistory >= 0) {
            this.setChatFromHistory(-this.startHistory - 1);
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        String string = this.chatField.method_1882();
        this.method_25423(client, width, height);
        this.setText(string);
        for (AdvancedChatScreenSection section : this.sections) {
            section.resize(width, height);
        }
    }

    public void method_25432() {
        for (AdvancedChatScreenSection section : this.sections) {
            section.removed();
        }
    }

    public void method_25393() {
        this.chatField.method_1865();
    }

    private void onChatFieldUpdate(String chatText) {
        String string = this.chatField.method_1882();
        for (AdvancedChatScreenSection section : this.sections) {
            section.onChatFieldUpdate(chatText, string);
        }
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.passEvents) {
            class_3675.class_306 key = class_3675.method_15985((int)keyCode, (int)scanCode);
            class_304.method_1416((class_3675.class_306)key, (boolean)false);
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.passEvents) {
            for (AdvancedChatScreenSection section : this.sections) {
                if (!section.keyPressed(keyCode, scanCode, modifiers)) continue;
                return true;
            }
            if (super.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        if (keyCode == 256) {
            GuiBase.openGui(null);
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            String string = this.chatField.method_1882().trim();
            MessageSender.getInstance().sendMessage(string);
            this.chatField.method_1852("");
            last = "";
            GuiBase.openGui(null);
            return true;
        }
        if (keyCode == 265) {
            this.setChatFromHistory(-1);
            return true;
        }
        if (keyCode == 264) {
            this.setChatFromHistory(1);
            return true;
        }
        if (keyCode == 266) {
            this.field_22787.field_1705.method_1743().method_1802(this.field_22787.field_1705.method_1743().method_1813() - 1);
            return true;
        }
        if (keyCode == 267) {
            this.field_22787.field_1705.method_1743().method_1802(-this.field_22787.field_1705.method_1743().method_1813() + 1);
            return true;
        }
        if (this.passEvents) {
            this.chatField.method_1852("");
            class_3675.class_306 key = class_3675.method_15985((int)keyCode, (int)scanCode);
            class_304.method_1416((class_3675.class_306)key, (boolean)true);
            class_304.method_1420((class_3675.class_306)key);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (amount > 1.0) {
            amount = 1.0;
        }
        if (amount < -1.0) {
            amount = -1.0;
        }
        for (AdvancedChatScreenSection section : this.sections) {
            if (!section.mouseScrolled(mouseX, mouseY, amount)) continue;
            return true;
        }
        if (!AdvancedChatScreen.method_25442()) {
            amount *= 7.0;
        }
        this.field_22787.field_1705.method_1743().method_1802((int)amount);
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (AdvancedChatScreenSection section : this.sections) {
            if (!section.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        class_338 hud = this.field_22787.field_1705.method_1743();
        if (hud.method_27146(mouseX, mouseY)) {
            return true;
        }
        class_2583 style = hud.method_1816(mouseX, mouseY);
        if (style != null && style.method_10970() != null && this.method_25430(style)) {
            return true;
        }
        return this.chatField.method_25402(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        for (AdvancedChatScreenSection section : this.sections) {
            if (!section.mouseReleased(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (AdvancedChatScreenSection section : this.sections) {
            if (!section.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected void method_25415(String text, boolean override) {
        if (override) {
            this.chatField.method_1852(text);
        } else {
            this.chatField.method_1867(text);
        }
    }

    public void setChatFromHistory(int i) {
        int targetIndex = this.messageHistorySize + i;
        int maxIndex = this.field_22787.field_1705.method_1743().method_1809().size();
        if ((targetIndex = class_3532.method_15340((int)targetIndex, (int)0, (int)maxIndex)) != this.messageHistorySize) {
            if (targetIndex == maxIndex) {
                this.messageHistorySize = maxIndex;
                this.chatField.method_1852(this.finalHistory);
            } else {
                if (this.messageHistorySize == maxIndex) {
                    this.finalHistory = this.chatField.method_1882();
                }
                String hist = (String)this.field_22787.field_1705.method_1743().method_1809().get(targetIndex);
                this.chatField.method_1852(hist);
                for (AdvancedChatScreenSection section : this.sections) {
                    section.setChatFromHistory(hist);
                }
                this.messageHistorySize = targetIndex;
            }
        }
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        class_338 hud = this.field_22787.field_1705.method_1743();
        this.method_25395((class_364)this.chatField);
        this.chatField.method_1876(true);
        this.chatField.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        for (AdvancedChatScreenSection section : this.sections) {
            section.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        }
        class_2583 style = hud.method_1816((double)mouseX, (double)mouseY);
        if (style != null && style.method_10969() != null) {
            this.method_25418(matrixStack, style, mouseX, mouseY);
        }
    }

    protected void drawScreenBackground(int mouseX, int mouseY) {
    }

    private void setText(String text) {
        this.chatField.method_1852(text);
    }

    public AdvancedTextField getChatField() {
        return this.chatField;
    }

    public String getOriginalChatText() {
        return this.originalChatText;
    }

    public RowList<ButtonBase> getRightSideButtons() {
        return this.rightSideButtons;
    }

    public RowList<ButtonBase> getLeftSideButtons() {
        return this.leftSideButtons;
    }
}

