/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore;

import fi.dy.masa.malilib.interfaces.IInitializationHandler;
import io.github.darkkronicle.advancedchatcore.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;

public class ModuleHandler {
    private static final ModuleHandler INSTANCE = new ModuleHandler();
    private final List<Module> modules = new ArrayList<Module>();
    private List<LoadOrder> toLoad = new ArrayList<LoadOrder>();

    private ModuleHandler() {
    }

    public static ModuleHandler getInstance() {
        return INSTANCE;
    }

    public void registerModules() {
        this.modules.clear();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            CustomValue acData = mod.getMetadata().getCustomValue("acmodule");
            if (acData == null || acData.getType() != CustomValue.CvType.BOOLEAN || !acData.getAsBoolean()) continue;
            this.modules.add(new Module(mod.getMetadata().getId(), mod.getMetadata().getAuthors()));
        }
    }

    public void registerInitHandler(String name, int priority, IInitializationHandler handler) {
        this.toLoad.add(new LoadOrder(name, priority, handler));
    }

    public void load() {
        Collections.sort(this.toLoad);
        for (LoadOrder load : this.toLoad) {
            load.getHandler().registerModHandlers();
        }
        this.toLoad = null;
    }

    public Optional<Module> fromId(String modID) {
        for (Module m : this.modules) {
            if (!m.getModId().equals(modID)) continue;
            return Optional.of(m);
        }
        return Optional.empty();
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public static final class LoadOrder
    implements Comparable<LoadOrder> {
        private final String name;
        private final Integer order;
        private final IInitializationHandler handler;

        @Override
        public int compareTo(LoadOrder o) {
            int compared = this.order.compareTo(o.order);
            if (compared == 0) {
                return this.name.compareTo(o.getName());
            }
            return compared;
        }

        public String getName() {
            return this.name;
        }

        public Integer getOrder() {
            return this.order;
        }

        public IInitializationHandler getHandler() {
            return this.handler;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoadOrder)) {
                return false;
            }
            LoadOrder other = (LoadOrder)o;
            Integer this$order = this.getOrder();
            Integer other$order = other.getOrder();
            if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            IInitializationHandler this$handler = this.getHandler();
            IInitializationHandler other$handler = other.getHandler();
            return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            IInitializationHandler $handler = this.getHandler();
            result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
            return result;
        }

        public String toString() {
            return "ModuleHandler.LoadOrder(name=" + this.getName() + ", order=" + this.getOrder() + ", handler=" + this.getHandler() + ")";
        }

        public LoadOrder(String name, Integer order, IInitializationHandler handler) {
            this.name = name;
            this.order = order;
            this.handler = handler;
        }
    }
}

