/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatcore;

import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.interfaces.IInitializationHandler;
import fi.dy.masa.malilib.util.InfoUtils;
import io.github.darkkronicle.advancedchatcore.AdvancedChatCore;
import io.github.darkkronicle.advancedchatcore.ModuleHandler;
import io.github.darkkronicle.advancedchatcore.chat.AdvancedChatScreen;
import io.github.darkkronicle.advancedchatcore.chat.ChatHistoryProcessor;
import io.github.darkkronicle.advancedchatcore.chat.ChatScreenSectionHolder;
import io.github.darkkronicle.advancedchatcore.chat.DefaultChatSuggestor;
import io.github.darkkronicle.advancedchatcore.chat.MessageDispatcher;
import io.github.darkkronicle.advancedchatcore.config.ConfigStorage;
import io.github.darkkronicle.advancedchatcore.config.gui.GuiConfig;
import io.github.darkkronicle.advancedchatcore.config.gui.GuiConfigHandler;
import io.github.darkkronicle.advancedchatcore.config.gui.TabSupplier;
import io.github.darkkronicle.advancedchatcore.finder.CustomFinder;
import io.github.darkkronicle.advancedchatcore.finder.custom.ProfanityFinder;
import io.github.darkkronicle.advancedchatcore.hotkeys.InputHandler;
import io.github.darkkronicle.advancedchatcore.util.ProfanityUtil;
import io.github.darkkronicle.advancedchatcore.util.StringInsert;
import io.github.darkkronicle.advancedchatcore.util.StringMatch;
import io.github.darkkronicle.advancedchatcore.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class InitHandler
implements IInitializationHandler {
    public void registerModHandlers() {
        ModuleHandler.getInstance().registerModules();
        ConfigManager.getInstance().registerConfigHandler("advancedchatcore", (IConfigHandler)new ConfigStorage());
        MessageDispatcher.getInstance().register(new ChatHistoryProcessor(), -1);
        GuiConfigHandler.getInstance().addTab(GuiConfigHandler.children("advancedchatcore", "advancedchat.tab.advancedchatcore", GuiConfigHandler.wrapOptions("core_general", "advancedchatcore.tab.general", ConfigStorage.General.OPTIONS.stream().map(saveableConfig -> saveableConfig.config).toList()), GuiConfigHandler.wrapOptions("chatscreen", "advancedchatcore.tab.chatscreen", ConfigStorage.ChatScreen.OPTIONS.stream().map(saveableConfig -> saveableConfig.config).toList())));
        ProfanityUtil.getInstance().loadConfigs();
        MessageDispatcher.getInstance().registerPreFilter(text -> {
            if (((ConfigBoolean)ConfigStorage.General.FILTER_PROFANITY.config).getBooleanValue()) {
                List<StringMatch> profanity = ProfanityUtil.getInstance().getBadWords(text.getString(), (float)((ConfigDouble)ConfigStorage.General.PROFANITY_ABOVE.config).getDoubleValue(), ((ConfigBoolean)ConfigStorage.General.PROFANITY_ON_WORD_BOUNDARIES.config).getBooleanValue());
                if (profanity.size() == 0) {
                    return Optional.empty();
                }
                HashMap<StringMatch, StringInsert> insertions = new HashMap<StringMatch, StringInsert>();
                for (StringMatch bad : profanity) {
                    insertions.put(bad, (current, match) -> class_2561.method_43470((String)"*".repeat(bad.end - bad.start)).method_27696(current.method_10866()));
                }
                text = TextUtil.replaceStrings(text, insertions);
                return Optional.of(text);
            }
            return Optional.empty();
        }, -1);
        ChatScreenSectionHolder.getInstance().addSectionSupplier(advancedChatScreen -> {
            if (AdvancedChatCore.CREATE_SUGGESTOR) {
                return new DefaultChatSuggestor((AdvancedChatScreen)((Object)advancedChatScreen));
            }
            return null;
        });
        CustomFinder.getInstance().register(ProfanityFinder::new, "profanity", "advancedchatcore.findtype.custom.profanity", "advancedchatcore.findtype.custom.info.profanity");
        InputHandler.getInstance().addDisplayName("core_general", "advancedchatcore.config.tab.hotkeysgeneral");
        InputHandler.getInstance().add("core_general", (ConfigHotkey)ConfigStorage.Hotkeys.OPEN_CHAT.config, (action, key) -> {
            if (class_310.method_1551().field_1687 == null) {
                return true;
            }
            GuiBase.openGui((class_437)new AdvancedChatScreen(""));
            return true;
        });
        InputHandler.getInstance().add("core_general", (ConfigHotkey)ConfigStorage.Hotkeys.OPEN_CHAT_WITH_LAST.config, (action, key) -> {
            if (class_310.method_1551().field_1687 == null) {
                return true;
            }
            GuiBase.openGui((class_437)new AdvancedChatScreen(0));
            return true;
        });
        InputHandler.getInstance().add("core_general", (ConfigHotkey)ConfigStorage.Hotkeys.OPEN_CHAT_FREE_MOVEMENT.config, (action, key) -> {
            if (class_310.method_1551().field_1687 == null) {
                return true;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1755 != null) {
                client.field_1755.method_25432();
            }
            client.field_1755 = new AdvancedChatScreen(true);
            client.field_1729.method_1610();
            client.field_1755.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
            client.field_1743 = false;
            client.method_24288();
            return true;
        });
        InputHandler.getInstance().add("core_general", (ConfigHotkey)ConfigStorage.Hotkeys.TOGGLE_PERMANENT.config, (action, key) -> {
            AdvancedChatScreen.PERMANENT_FOCUS = !AdvancedChatScreen.PERMANENT_FOCUS;
            InfoUtils.printActionbarMessage((String)"advancedchatcore.message.togglepermanent", (Object[])new Object[0]);
            return true;
        });
        InputHandler.getInstance().add("core_general", (ConfigHotkey)ConfigStorage.Hotkeys.OPEN_SETTINGS.config, (action, key) -> {
            GuiBase.openGui((class_437)new GuiConfig());
            return true;
        });
        ModuleHandler.getInstance().load();
        InputEventHandler.getKeybindManager().registerKeybindProvider((IKeybindProvider)InputHandler.getInstance());
        InputEventHandler.getInputManager().registerKeyboardInputHandler((IKeyboardInputHandler)InputHandler.getInstance());
        InputEventHandler.getInputManager().registerMouseInputHandler((IMouseInputHandler)InputHandler.getInstance());
        ArrayList<TabSupplier> children = new ArrayList<TabSupplier>();
        for (Map.Entry<String, List<ConfigHotkey>> hotkeys : InputHandler.getInstance().getHotkeys().entrySet()) {
            List<IConfigBase> configs = hotkeys.getValue().stream().map(hotkey -> hotkey).toList();
            children.add(GuiConfigHandler.wrapOptions(hotkeys.getKey(), InputHandler.getInstance().getDisplayName(hotkeys.getKey()), configs));
        }
        GuiConfigHandler.getInstance().addTab(GuiConfigHandler.children("hotkeys", "advancedchat.tab.hotkeys", children.toArray(new TabSupplier[0])));
    }
}

