/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Agent;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ServicesKeyInfo;
import com.mojang.authlib.yggdrasil.YggdrasilGameProfileRepository;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilServicesKeyInfo;
import com.mojang.authlib.yggdrasil.YggdrasilUserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import java.net.Proxy;

public class YggdrasilAuthenticationService
extends HttpAuthenticationService {
    private Proxy proxy;
    private String clientToken;
    private Environment environment;
    private ServicesKeyInfo servicesKey;

    public YggdrasilAuthenticationService(Proxy proxy) {
        super(proxy);
        this.proxy = proxy;
        this.servicesKey = YggdrasilServicesKeyInfo.createFromResources();
    }

    public YggdrasilAuthenticationService(Proxy proxy, Environment environment) {
        super(proxy);
        this.proxy = proxy;
        this.environment = environment;
        this.servicesKey = YggdrasilServicesKeyInfo.createFromResources();
    }

    public YggdrasilAuthenticationService(Proxy proxy, String clientToken) {
        super(proxy);
        this.proxy = proxy;
        this.clientToken = clientToken;
        this.servicesKey = YggdrasilServicesKeyInfo.createFromResources();
    }

    public YggdrasilAuthenticationService(Proxy proxy, String clientToken, Environment environment) {
        super(proxy);
        this.proxy = proxy;
        this.clientToken = clientToken;
        this.environment = environment;
        this.servicesKey = YggdrasilServicesKeyInfo.createFromResources();
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public ServicesKeyInfo getServicesKey() {
        return this.servicesKey;
    }

    @Override
    public UserAuthentication createUserAuthentication(Agent agent) {
        return new YggdrasilUserAuthentication(this, this.clientToken, agent);
    }

    @Override
    public MinecraftSessionService createMinecraftSessionService() {
        return new YggdrasilMinecraftSessionService(this, this.environment);
    }

    @Override
    public GameProfileRepository createProfileRepository() {
        return new YggdrasilGameProfileRepository(this, this.environment);
    }

    public UserApiService createUserApiService(String accessToken) throws AuthenticationException {
        return new YggdrasilUserApiService(accessToken, this.getProxy(), this.environment);
    }
}

