/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import org.apache.commons.lang3.Validate;

public class ClassCache {
    private final byte[] hash;
    private final Map<String, byte[]> classes = new HashMap<String, byte[]>();
    private boolean converted;

    public ClassCache(byte[] hash) {
        this.hash = hash;
    }

    public void addClass(String name, byte[] bytes) {
        if (this.classes.containsKey(name)) {
            throw new IllegalArgumentException(name + " is already in ClassCache");
        }
        this.classes.put(name, (byte[])Validate.notNull((Object)bytes, (String)"Passed null bytes for %s", (Object[])new Object[]{name}));
    }

    public Set<String> getClasses() {
        return this.classes.keySet();
    }

    public byte[] getClass(String name) {
        return this.classes.get(name);
    }

    public byte[] popClass(String name) {
        return this.classes.remove(name);
    }

    public byte[] getHash() {
        return this.hash;
    }

    private long calculateCRC() {
        CRC32 crc = new CRC32();
        crc.update(this.hash);
        for (byte[] clazz : this.classes.values()) {
            crc.update(clazz);
        }
        return crc.getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassCache read(File input) throws IOException {
        try (DataInputStream dis = new DataInputStream(new GZIPInputStream(new FileInputStream(input)));){
            char formatRevision = dis.readChar();
            if (formatRevision != 'D') {
                ClassCache classCache = new ClassCache(null);
                return classCache;
            }
            long expectedCRC = dis.readLong();
            byte[] hash = new byte[dis.readInt()];
            dis.readFully(hash);
            ClassCache classCache = new ClassCache(hash);
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                byte[] nameBytes = new byte[dis.readInt()];
                dis.readFully(nameBytes);
                String name = new String(nameBytes, StandardCharsets.UTF_8);
                byte[] bytes = new byte[dis.readInt()];
                dis.readFully(bytes);
                classCache.classes.put(name, bytes);
            }
            if (classCache.calculateCRC() != expectedCRC) {
                ClassCache classCache2 = new ClassCache(null);
                return classCache2;
            }
            ClassCache classCache3 = classCache;
            return classCache3;
        }
        catch (ZipException e) {
            return new ClassCache(null);
        }
    }

    public void save(File output) throws IOException {
        if (output.exists()) {
            output.delete();
        }
        try (DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(output)));){
            dos.writeChar(68);
            dos.writeLong(this.calculateCRC());
            dos.writeInt(this.hash.length);
            dos.write(this.hash);
            dos.writeInt(this.classes.size());
            for (Map.Entry<String, byte[]> clazz : this.classes.entrySet()) {
                String name = clazz.getKey();
                byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
                byte[] bytes = clazz.getValue();
                dos.writeInt(nameBytes.length);
                dos.write(nameBytes);
                dos.writeInt(bytes.length);
                dos.write(bytes);
            }
        }
    }

    public boolean isConverted() {
        return this.converted;
    }
}

