/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import com.chocohead.mm.api.ClassTinkerers;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.net.URL;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.modmuss50.optifabric.mod.OptifabricError;
import me.modmuss50.optifabric.mod.OptifineInjector;
import me.modmuss50.optifabric.mod.OptifineSetup;
import me.modmuss50.optifabric.mod.OptifineVersion;
import me.modmuss50.optifabric.patcher.ClassCache;
import me.modmuss50.optifabric.util.RemappingUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.util.version.SemanticVersionImpl;
import net.fabricmc.loader.util.version.SemanticVersionPredicateParser;
import net.fabricmc.loader.util.version.VersionParsingException;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.Mixins;

public class OptifabricSetup
implements Runnable {
    public static File optifineRuntimeJar = null;
    public static boolean usingScreenAPI;

    @Override
    public void run() {
        OptifineInjector injector;
        try {
            Pair<File, ClassCache> runtime = OptifineSetup.getRuntime();
            optifineRuntimeJar = (File)runtime.getLeft();
            ClassTinkerers.addURL((URL)((File)runtime.getLeft()).toURI().toURL());
            injector = new OptifineInjector((ClassCache)runtime.getRight());
            injector.setup();
        }
        catch (Throwable e) {
            if (!OptifabricError.hasError()) {
                OptifineVersion.jarType = OptifineVersion.JarType.INTERNAL_ERROR;
                OptifabricError.setError(e, "Failed to load OptiFine, please report this!\n\n" + e.getMessage());
            }
            System.err.println("Failed to setup optifine:");
            e.printStackTrace();
            return;
        }
        BooleanSupplier particlesPresent = new BooleanSupplier(){
            private boolean haveLooked;
            private boolean isPresent;

            @Override
            public boolean getAsBoolean() {
                if (!this.haveLooked) {
                    this.isPresent = injector.predictFuture(RemappingUtils.getClassName("class_702")).filter(node -> {
                        String desc = RemappingUtils.mapMethodDescriptor("(Lnet/minecraft/class_4587;Lnet/minecraft/class_4597$class_4598;Lnet/minecraft/class_765;Lnet/minecraft/class_4184;FLnet/minecraft/class_4604;)V");
                        for (MethodNode method : node.methods) {
                            if (!"renderParticles".equals(method.name) && !"render".equals(method.name) || !desc.equals(method.desc)) continue;
                            return true;
                        }
                        return false;
                    }).isPresent();
                    this.haveLooked = true;
                }
                return this.isPresent;
            }
        };
        BooleanSupplier farPlanePresent = new BooleanSupplier(){
            private boolean haveLooked;
            private boolean isPresent;

            @Override
            public boolean getAsBoolean() {
                if (!this.haveLooked) {
                    this.isPresent = injector.predictFuture(RemappingUtils.getClassName("class_757")).filter(node -> {
                        String render = RemappingUtils.getMethodName("class_757", "method_3192", "(FJZ)V");
                        for (MethodNode method : node.methods) {
                            if (!render.equals(method.name) || !"(FJZ)V".equals(method.desc)) continue;
                            for (AbstractInsnNode insn : method.instructions) {
                                if (insn.getType() != 4 || !"ForgeHooksClient_getGuiFarPlane".equals(((FieldInsnNode)insn).name)) continue;
                                return true;
                            }
                        }
                        return false;
                    }).isPresent();
                    this.haveLooked = true;
                }
                return this.isPresent;
            }
        };
        if (OptifabricSetup.isPresent("fabric-renderer-api-v1")) {
            Mixins.addConfiguration((String)"optifabric.compat.fabric-renderer-api.mixins.json");
        }
        if (OptifabricSetup.isPresent("fabric-rendering-v1", ">=1.5.0") && particlesPresent.getAsBoolean()) {
            Mixins.addConfiguration((String)"optifabric.compat.fabric-rendering.mixins.json");
        }
        if (OptifabricSetup.isPresent("fabric-rendering-data-attachment-v1")) {
            Mixins.addConfiguration((String)"optifabric.compat.fabric-rendering-data.mixins.json");
            if (OptifabricSetup.isPresent("minecraft", ">=1.18-alpha.21.37.a")) {
                Mixins.addConfiguration((String)"optifabric.compat.fabric-rendering-data.extra-mixins.json");
            }
        }
        if (OptifabricSetup.isPresent("fabric-renderer-indigo")) {
            Mixins.addConfiguration((String)"optifabric.compat.indigo.mixins.json");
            injector.predictFuture(RemappingUtils.getClassName("class_846$class_849")).ifPresent(node -> {
                String nonEmptyLayers = RemappingUtils.mapFieldName("class_846$class_849", "field_4450", "Ljava/util/Set;");
                for (FieldNode field : node.fields) {
                    if (!nonEmptyLayers.equals(field.name) || !"Ljava/util/Set;".equals(field.desc)) continue;
                    return;
                }
                Mixins.addConfiguration((String)"optifabric.compat.indigo.extra-mixins.json");
            });
        }
        if (OptifabricSetup.isPresent("fabric-item-api-v1", ">=1.1.0") && OptifabricSetup.isPresent("minecraft", "1.16.x")) {
            Mixins.addConfiguration((String)"optifabric.compat.fabric-item-api.mixins.json");
        }
        if (OptifabricSetup.isPresent("fabric-screen-api-v1")) {
            if (OptifabricSetup.isPresent("minecraft", ">=1.17-alpha.21.10.a")) {
                if (farPlanePresent.getAsBoolean()) {
                    Mixins.addConfiguration((String)"optifabric.compat.fabric-screen-api.newer-mixins.json");
                } else {
                    Mixins.addConfiguration((String)"optifabric.compat.fabric-screen-api.new-mixins.json");
                }
            } else {
                Mixins.addConfiguration((String)"optifabric.compat.fabric-screen-api.mixins.json");
            }
            usingScreenAPI = true;
        }
        if (OptifabricSetup.isPresent("fabric-lifecycle-events-v1", ">=1.4.6") && OptifabricSetup.isPresent("minecraft", "1.17.x")) {
            Mixins.addConfiguration((String)"optifabric.compat.fabric-lifecycle-events.mixins.json");
        }
        Mixins.addConfiguration((String)"optifabric.optifine.mixins.json");
        if (OptifabricSetup.isPresent("cloth-client-events-v0", ">=2.0")) {
            if (farPlanePresent.getAsBoolean()) {
                Mixins.addConfiguration((String)"optifabric.compat.cloth.newer-mixins.json");
            } else {
                Mixins.addConfiguration((String)"optifabric.compat.cloth.new-mixins.json");
            }
        } else if (OptifabricSetup.isPresent("cloth-client-events-v0")) {
            Mixins.addConfiguration((String)"optifabric.compat.cloth.mixins.json");
        }
        if (OptifabricSetup.isPresent("clothesline")) {
            Mixins.addConfiguration((String)"optifabric.compat.clothesline.mixins.json");
        }
        if (OptifabricSetup.isPresent("trumpet-skeleton")) {
            Mixins.addConfiguration((String)"optifabric.compat.trumpet-skeleton.mixins.json");
        }
        if (OptifabricSetup.isPresent("multiconnect", ">1.3.14")) {
            Mixins.addConfiguration((String)"optifabric.compat.multiconnect.mixins.json");
        }
        if (OptifabricSetup.isPresent("now-playing", ">=1.1.0")) {
            Mixins.addConfiguration((String)"optifabric.compat.now-playing.mixins.json");
        }
        if (OptifabricSetup.isPresent("origins", (ModMetadata mod) -> OptifabricSetup.compareVersions(Pattern.compile("^1\\.16(\\.\\d)?-").matcher(mod.getVersion().getFriendlyString()).find() ? ">=1.16-0.2.0" : ">=0.4.1 <1.0", mod))) {
            if (OptifabricSetup.isPresent("origins", (ModMetadata mod) -> !Pattern.compile("^1\\.16(\\.\\d)?-").matcher(mod.getVersion().getFriendlyString()).find() || OptifabricSetup.compareVersions(">=1.16.3-0.4.0", mod))) {
                Mixins.addConfiguration((String)"optifabric.compat.origins.mixins.json");
            }
            injector.predictFuture(RemappingUtils.getClassName("class_979")).ifPresent(node -> {
                String desc = RemappingUtils.mapMethodDescriptor("(Lnet/minecraft/class_1799;Lnet/minecraft/class_1309;)Z");
                for (MethodNode method : node.methods) {
                    if (!"shouldRender".equals(method.name) || !desc.equals(method.desc)) continue;
                    Mixins.addConfiguration((String)"optifabric.compat.origins.extra-mixins.json");
                    break;
                }
            });
        }
        if (OptifabricSetup.isPresent("apoli")) {
            Mixins.addConfiguration((String)"optifabric.compat.apoli.mixins.json");
        }
        if (OptifabricSetup.isPresent("staffofbuilding")) {
            Mixins.addConfiguration((String)"optifabric.compat.staffofbuilding.mixins.json");
        }
        if (OptifabricSetup.isPresent("sandwichable", ">=1.2-alpha1")) {
            Mixins.addConfiguration((String)"optifabric.compat.sandwichable.mixins.json");
        } else if (OptifabricSetup.isPresent("sandwichable")) {
            Mixins.addConfiguration((String)"optifabric.compat.sandwichable-old.mixins.json");
        }
        if (OptifabricSetup.isPresent("astromine", "<1.6")) {
            Mixins.addConfiguration((String)"optifabric.compat.astromine.mixins.json");
        }
        if (OptifabricSetup.isPresent("carpet")) {
            if (!OptifabricSetup.isPresent("minecraft", "1.17.x")) {
                Mixins.addConfiguration((String)"optifabric.compat.carpet.mixins.json");
            }
            if (particlesPresent.getAsBoolean()) {
                Mixins.addConfiguration((String)"optifabric.compat.carpet.extra-mixins.json");
            }
        }
        if (OptifabricSetup.isPresent("hctm-base")) {
            Mixins.addConfiguration((String)"optifabric.compat.hctm.mixins.json");
        }
        if (OptifabricSetup.isPresent("mubble", "<4.0-pre5")) {
            Mixins.addConfiguration((String)"optifabric.compat.mubble.mixins.json");
        }
        if (OptifabricSetup.isPresent("dawn", ">=1.3 <=1.4")) {
            Mixins.addConfiguration((String)"optifabric.compat.dawn.older-mixins.json");
        } else if (OptifabricSetup.isPresent("dawn", ">1.4 <1.5")) {
            Mixins.addConfiguration((String)"optifabric.compat.dawn.old-mixins.json");
        } else if (OptifabricSetup.isPresent("dawn", ">=1.5 <1.8")) {
            Mixins.addConfiguration((String)"optifabric.compat.dawn.mixins.json");
        }
        if (OptifabricSetup.isPresent("phormat")) {
            Mixins.addConfiguration((String)"optifabric.compat.phormat.mixins.json");
        }
        if (OptifabricSetup.isPresent("chat_heads", "<0.2")) {
            Mixins.addConfiguration((String)"optifabric.compat.chat-heads.mixins.json");
        }
        if (OptifabricSetup.isPresent("mmorpg")) {
            Mixins.addConfiguration((String)"optifabric.compat.age-of-exile.mixins.json");
        }
        if (OptifabricSetup.isPresent("charm", ">=2.0 <2.1")) {
            Mixins.addConfiguration((String)"optifabric.compat.charm-older.mixins.json");
        } else if (OptifabricSetup.isPresent("charm", ">=2.1  <3.0")) {
            Mixins.addConfiguration((String)"optifabric.compat.charm-old.mixins.json");
            if (OptifabricSetup.isPresent("charm", ">=2.2.2")) {
                injector.predictFuture(RemappingUtils.getClassName("class_156")).ifPresent(node -> {
                    String desc = "(Lcom/mojang/datafixers/DSL$TypeReference;Ljava/lang/String;)Lcom/mojang/datafixers/types/Type;";
                    String getChoiceTypeInternal = RemappingUtils.getMethodName("class_156", "method_29191", desc);
                    for (MethodNode method : node.methods) {
                        if (!getChoiceTypeInternal.equals(method.name) || !desc.equals(method.desc)) continue;
                        Mixins.addConfiguration((String)"optifabric.compat.charm-plus.mixins.json");
                        break;
                    }
                });
            }
        } else if (OptifabricSetup.isPresent("charm", ">=3.0")) {
            Mixins.addConfiguration((String)"optifabric.compat.charm.mixins.json");
        }
        if (OptifabricSetup.isPresent("voxelmap")) {
            Mixins.addConfiguration((String)"optifabric.compat.voxelmap.mixins.json");
        }
        if (OptifabricSetup.isPresent("appliedenergistics2")) {
            Mixins.addConfiguration((String)"optifabric.compat.ae2.mixins.json");
        }
        if (OptifabricSetup.isPresent("images", "=0.3.0")) {
            Mixins.addConfiguration((String)"optifabric.compat.images-older.mixins.json");
        } else if (OptifabricSetup.isPresent("images", ">=0.3.1 <1.0.1")) {
            Mixins.addConfiguration((String)"optifabric.compat.images-old.mixins.json");
        } else if (OptifabricSetup.isPresent("images", ">=1.0.1")) {
            Mixins.addConfiguration((String)"optifabric.compat.images.mixins.json");
        }
        if (OptifabricSetup.isPresent("architectury", ">=2.0")) {
            assert (OptifabricSetup.isPresent("minecraft", ">=1.17-beta.1"));
            if (farPlanePresent.getAsBoolean()) {
                Mixins.addConfiguration((String)"optifabric.compat.architectury-AB.newer-mixins.json");
            } else {
                Mixins.addConfiguration((String)"optifabric.compat.architectury-AB.new-mixins.json");
            }
        } else if (OptifabricSetup.isPresent("architectury", ">=1.0.20")) {
            Mixins.addConfiguration((String)"optifabric.compat.architectury-B.mixins.json");
        } else if (OptifabricSetup.isPresent("architectury", ">=1.0.4")) {
            Mixins.addConfiguration((String)"optifabric.compat.architectury-A.mixins.json");
        }
        if (OptifabricSetup.isPresent("frex", ">=4.3")) {
            Mixins.addConfiguration((String)"optifabric.compat.frex.mixins.json");
        } else if (OptifabricSetup.isPresent("frex", "=4.2")) {
            Mixins.addConfiguration((String)"optifabric.compat.frex-old.mixins.json");
        }
        if (OptifabricSetup.isPresent("full_slabs", ">=1.0.2")) {
            Mixins.addConfiguration((String)"optifabric.compat.full-slabs.mixins.json");
        }
        if (OptifabricSetup.isPresent("amecsapi", "<1.1.2")) {
            Mixins.addConfiguration((String)"optifabric.compat.amecsapi.mixins.json");
            ClassWriter writer = new ClassWriter(0);
            writer.visit(52, 33, "null", null, "java/lang/Object", null);
            writer.visitEnd();
            ClassTinkerers.define((String)"null", (byte[])writer.toByteArray());
        }
        if (OptifabricSetup.isPresent("pswg")) {
            Mixins.addConfiguration((String)"optifabric.compat.pswg.mixins.json");
            if (OptifabricSetup.isPresent("pswg", ">=1.16.4-0.0.15")) {
                injector.predictFuture(RemappingUtils.getClassName("class_276")).ifPresent(node -> {
                    for (FieldNode field : node.fields) {
                        if (!"stencilEnabled".equals(field.name) || !"Z".equals(field.desc)) continue;
                        Mixins.addConfiguration((String)"optifabric.compat.pswg.extra-mixins.json");
                        break;
                    }
                });
            }
        }
        if (OptifabricSetup.isPresent("custom-fog", ">=1.2")) {
            Mixins.addConfiguration((String)"optifabric.compat.custom-fog.mixins.json");
        }
        if (OptifabricSetup.isPresent("smooth-chunks")) {
            Mixins.addConfiguration((String)"optifabric.compat.smooth-chunks.mixins.json");
        }
        if (OptifabricSetup.isPresent("enhancedcelestials")) {
            Mixins.addConfiguration((String)"optifabric.compat.enhancedcelestials.mixins.json");
        }
        if (OptifabricSetup.isPresent("cullparticles") && particlesPresent.getAsBoolean()) {
            Mixins.addConfiguration((String)"optifabric.compat.cullparticles.mixins.json");
        }
        if (OptifabricSetup.isPresent("the_aether", "<1.17.1-1.5.0")) {
            Mixins.addConfiguration((String)"optifabric.compat.aether.mixins.json");
        }
        if (OptifabricSetup.isPresent("stacc")) {
            injector.predictFuture(RemappingUtils.getClassName("class_2540")).ifPresent(node -> {
                String desc = RemappingUtils.mapMethodDescriptor("(Lnet/minecraft/class_1799;Z)Lnet/minecraft/class_2540;");
                for (MethodNode method : node.methods) {
                    if (!"writeItemStack".equals(method.name) || !desc.equals(method.desc)) continue;
                    if (OptifabricSetup.isPresent("stacc", ">=1.2")) {
                        Mixins.addConfiguration((String)"optifabric.compat.stacc.mixins.json");
                        break;
                    }
                    Mixins.addConfiguration((String)"optifabric.compat.stacc.old-mixins.json");
                    break;
                }
            });
        }
        if (OptifabricSetup.isPresent("bannerpp")) {
            Mixins.addConfiguration((String)"optifabric.compat.bannerpp.mixins.json");
        }
        if (OptifabricSetup.isPresent("replaymod")) {
            if (OptifabricSetup.isPresent("minecraft", "1.17.x")) {
                Mixins.addConfiguration((String)"optifabric.compat.replaymod.new-mixins.json");
            } else {
                Mixins.addConfiguration((String)"optifabric.compat.replaymod.mixins.json");
            }
        }
    }

    private static boolean isPresent(String modID) {
        return FabricLoader.getInstance().isModLoaded(modID);
    }

    private static boolean isPresent(String modID, String versionRange) {
        return OptifabricSetup.isPresent(modID, (ModMetadata modMetadata) -> OptifabricSetup.compareVersions(versionRange, modMetadata));
    }

    private static boolean isPresent(String modID, Predicate<ModMetadata> extraChecks) {
        if (!OptifabricSetup.isPresent(modID)) {
            return false;
        }
        Optional modContainer = FabricLoader.getInstance().getModContainer(modID);
        ModMetadata modMetadata = modContainer.map(ModContainer::getMetadata).orElseThrow(() -> new RuntimeException("Failed to get mod container for " + modID + ", something has broke badly."));
        return extraChecks.test(modMetadata);
    }

    private static boolean compareVersions(String versionRange, ModMetadata mod) {
        try {
            Predicate predicate = SemanticVersionPredicateParser.create((String)versionRange);
            SemanticVersionImpl version = new SemanticVersionImpl(mod.getVersion().getFriendlyString(), false);
            return predicate.test(version);
        }
        catch (VersionParsingException e) {
            System.err.println("Error comparing the version for ".concat((String)MoreObjects.firstNonNull((Object)mod.getName(), (Object)mod.getId())));
            e.printStackTrace();
            return false;
        }
    }
}

