/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;

@Config(name="freecam")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static ModConfig INSTANCE;
    @Comment(value="The type of flight used by freecam.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public FlightMode flightMode = FlightMode.DEFAULT;
    @Comment(value="The source of block/entity interactions.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public InteractionMode interactionMode = InteractionMode.CAMERA;
    @Comment(value="The horizontal speed of freecam.")
    public double horizontalSpeed = 1.0;
    @Comment(value="The vertical speed of freecam.")
    public double verticalSpeed = 1.0;
    @Comment(value="Whether you can travel through blocks in freecam.")
    public boolean noclip = true;
    @Comment(value="Prevents player movement while freecam is active.\n\u00a7cWARNING: Multiplayer usage not advised.")
    public boolean freezePlayer = false;
    @Comment(value="Whether you can interact with blocks/entities in freecam.\n\u00a7cWARNING: Multiplayer usage not advised.")
    public boolean allowInteract = false;
    @Comment(value="Disables freecam when damage is received.")
    public boolean disableOnDamage = true;
    @Comment(value="Shows your player in its original position.")
    public boolean showPlayer = true;
    @Comment(value="Whether you can see your hand in freecam.")
    public boolean showHand = false;
    @Comment(value="Notifies you when entering/exiting freecam.")
    public boolean notifyFreecam = true;
    @Comment(value="Notifies you when entering/exiting tripod cameras.")
    public boolean notifyPersistent = true;

    public static void init() {
        AutoConfig.register(ModConfig.class, JanksonConfigSerializer::new);
        INSTANCE = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    }

    public static enum FlightMode implements SelectionListEntry.Translatable
    {
        CREATIVE("Creative"),
        DEFAULT("Default");

        private final String name;

        private FlightMode(String name) {
            this.name = name;
        }

        public String getKey() {
            return this.name;
        }
    }

    public static enum InteractionMode implements SelectionListEntry.Translatable
    {
        CAMERA("Camera"),
        PLAYER("Player");

        private final String name;

        private InteractionMode(String name) {
            this.name = name;
        }

        public String getKey() {
            return this.name;
        }
    }
}

