/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.io.IOException;
import net.minecraft.class_310;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.minimap.MinimapInterfaceInstance;
import xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler;
import xaero.common.minimap.render.MinimapFBORenderer;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.minimap.waypoints.render.CompassRenderer;
import xaero.common.minimap.waypoints.render.WaypointDeleter;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.waypoints.render.WaypointsIngameRenderer;
import xaero.common.settings.ModOptions;

public class MinimapInterface
extends Interface {
    private AXaeroMinimap modMain;
    private class_310 mc = class_310.method_1551();
    private WaypointsGuiRenderer waypointsGuiRenderer;
    private WaypointsIngameRenderer waypointsIngameRenderer;
    private MinimapFBORenderer minimapFBORenderer;
    private CompassRenderer compassRenderer;
    private MinimapElementOverMapRendererHandler overMapRendererHandler;
    private Throwable crashedWith;
    private MinimapSafeModeRenderer minimapSafeModeRenderer;

    public MinimapInterface(AXaeroMinimap modMain, int id, InterfaceManager interfaces) throws IOException {
        super(interfaces, "gui.xaero_minimap", id, 128, 128, ModOptions.MINIMAP);
        this.modMain = modMain;
        WaypointDeleter waypointDeleter = new WaypointDeleter(modMain);
        this.waypointsGuiRenderer = WaypointsGuiRenderer.Builder.begin(modMain).setWaypointDeleter(waypointDeleter).build();
        this.compassRenderer = new CompassRenderer(modMain, this.mc);
        this.overMapRendererHandler = MinimapElementOverMapRendererHandler.Builder.begin().build();
        this.overMapRendererHandler.add(this.waypointsGuiRenderer);
        this.waypointsIngameRenderer = new WaypointsIngameRenderer(modMain, waypointDeleter, this.mc);
        this.minimapFBORenderer = new MinimapFBORenderer(modMain, this.mc, this.waypointsGuiRenderer, this, this.compassRenderer);
        this.minimapSafeModeRenderer = new MinimapSafeModeRenderer(modMain, this.mc, this.waypointsGuiRenderer, this, this.compassRenderer);
    }

    public Throwable getCrashedWith() {
        return this.crashedWith;
    }

    public void setCrashedWith(Throwable crashedWith) {
        if (this.crashedWith == null) {
            this.crashedWith = crashedWith;
        }
    }

    public void checkCrashes() {
        if (this.crashedWith != null) {
            Throwable crash = this.crashedWith;
            this.crashedWith = null;
            throw new RuntimeException("Xaero's Minimap (" + this.modMain.getVersionID() + ") has crashed! Please report here: bit.ly/XaeroMMIssues", crash);
        }
    }

    @Override
    public InterfaceInstance createInterfaceInstance(XaeroMinimapSession minimapSession) {
        return new MinimapInterfaceInstance(this, this.modMain, minimapSession);
    }

    public WaypointsGuiRenderer getWaypointsGuiRenderer() {
        return this.waypointsGuiRenderer;
    }

    public WaypointsIngameRenderer getWaypointsIngameRenderer() {
        return this.waypointsIngameRenderer;
    }

    public MinimapFBORenderer getMinimapFBORenderer() {
        return this.minimapFBORenderer;
    }

    public MinimapSafeModeRenderer getMinimapSafeModeRenderer() {
        return this.minimapSafeModeRenderer;
    }

    public MinimapElementOverMapRendererHandler getOverMapRendererHandler() {
        return this.overMapRendererHandler;
    }

    public boolean usingFBO() {
        return this.getMinimapFBORenderer().isLoadedFBO() && !this.modMain.getSettings().mapSafeMode;
    }

    public CompassRenderer getCompassRenderer() {
        return this.compassRenderer;
    }
}

