/*
 * Decompiled with CFR 0.152.
 */
package com.nebulae.stendhal.utils;

import com.nebulae.stendhal.utils.Book;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class StendhalBook {
    @Nullable
    public static Book tempBook = null;
    @Nullable
    public static Book importBook = null;
    @Nullable
    public static Book copyBook = null;

    public static void exportBook(class_2561 title, class_2561 author, List<String> pages) {
        String fileName = title.getString().replace(" ", "_").toLowerCase();
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FabricLoader.getInstance().getConfigDir() + "/stendhal/books/" + fileName + ".stendhal"), StandardCharsets.UTF_8));){
            String bookString = "title: " + title.getString() + "\nauthor: " + author.getString() + "\npages:\n";
            for (String page : pages) {
                bookString = bookString + "#- " + page + "\n";
            }
            out.write(bookString);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Book importBook(String fileName) {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FabricLoader.getInstance().getConfigDir() + "/stendhal/books/" + fileName + ".stendhal"), decoder));
            Book importedBook = new Book(class_2561.method_30163((String)""), class_2561.method_30163((String)""), new ArrayList<String>());
            ArrayList<String> importedPages = new ArrayList<String>();
            Object currentPage = "";
            Boolean pageMode = false;
            @Nullable String line = br.readLine();
            while (line != null) {
                if (line.startsWith("title:")) {
                    importedBook.setTitle(class_2561.method_30163((String)line.replace("title: ", "")));
                }
                if (line.startsWith("author:")) {
                    importedBook.setAuthor(class_2561.method_30163((String)line.replace("author: ", "")));
                }
                if (pageMode.booleanValue() && !line.startsWith("#- ")) {
                    currentPage = (String)currentPage + line + "\n";
                }
                if (line.startsWith("#- ")) {
                    pageMode = true;
                    if (currentPage != "") {
                        importedPages.add((String)currentPage);
                    }
                    currentPage = line.replace("#- ", "") + "\n";
                }
                line = br.readLine();
            }
            importedPages.add((String)currentPage);
            br.close();
            importedBook.setPages(importedPages);
            return importedBook;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean doesBookExists(String fileName) {
        if (new File(FabricLoader.getInstance().getConfigDir() + "/stendhal/books/" + fileName + ".stendhal").exists()) {
            return true;
        }
        return false;
    }

    public static List<Book> getBooks() {
        String[] contents = new File(FabricLoader.getInstance().getConfigDir() + "/stendhal/books/").list();
        if (contents != null) {
            ArrayList<Book> bookLists = new ArrayList<Book>();
            for (int i = 0; i < contents.length; ++i) {
                String thisBookFileName = contents[i].replace(".stendhal", "");
                Book thisBook = StendhalBook.importBook(thisBookFileName);
                if (thisBook == null) continue;
                bookLists.add(thisBook);
            }
            return bookLists;
        }
        return new ArrayList<Book>();
    }
}

