/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.asm;

import com.chocohead.mm.api.ClassTinkerers;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ShulkerBoxTooltipEarlyRiser
implements Runnable {
    private static Logger LOGGER = LogManager.getFormatterLogger((String)"ShulkerBoxTooltip Early Riser");

    @Override
    public void run() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        MappingResolver remapper = FabricLoader.getInstance().getMappingResolver();
        String tooltipComponent = remapper.mapClassName("intermediary", "net.minecraft.class_5684");
        ClassTinkerers.addTransformation((String)tooltipComponent, classNode -> {
            String tooltipData = remapper.mapClassName("intermediary", "net.minecraft.class_5632");
            String ofMethodName = remapper.getCurrentRuntimeNamespace().equals("intermediary") ? "method_32663" : "of";
            String ofMethodDesc = "(L" + tooltipData.replace('.', '/') + ";)L" + tooltipComponent.replace('.', '/') + ";";
            for (MethodNode methodNode : classNode.methods) {
                if (!methodNode.name.equals(ofMethodName) || !methodNode.desc.equals(ofMethodDesc)) continue;
                ShulkerBoxTooltipEarlyRiser.injectIntoOfMethod(methodNode);
                return;
            }
            throw new InjectionException("could not find method " + ofMethodName + ofMethodDesc + " in " + tooltipComponent);
        });
    }

    private static void injectIntoOfMethod(MethodNode methodNode) {
        LabelNode label = null;
        for (AbstractInsnNode insn : methodNode.instructions) {
            LabelNode l;
            AbstractInsnNode abstractInsnNode = insn;
            if (!(abstractInsnNode instanceof LabelNode)) continue;
            label = l = (LabelNode)abstractInsnNode;
            break;
        }
        if (label == null) {
            throw new InjectionException("Could not find a label node target");
        }
        InsnList toAdd = new InsnList();
        String prefix = "com/misterpemodder/shulkerboxtooltip/impl/tooltip/";
        String previewTooltipData = prefix + "PreviewTooltipData";
        String previewTooltipComponent = prefix + "PreviewTooltipComponent";
        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toAdd.add((AbstractInsnNode)new TypeInsnNode(193, previewTooltipData));
        toAdd.add((AbstractInsnNode)new JumpInsnNode(153, label));
        toAdd.add((AbstractInsnNode)new TypeInsnNode(187, previewTooltipComponent));
        toAdd.add((AbstractInsnNode)new InsnNode(89));
        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toAdd.add((AbstractInsnNode)new TypeInsnNode(192, previewTooltipData));
        toAdd.add((AbstractInsnNode)new MethodInsnNode(183, previewTooltipComponent, "<init>", "(L" + previewTooltipData + ";)V"));
        toAdd.add((AbstractInsnNode)new InsnNode(176));
        methodNode.instructions.insertBefore((AbstractInsnNode)label, toAdd);
    }

    private static class InjectionException
    extends RuntimeException {
        private static final long serialVersionUID = 5697454468791313004L;
        private String message;

        public InjectionException(String message) {
            LOGGER.error(message);
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

