/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.expr.ExpressionFloatArrayCached;
import net.optifine.expr.ExpressionFloatCached;
import net.optifine.expr.ExpressionParser;
import net.optifine.expr.ExpressionType;
import net.optifine.expr.IExpression;
import net.optifine.expr.IExpressionBool;
import net.optifine.expr.IExpressionFloat;
import net.optifine.expr.IExpressionFloatArray;
import net.optifine.expr.IExpressionResolver;
import net.optifine.expr.ParseException;
import net.optifine.render.GlAlphaState;
import net.optifine.render.GlBlendState;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.Program;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.ShaderUtils;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersCompatibility;
import net.optifine.shaders.config.RenderScale;
import net.optifine.shaders.config.ScreenShaderOptions;
import net.optifine.shaders.config.ShaderMacro;
import net.optifine.shaders.config.ShaderMacros;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderOptionProfile;
import net.optifine.shaders.config.ShaderOptionResolver;
import net.optifine.shaders.config.ShaderOptionRest;
import net.optifine.shaders.config.ShaderOptionScreen;
import net.optifine.shaders.config.ShaderOptionSwitch;
import net.optifine.shaders.config.ShaderOptionSwitchConst;
import net.optifine.shaders.config.ShaderOptionVariable;
import net.optifine.shaders.config.ShaderOptionVariableConst;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.shaders.config.ShaderParser;
import net.optifine.shaders.config.ShaderProfile;
import net.optifine.shaders.config.ShaderType;
import net.optifine.shaders.uniform.CustomUniform;
import net.optifine.shaders.uniform.CustomUniforms;
import net.optifine.shaders.uniform.ShaderExpressionResolver;
import net.optifine.shaders.uniform.UniformType;
import net.optifine.util.DynamicDimension;
import net.optifine.util.LineBuffer;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShaderPackParser {
    public static final Pattern PATTERN_VERSION = Pattern.compile("^\\s*#version\\s+(\\d+).*$");
    public static final Pattern PATTERN_INCLUDE = Pattern.compile("^\\s*#include\\s+\"([A-Za-z0-9_/\\.]+)\".*$");
    private static final Set<String> setConstNames = ShaderPackParser.makeSetConstNames();
    private static final Map<String, Integer> mapAlphaFuncs = ShaderPackParser.makeMapAlphaFuncs();
    private static final Map<String, Integer> mapBlendFactors = ShaderPackParser.makeMapBlendFactors();

    public static ShaderOption[] parseShaderPackOptions(IShaderPack shaderPack, String[] programNames, List<Integer> listDimensions) {
        if (shaderPack == null) {
            return new ShaderOption[0];
        }
        HashMap mapOptions = new HashMap();
        ShaderPackParser.collectShaderOptions((IShaderPack)shaderPack, (String)"/shaders", (String[])programNames, mapOptions);
        for (int dimId : listDimensions) {
            String dirWorld = "/shaders/world" + dimId;
            ShaderPackParser.collectShaderOptions((IShaderPack)shaderPack, (String)dirWorld, (String[])programNames, mapOptions);
        }
        Collection options = mapOptions.values();
        ShaderOption[] sos = options.toArray(new ShaderOption[options.size()]);
        1 comp = new /* Unavailable Anonymous Inner Class!! */;
        Arrays.sort(sos, comp);
        return sos;
    }

    private static void collectShaderOptions(IShaderPack shaderPack, String dir, String[] programNames, Map<String, ShaderOption> mapOptions) {
        for (int i2 = 0; i2 < programNames.length; ++i2) {
            String programName = programNames[i2];
            if (programName.equals("")) continue;
            String csh = dir + "/" + programName + ".csh";
            String vsh = dir + "/" + programName + ".vsh";
            String gsh = dir + "/" + programName + ".gsh";
            String fsh = dir + "/" + programName + ".fsh";
            ShaderPackParser.collectShaderOptions((IShaderPack)shaderPack, (String)csh, mapOptions);
            ShaderPackParser.collectShaderOptions((IShaderPack)shaderPack, (String)vsh, mapOptions);
            ShaderPackParser.collectShaderOptions((IShaderPack)shaderPack, (String)gsh, mapOptions);
            ShaderPackParser.collectShaderOptions((IShaderPack)shaderPack, (String)fsh, mapOptions);
        }
    }

    private static void collectShaderOptions(IShaderPack sp, String path, Map<String, ShaderOption> mapOptions) {
        String[] lines = ShaderPackParser.getLines((IShaderPack)sp, (String)path);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            ShaderOption so = ShaderPackParser.getShaderOption((String)line, (String)path);
            if (so == null || so.getName().startsWith(ShaderMacros.getPrefixMacro())) continue;
            String key = so.getName();
            ShaderOption so2 = mapOptions.get(key);
            if (so2 != null) {
                if (!Config.equals((Object)so2.getValueDefault(), (Object)so.getValueDefault())) {
                    if (so2.isEnabled()) {
                        Config.warn((String)("Ambiguous shader option: " + so.getName()));
                        Config.warn((String)(" - in " + Config.arrayToString((Object[])so2.getPaths()) + ": " + so2.getValueDefault()));
                        Config.warn((String)(" - in " + Config.arrayToString((Object[])so.getPaths()) + ": " + so.getValueDefault()));
                    }
                    so2.setEnabled(false);
                }
                if (so2.getDescription() == null || so2.getDescription().length() <= 0) {
                    so2.setDescription(so.getDescription());
                }
                so2.addPaths(so.getPaths());
                continue;
            }
            if (so.checkUsed() && !ShaderPackParser.isOptionUsed((ShaderOption)so, (String[])lines)) continue;
            mapOptions.put(key, so);
        }
    }

    private static boolean isOptionUsed(ShaderOption so, String[] lines) {
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            if (!so.isUsedInLine(line)) continue;
            return true;
        }
        return false;
    }

    private static String[] getLines(IShaderPack sp, String path) {
        try {
            ArrayList listFiles = new ArrayList();
            LineBuffer lb = ShaderPackParser.loadFile((String)path, (IShaderPack)sp, (int)0, listFiles, (int)0);
            if (lb == null) {
                return new String[0];
            }
            return lb.getLines();
        }
        catch (IOException e2) {
            Config.dbg((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return new String[0];
        }
    }

    private static ShaderOption getShaderOption(String line, String path) {
        ShaderOption so = null;
        if (so == null) {
            so = ShaderOptionSwitch.parseOption((String)line, (String)path);
        }
        if (so == null) {
            so = ShaderOptionVariable.parseOption((String)line, (String)path);
        }
        if (so != null) {
            return so;
        }
        if (so == null) {
            so = ShaderOptionSwitchConst.parseOption((String)line, (String)path);
        }
        if (so == null) {
            so = ShaderOptionVariableConst.parseOption((String)line, (String)path);
        }
        if (so != null && setConstNames.contains(so.getName())) {
            return so;
        }
        return null;
    }

    private static Set<String> makeSetConstNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("shadowMapResolution");
        set.add("shadowMapFov");
        set.add("shadowDistance");
        set.add("shadowDistanceRenderMul");
        set.add("shadowIntervalSize");
        set.add("generateShadowMipmap");
        set.add("generateShadowColorMipmap");
        set.add("shadowHardwareFiltering");
        set.add("shadowHardwareFiltering0");
        set.add("shadowHardwareFiltering1");
        set.add("shadowtex0Mipmap");
        set.add("shadowtexMipmap");
        set.add("shadowtex1Mipmap");
        set.add("shadowcolor0Mipmap");
        set.add("shadowColor0Mipmap");
        set.add("shadowcolor1Mipmap");
        set.add("shadowColor1Mipmap");
        set.add("shadowtex0Nearest");
        set.add("shadowtexNearest");
        set.add("shadow0MinMagNearest");
        set.add("shadowtex1Nearest");
        set.add("shadow1MinMagNearest");
        set.add("shadowcolor0Nearest");
        set.add("shadowColor0Nearest");
        set.add("shadowColor0MinMagNearest");
        set.add("shadowcolor1Nearest");
        set.add("shadowColor1Nearest");
        set.add("shadowColor1MinMagNearest");
        set.add("wetnessHalflife");
        set.add("drynessHalflife");
        set.add("eyeBrightnessHalflife");
        set.add("centerDepthHalflife");
        set.add("sunPathRotation");
        set.add("ambientOcclusionLevel");
        set.add("superSamplingLevel");
        set.add("noiseTextureResolution");
        return set;
    }

    public static ShaderProfile[] parseProfiles(Properties props, ShaderOption[] shaderOptions) {
        String PREFIX_PROFILE = "profile.";
        ArrayList<ShaderProfile> list = new ArrayList<ShaderProfile>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(PREFIX_PROFILE)) continue;
            String name = string.substring(PREFIX_PROFILE.length());
            String val = props.getProperty(string);
            HashSet parsedProfiles = new HashSet();
            ShaderProfile p = ShaderPackParser.parseProfile((String)name, (Properties)props, parsedProfiles, (ShaderOption[])shaderOptions);
            if (p == null) continue;
            list.add(p);
        }
        if (list.size() <= 0) {
            return null;
        }
        ShaderProfile[] profs = list.toArray(new ShaderProfile[list.size()]);
        return profs;
    }

    public static Map<String, IExpressionBool> parseProgramConditions(Properties props, ShaderOption[] shaderOptions) {
        String PREFIX_PROGRAM = "program.";
        Pattern pattern = Pattern.compile("program\\.([^.]+)\\.enabled");
        HashMap<String, IExpressionBool> map = new HashMap<String, IExpressionBool>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            String val = props.getProperty(string).trim();
            IExpressionBool expr = ShaderPackParser.parseOptionExpression((String)val, (ShaderOption[])shaderOptions);
            if (expr == null) {
                SMCLog.severe((String)("Error parsing program condition: " + string));
                continue;
            }
            map.put(name, expr);
        }
        return map;
    }

    private static IExpressionBool parseOptionExpression(String val, ShaderOption[] shaderOptions) {
        try {
            ShaderOptionResolver sor = new ShaderOptionResolver(shaderOptions);
            ExpressionParser parser = new ExpressionParser((IExpressionResolver)sor);
            IExpressionBool expr = parser.parseBool(val);
            return expr;
        }
        catch (ParseException e2) {
            SMCLog.warning((String)(((Object)((Object)e2)).getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
    }

    public static Set<String> parseOptionSliders(Properties props, ShaderOption[] shaderOptions) {
        HashSet<String> sliders = new HashSet<String>();
        String value = props.getProperty("sliders");
        if (value == null) {
            return sliders;
        }
        String[] names = Config.tokenize((String)value, (String)" ");
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            ShaderOption so = ShaderUtils.getShaderOption((String)name, (ShaderOption[])shaderOptions);
            if (so == null) {
                Config.warn((String)("Invalid shader option: " + name));
                continue;
            }
            sliders.add(name);
        }
        return sliders;
    }

    private static ShaderProfile parseProfile(String name, Properties props, Set<String> parsedProfiles, ShaderOption[] shaderOptions) {
        String PREFIX_PROFILE = "profile.";
        String key = PREFIX_PROFILE + name;
        if (parsedProfiles.contains(key)) {
            Config.warn((String)("[Shaders] Profile already parsed: " + name));
            return null;
        }
        parsedProfiles.add(name);
        ShaderProfile prof = new ShaderProfile(name);
        String val = props.getProperty(key);
        String[] parts = Config.tokenize((String)val, (String)" ");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String option;
            String part = parts[i2];
            if (part.startsWith(PREFIX_PROFILE)) {
                String nameParent = part.substring(PREFIX_PROFILE.length());
                ShaderProfile profParent = ShaderPackParser.parseProfile((String)nameParent, (Properties)props, parsedProfiles, (ShaderOption[])shaderOptions);
                if (prof == null) continue;
                prof.addOptionValues(profParent);
                prof.addDisabledPrograms(profParent.getDisabledPrograms());
                continue;
            }
            String[] tokens = Config.tokenize((String)part, (String)":=");
            if (tokens.length == 1) {
                String PREFIX_PROGRAM;
                option = tokens[0];
                boolean on = true;
                if (option.startsWith("!")) {
                    on = false;
                    option = option.substring(1);
                }
                if (option.startsWith(PREFIX_PROGRAM = "program.")) {
                    String program = option.substring(PREFIX_PROGRAM.length());
                    if (!Shaders.isProgramPath((String)program)) {
                        Config.warn((String)("Invalid program: " + program + " in profile: " + prof.getName()));
                        continue;
                    }
                    if (on) {
                        prof.removeDisabledProgram(program);
                        continue;
                    }
                    prof.addDisabledProgram(program);
                    continue;
                }
                ShaderOption so = ShaderUtils.getShaderOption((String)option, (ShaderOption[])shaderOptions);
                if (!(so instanceof ShaderOptionSwitch)) {
                    Config.warn((String)("[Shaders] Invalid option: " + option));
                    continue;
                }
                prof.addOptionValue(option, String.valueOf(on));
                so.setVisible(true);
                continue;
            }
            if (tokens.length != 2) {
                Config.warn((String)("[Shaders] Invalid option value: " + part));
                continue;
            }
            option = tokens[0];
            String value = tokens[1];
            ShaderOption so = ShaderUtils.getShaderOption((String)option, (ShaderOption[])shaderOptions);
            if (so == null) {
                Config.warn((String)("[Shaders] Invalid option: " + part));
                continue;
            }
            if (!so.isValidValue(value)) {
                Config.warn((String)("[Shaders] Invalid value: " + part));
                continue;
            }
            so.setVisible(true);
            prof.addOptionValue(option, value);
        }
        return prof;
    }

    public static Map<String, ScreenShaderOptions> parseGuiScreens(Properties props, ShaderProfile[] shaderProfiles, ShaderOption[] shaderOptions) {
        HashMap<String, ScreenShaderOptions> map = new HashMap<String, ScreenShaderOptions>();
        ShaderPackParser.parseGuiScreen((String)"screen", (Properties)props, map, (ShaderProfile[])shaderProfiles, (ShaderOption[])shaderOptions);
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    private static boolean parseGuiScreen(String key, Properties props, Map<String, ScreenShaderOptions> map, ShaderProfile[] shaderProfiles, ShaderOption[] shaderOptions) {
        String val = props.getProperty(key);
        if (val == null) {
            return false;
        }
        String keyParent = key + "$parent$";
        if (map.containsKey(keyParent)) {
            Config.warn((String)("[Shaders] Screen circular reference: " + key + " = " + val));
            return false;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        HashSet<String> setNames = new HashSet<String>();
        String[] opNames = Config.tokenize((String)val, (String)" ");
        for (int i2 = 0; i2 < opNames.length; ++i2) {
            String opName = opNames[i2];
            if (opName.equals("<empty>")) {
                list.add(null);
                continue;
            }
            if (setNames.contains(opName)) {
                Config.warn((String)("[Shaders] Duplicate option: " + opName + ", key: " + key));
                continue;
            }
            setNames.add(opName);
            if (opName.equals("<profile>")) {
                if (shaderProfiles == null) {
                    Config.warn((String)("[Shaders] Option profile can not be used, no profiles defined: " + opName + ", key: " + key));
                    continue;
                }
                ShaderOptionProfile optionProfile = new ShaderOptionProfile(shaderProfiles, shaderOptions);
                list.add(optionProfile);
                continue;
            }
            if (opName.equals("*")) {
                ShaderOptionRest soRest = new ShaderOptionRest("<rest>");
                list.add(soRest);
                continue;
            }
            if (opName.startsWith("[") && opName.endsWith("]")) {
                String screen = StrUtils.removePrefixSuffix((String)opName, (String)"[", (String)"]");
                if (!screen.matches("^[a-zA-Z0-9_]+$")) {
                    Config.warn((String)("[Shaders] Invalid screen: " + opName + ", key: " + key));
                    continue;
                }
                map.put(keyParent, null);
                boolean parseScreen = ShaderPackParser.parseGuiScreen((String)("screen." + screen), (Properties)props, map, (ShaderProfile[])shaderProfiles, (ShaderOption[])shaderOptions);
                map.remove(keyParent);
                if (!parseScreen) {
                    Config.warn((String)("[Shaders] Invalid screen: " + opName + ", key: " + key));
                    continue;
                }
                ShaderOptionScreen optionScreen = new ShaderOptionScreen(screen);
                list.add(optionScreen);
                continue;
            }
            ShaderOption so = ShaderUtils.getShaderOption((String)opName, (ShaderOption[])shaderOptions);
            if (so == null) {
                Config.warn((String)("[Shaders] Invalid option: " + opName + ", key: " + key));
                list.add(null);
                continue;
            }
            so.setVisible(true);
            list.add(so);
        }
        ShaderOption[] scrOps = list.toArray(new ShaderOption[list.size()]);
        String colStr = props.getProperty(key + ".columns");
        int columns = Config.parseInt((String)colStr, (int)2);
        ScreenShaderOptions sso = new ScreenShaderOptions(key, scrOps, columns);
        map.put(key, sso);
        return true;
    }

    public static LineBuffer loadShader(Program program, ShaderType shaderType, InputStream is, String filePath, IShaderPack shaderPack, List<String> listFiles, ShaderOption[] activeOptions) throws IOException {
        LineBuffer reader = LineBuffer.readAll((Reader)new InputStreamReader(is));
        reader = ShaderPackParser.resolveIncludes((LineBuffer)reader, (String)filePath, (IShaderPack)shaderPack, (int)0, listFiles, (int)0);
        reader = ShaderPackParser.addMacros((LineBuffer)reader, (int)0);
        reader = ShaderPackParser.remapTextureUnits((LineBuffer)reader);
        LineBuffer writer = new LineBuffer();
        for (String line : reader) {
            line = ShaderPackParser.applyOptions((String)line, (ShaderOption[])activeOptions);
            writer.add(line);
        }
        writer = ShadersCompatibility.remap((Program)program, (ShaderType)shaderType, (LineBuffer)writer);
        return writer;
    }

    private static String applyOptions(String line, ShaderOption[] ops) {
        if (ops == null || ops.length <= 0) {
            return line;
        }
        for (int i2 = 0; i2 < ops.length; ++i2) {
            ShaderOption op = ops[i2];
            if (!op.matchesLine(line)) continue;
            line = op.getSourceLine();
            break;
        }
        return line;
    }

    public static LineBuffer resolveIncludes(LineBuffer reader, String filePath, IShaderPack shaderPack, int fileIndex, List<String> listFiles, int includeLevel) throws IOException {
        String fileDir = "/";
        int pos = filePath.lastIndexOf("/");
        if (pos >= 0) {
            fileDir = filePath.substring(0, pos);
        }
        LineBuffer writer = new LineBuffer();
        int lineNumber = 0;
        for (String line : reader) {
            ++lineNumber;
            Matcher mi = PATTERN_INCLUDE.matcher(line);
            if (mi.matches()) {
                int includeFileIndex;
                LineBuffer lbInc;
                String filePathInc;
                String fileInc = mi.group(1);
                boolean absolute = fileInc.startsWith("/");
                String string = filePathInc = absolute ? "/shaders" + fileInc : fileDir + "/" + fileInc;
                if (!listFiles.contains(filePathInc)) {
                    listFiles.add(filePathInc);
                }
                if ((lbInc = ShaderPackParser.loadFile((String)filePathInc, (IShaderPack)shaderPack, (int)(includeFileIndex = listFiles.indexOf(filePathInc) + 1), listFiles, (int)includeLevel)) == null) {
                    throw new IOException("Included file not found: " + filePath);
                }
                if (lbInc.indexMatch(PATTERN_VERSION) < 0) {
                    writer.add("#line 1 " + includeFileIndex);
                }
                writer.add(lbInc.getLines());
                writer.add("#line " + (lineNumber + 1) + " " + fileIndex);
                continue;
            }
            writer.add(line);
        }
        return writer;
    }

    public static LineBuffer addMacros(LineBuffer reader, int fileIndex) throws IOException {
        LineBuffer writer = new LineBuffer(reader.getLines());
        int macroInsertPosition = writer.indexMatch(PATTERN_VERSION);
        if (macroInsertPosition < 0) {
            Config.warn((String)"Macro insert position not found");
            return reader;
        }
        String lineMacro = "#line " + (++macroInsertPosition + 1) + " " + fileIndex;
        String[] headerMacros = ShaderMacros.getHeaderMacroLines();
        writer.insert(macroInsertPosition, headerMacros);
        ShaderMacro[] customMacros = ShaderPackParser.getCustomMacros((LineBuffer)writer, (int)(macroInsertPosition += headerMacros.length));
        if (customMacros.length > 0) {
            LineBuffer lb = new LineBuffer();
            for (int i2 = 0; i2 < customMacros.length; ++i2) {
                ShaderMacro macro = customMacros[i2];
                lb.add(macro.getSourceLine());
            }
            writer.insert(macroInsertPosition, lb.getLines());
            macroInsertPosition += lb.size();
        }
        writer.insert(macroInsertPosition, lineMacro);
        return writer;
    }

    private static ShaderMacro[] getCustomMacros(LineBuffer lines, int startPos) {
        LinkedHashSet<ShaderMacro> setMacros = new LinkedHashSet<ShaderMacro>();
        for (int i2 = startPos; i2 < lines.size(); ++i2) {
            String line = lines.get(i2);
            if (!line.contains(ShaderMacros.getPrefixMacro())) continue;
            ShaderMacro[] lineExts = ShaderPackParser.findMacros((String)line, (ShaderMacro[])ShaderMacros.getExtensions());
            setMacros.addAll(Arrays.asList(lineExts));
            ShaderMacro[] lineConsts = ShaderPackParser.findMacros((String)line, (ShaderMacro[])ShaderMacros.getConstantMacros());
            setMacros.addAll(Arrays.asList(lineConsts));
        }
        ShaderMacro[] macros = setMacros.toArray(new ShaderMacro[setMacros.size()]);
        return macros;
    }

    public static LineBuffer remapTextureUnits(LineBuffer reader) throws IOException {
        if (!Shaders.isRemapLightmap()) {
            return reader;
        }
        LineBuffer writer = new LineBuffer();
        for (String line : reader) {
            String lineNew = line.replace("gl_TextureMatrix[1]", "gl_TextureMatrix[2]");
            if (!(lineNew = lineNew.replace("gl_MultiTexCoord1", "gl_MultiTexCoord2")).equals(line)) {
                line = lineNew = lineNew + " // Legacy fix, replaced TU 1 with 2";
            }
            writer.add(line);
        }
        return writer;
    }

    private static ShaderMacro[] findMacros(String line, ShaderMacro[] macros) {
        ArrayList<ShaderMacro> list = new ArrayList<ShaderMacro>();
        for (int i2 = 0; i2 < macros.length; ++i2) {
            ShaderMacro ext = macros[i2];
            if (!line.contains(ext.getName())) continue;
            list.add(ext);
        }
        ShaderMacro[] exts = list.toArray(new ShaderMacro[list.size()]);
        return exts;
    }

    private static LineBuffer loadFile(String filePath, IShaderPack shaderPack, int fileIndex, List<String> listFiles, int includeLevel) throws IOException {
        if (includeLevel >= 10) {
            throw new IOException("#include depth exceeded: " + includeLevel + ", file: " + filePath);
        }
        ++includeLevel;
        InputStream in = shaderPack.getResourceAsStream(filePath);
        if (in == null) {
            return null;
        }
        InputStreamReader isr = new InputStreamReader(in, "ASCII");
        LineBuffer br = LineBuffer.readAll((Reader)isr);
        br = ShaderPackParser.resolveIncludes((LineBuffer)br, (String)filePath, (IShaderPack)shaderPack, (int)fileIndex, listFiles, (int)includeLevel);
        return br;
    }

    public static CustomUniforms parseCustomUniforms(Properties props) {
        String UNIFORM = "uniform";
        String VARIABLE = "variable";
        String PREFIX_UNIFORM = UNIFORM + ".";
        String PREFIX_VARIABLE = VARIABLE + ".";
        HashMap<String, IExpression> mapExpressions = new HashMap<String, IExpression>();
        ArrayList<CustomUniform> listUniforms = new ArrayList<CustomUniform>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String[] keyParts = Config.tokenize((String)string, (String)".");
            if (keyParts.length != 3) continue;
            String kind = keyParts[0];
            String type = keyParts[1];
            String name = keyParts[2];
            String src = props.getProperty(string).trim();
            if (mapExpressions.containsKey(name)) {
                SMCLog.warning((String)("Expression already defined: " + name));
                continue;
            }
            if (!kind.equals(UNIFORM) && !kind.equals(VARIABLE)) continue;
            SMCLog.info((String)("Custom " + kind + ": " + name));
            CustomUniform cu = ShaderPackParser.parseCustomUniform((String)kind, (String)name, (String)type, (String)src, mapExpressions);
            if (cu == null) continue;
            mapExpressions.put(name, cu.getExpression());
            if (kind.equals(VARIABLE)) continue;
            listUniforms.add(cu);
        }
        if (listUniforms.size() <= 0) {
            return null;
        }
        CustomUniform[] cusArr = listUniforms.toArray(new CustomUniform[listUniforms.size()]);
        CustomUniforms customUniforms = new CustomUniforms(cusArr, mapExpressions);
        return customUniforms;
    }

    private static CustomUniform parseCustomUniform(String kind, String name, String type, String src, Map<String, IExpression> mapExpressions) {
        try {
            UniformType uniformType = UniformType.parse((String)type);
            if (uniformType == null) {
                SMCLog.warning((String)("Unknown " + kind + " type: " + uniformType));
                return null;
            }
            ShaderExpressionResolver resolver = new ShaderExpressionResolver(mapExpressions);
            ExpressionParser parser = new ExpressionParser((IExpressionResolver)resolver);
            IExpression expr = parser.parse(src);
            ExpressionType expressionType = expr.getExpressionType();
            if (!uniformType.matchesExpressionType(expressionType)) {
                SMCLog.warning((String)("Expression type does not match " + kind + " type, expression: " + expressionType + ", " + kind + ": " + uniformType + " " + name));
                return null;
            }
            expr = ShaderPackParser.makeExpressionCached((IExpression)expr);
            CustomUniform cu = new CustomUniform(name, uniformType, expr);
            return cu;
        }
        catch (ParseException e2) {
            SMCLog.warning((String)(((Object)((Object)e2)).getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
    }

    private static IExpression makeExpressionCached(IExpression expr) {
        if (expr instanceof IExpressionFloat) {
            return new ExpressionFloatCached((IExpressionFloat)expr);
        }
        if (expr instanceof IExpressionFloatArray) {
            return new ExpressionFloatArrayCached((IExpressionFloatArray)expr);
        }
        return expr;
    }

    public static void parseAlphaStates(Properties props) {
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String[] keyParts = Config.tokenize((String)string, (String)".");
            if (keyParts.length != 2) continue;
            String type = keyParts[0];
            String programName = keyParts[1];
            if (!type.equals("alphaTest")) continue;
            Program program = Shaders.getProgram((String)programName);
            if (program == null) {
                SMCLog.severe((String)("Invalid program name: " + programName));
                continue;
            }
            String val = props.getProperty(string).trim();
            GlAlphaState state = ShaderPackParser.parseAlphaState((String)val);
            if (state == null) continue;
            program.setAlphaState(state);
        }
    }

    public static GlAlphaState parseAlphaState(String str) {
        if (str == null) {
            return null;
        }
        String[] parts = Config.tokenize((String)str, (String)" ");
        if (parts.length == 1) {
            String str0 = parts[0];
            if (str0.equals("off") || str0.equals("false")) {
                return new GlAlphaState(false);
            }
        } else if (parts.length == 2) {
            String str0 = parts[0];
            String str1 = parts[1];
            Integer func = (Integer)mapAlphaFuncs.get(str0);
            float ref = Config.parseFloat((String)str1, (float)-1.0f);
            if (func != null && ref >= 0.0f) {
                return new GlAlphaState(true, func.intValue(), ref);
            }
        }
        SMCLog.severe((String)("Invalid alpha test: " + str));
        return null;
    }

    public static void parseBlendStates(Properties props) {
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String bufferName;
            String[] keyParts = Config.tokenize((String)string, (String)".");
            if (keyParts.length < 2 || keyParts.length > 3) continue;
            String type = keyParts[0];
            String programName = keyParts[1];
            String string2 = bufferName = keyParts.length == 3 ? keyParts[2] : null;
            if (!type.equals("blend")) continue;
            Program program = Shaders.getProgram((String)programName);
            if (program == null) {
                SMCLog.severe((String)("Invalid program name: " + programName));
                continue;
            }
            String val = props.getProperty(string).trim();
            GlBlendState state = ShaderPackParser.parseBlendState((String)val);
            if (state == null) continue;
            if (bufferName != null) {
                int maxColorIndex;
                int index = program.getProgramStage().isAnyShadow() ? ShaderParser.getShadowColorIndex((String)bufferName) : Shaders.getBufferIndex((String)bufferName);
                int n = maxColorIndex = program.getProgramStage().isAnyShadow() ? 2 : 16;
                if (index < 0 || index >= maxColorIndex) {
                    SMCLog.severe((String)("Invalid buffer name: " + bufferName));
                    continue;
                }
                program.setBlendStateColorIndexed(index, state);
                SMCLog.info((String)("Blend " + programName + "." + bufferName + "=" + val));
                continue;
            }
            program.setBlendState(state);
        }
    }

    public static GlBlendState parseBlendState(String str) {
        if (str == null) {
            return null;
        }
        String[] parts = Config.tokenize((String)str, (String)" ");
        if (parts.length == 1) {
            String str0 = parts[0];
            if (str0.equals("off") || str0.equals("false")) {
                return new GlBlendState(false);
            }
        } else if (parts.length == 2 || parts.length == 4) {
            String str0 = parts[0];
            String str1 = parts[1];
            String str2 = str0;
            String str3 = str1;
            if (parts.length == 4) {
                str2 = parts[2];
                str3 = parts[3];
            }
            Integer src = (Integer)mapBlendFactors.get(str0);
            Integer dst = (Integer)mapBlendFactors.get(str1);
            Integer srcAlpha = (Integer)mapBlendFactors.get(str2);
            Integer dstAlpha = (Integer)mapBlendFactors.get(str3);
            if (src != null && dst != null && srcAlpha != null && dstAlpha != null) {
                return new GlBlendState(true, src.intValue(), dst.intValue(), srcAlpha.intValue(), dstAlpha.intValue());
            }
        }
        SMCLog.severe((String)("Invalid blend mode: " + str));
        return null;
    }

    public static void parseRenderScales(Properties props) {
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String[] keyParts = Config.tokenize((String)string, (String)".");
            if (keyParts.length != 2) continue;
            String type = keyParts[0];
            String programName = keyParts[1];
            if (!type.equals("scale")) continue;
            Program program = Shaders.getProgram((String)programName);
            if (program == null) {
                SMCLog.severe((String)("Invalid program name: " + programName));
                continue;
            }
            String val = props.getProperty(string).trim();
            RenderScale scale = ShaderPackParser.parseRenderScale((String)val);
            if (scale == null) continue;
            program.setRenderScale(scale);
        }
    }

    private static RenderScale parseRenderScale(String str) {
        if (str == null) {
            return null;
        }
        String[] parts = Config.tokenize((String)str, (String)" ");
        float scale = Config.parseFloat((String)parts[0], (float)-1.0f);
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (parts.length > 1) {
            if (parts.length != 3) {
                SMCLog.severe((String)("Invalid render scale: " + str));
                return null;
            }
            offsetX = Config.parseFloat((String)parts[1], (float)-1.0f);
            offsetY = Config.parseFloat((String)parts[2], (float)-1.0f);
        }
        if (!(Config.between((float)scale, (float)0.0f, (float)1.0f) && Config.between((float)offsetX, (float)0.0f, (float)1.0f) && Config.between((float)offsetY, (float)0.0f, (float)1.0f))) {
            SMCLog.severe((String)("Invalid render scale: " + str));
            return null;
        }
        return new RenderScale(scale, offsetX, offsetY);
    }

    public static void parseBuffersFlip(Properties props) {
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String[] keyParts = Config.tokenize((String)string, (String)".");
            if (keyParts.length != 3) continue;
            String type = keyParts[0];
            String programName = keyParts[1];
            String bufferName = keyParts[2];
            if (!type.equals("flip")) continue;
            Program program = Shaders.getProgram((String)programName);
            if (program == null) {
                SMCLog.severe((String)("Invalid program name: " + programName));
                continue;
            }
            Boolean[] buffersFlip = program.getBuffersFlip();
            int buffer = Shaders.getBufferIndex((String)bufferName);
            if (buffer < 0 || buffer >= buffersFlip.length) {
                SMCLog.severe((String)("Invalid buffer name: " + bufferName));
                continue;
            }
            String valStr = props.getProperty(string).trim();
            Boolean val = Config.parseBoolean((String)valStr, null);
            if (val == null) {
                SMCLog.severe((String)("Invalid boolean value: " + valStr));
                continue;
            }
            buffersFlip[buffer] = val;
        }
    }

    private static Map<String, Integer> makeMapAlphaFuncs() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("NEVER", new Integer(512));
        map.put("LESS", new Integer(513));
        map.put("EQUAL", new Integer(514));
        map.put("LEQUAL", new Integer(515));
        map.put("GREATER", new Integer(516));
        map.put("NOTEQUAL", new Integer(517));
        map.put("GEQUAL", new Integer(518));
        map.put("ALWAYS", new Integer(519));
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, Integer> makeMapBlendFactors() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("ZERO", new Integer(0));
        map.put("ONE", new Integer(1));
        map.put("SRC_COLOR", new Integer(768));
        map.put("ONE_MINUS_SRC_COLOR", new Integer(769));
        map.put("DST_COLOR", new Integer(774));
        map.put("ONE_MINUS_DST_COLOR", new Integer(775));
        map.put("SRC_ALPHA", new Integer(770));
        map.put("ONE_MINUS_SRC_ALPHA", new Integer(771));
        map.put("DST_ALPHA", new Integer(772));
        map.put("ONE_MINUS_DST_ALPHA", new Integer(773));
        map.put("CONSTANT_COLOR", new Integer(32769));
        map.put("ONE_MINUS_CONSTANT_COLOR", new Integer(32770));
        map.put("CONSTANT_ALPHA", new Integer(32771));
        map.put("ONE_MINUS_CONSTANT_ALPHA", new Integer(32772));
        map.put("SRC_ALPHA_SATURATE", new Integer(776));
        return Collections.unmodifiableMap(map);
    }

    public static DynamicDimension[] parseBufferSizes(Properties props, int countBuffers) {
        DynamicDimension[] bufferSizes = new DynamicDimension[countBuffers];
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String[] keyParts;
            if (!string.startsWith("size.buffer.") || (keyParts = Config.tokenize((String)string, (String)".")).length != 3) continue;
            String bufferName = keyParts[2];
            int buffer = Shaders.getBufferIndex((String)bufferName);
            if (buffer < 0 || buffer >= bufferSizes.length) {
                SMCLog.severe((String)("Invalid buffer name: " + string));
                continue;
            }
            String val = props.getProperty(string).trim();
            DynamicDimension dim = ShaderPackParser.parseDynamicDimension((String)val);
            if (dim == null) {
                SMCLog.severe((String)("Invalid buffer size: " + string + "=" + val));
                continue;
            }
            bufferSizes[buffer] = dim;
            if (dim.isRelative()) {
                SMCLog.info((String)("Relative size " + bufferName + ": " + dim.getWidth() + " " + dim.getHeight()));
                continue;
            }
            SMCLog.info((String)("Fixed size " + bufferName + ": " + (int)dim.getWidth() + " " + (int)dim.getHeight()));
        }
        return bufferSizes;
    }

    private static DynamicDimension parseDynamicDimension(String str) {
        if (str == null) {
            return null;
        }
        String[] parts = Config.tokenize((String)str, (String)" ");
        if (parts.length != 2) {
            return null;
        }
        int width = Config.parseInt((String)parts[0], (int)-1);
        int height = Config.parseInt((String)parts[1], (int)-1);
        if (width >= 0 && height >= 0) {
            return new DynamicDimension(false, (float)width, (float)height);
        }
        float widthRel = Config.parseFloat((String)parts[0], (float)-1.0f);
        float heightRel = Config.parseFloat((String)parts[1], (float)-1.0f);
        if (widthRel >= 0.0f && heightRel >= 0.0f) {
            return new DynamicDimension(true, widthRel, heightRel);
        }
        return null;
    }
}

