/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.player;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import net.optifine.Config;
import net.optifine.http.HttpPipeline;
import net.optifine.http.HttpUtils;
import net.optifine.player.PlayerConfiguration;
import net.optifine.player.PlayerItemModel;
import net.optifine.player.PlayerItemParser;
import net.optifine.util.Json;

public class PlayerConfigurationParser {
    private String player = null;
    public static final String CONFIG_ITEMS = "items";
    public static final String ITEM_TYPE = "type";
    public static final String ITEM_ACTIVE = "active";

    public PlayerConfigurationParser(String player) {
        this.player = player;
    }

    public PlayerConfiguration parsePlayerConfiguration(JsonElement je) {
        if (je == null) {
            throw new JsonParseException("JSON object is null, player: " + this.player);
        }
        JsonObject jo = (JsonObject)je;
        PlayerConfiguration pc2 = new PlayerConfiguration();
        JsonArray items = (JsonArray)jo.get(CONFIG_ITEMS);
        if (items != null) {
            for (int i2 = 0; i2 < items.size(); ++i2) {
                PlayerItemModel model;
                JsonObject item = (JsonObject)items.get(i2);
                boolean active = Json.getBoolean((JsonObject)item, (String)ITEM_ACTIVE, (boolean)true);
                if (!active) continue;
                String type = Json.getString((JsonObject)item, (String)ITEM_TYPE);
                if (type == null) {
                    Config.warn((String)("Item type is null, player: " + this.player));
                    continue;
                }
                String modelPath = Json.getString((JsonObject)item, (String)"model");
                if (modelPath == null) {
                    modelPath = "items/" + type + "/model.cfg";
                }
                if ((model = this.downloadModel(modelPath)) == null) continue;
                if (!model.isUsePlayerTexture()) {
                    dpm image;
                    String texturePath = Json.getString((JsonObject)item, (String)"texture");
                    if (texturePath == null) {
                        texturePath = "items/" + type + "/users/" + this.player + ".png";
                    }
                    if ((image = this.downloadTextureImage(texturePath)) == null) continue;
                    model.setTextureImage(image);
                    ww loc = new ww("optifine.net", texturePath);
                    model.setTextureLocation(loc);
                }
                pc2.addPlayerItemModel(model);
            }
        }
        return pc2;
    }

    private dpm downloadTextureImage(String texturePath) {
        String textureUrl = HttpUtils.getPlayerItemsUrl() + "/" + texturePath;
        try {
            byte[] body = HttpPipeline.get((String)textureUrl, (Proxy)dvp.C().L());
            dpm image = dpm.a((InputStream)new ByteArrayInputStream(body));
            return image;
        }
        catch (IOException e2) {
            Config.warn((String)("Error loading item texture " + texturePath + ": " + e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
    }

    private PlayerItemModel downloadModel(String modelPath) {
        String modelUrl = HttpUtils.getPlayerItemsUrl() + "/" + modelPath;
        try {
            byte[] bytes = HttpPipeline.get((String)modelUrl, (Proxy)dvp.C().L());
            String jsonStr = new String(bytes, "ASCII");
            JsonParser jp = new JsonParser();
            JsonObject jo = (JsonObject)jp.parse(jsonStr);
            PlayerItemModel pim = PlayerItemParser.parseItemModel((JsonObject)jo);
            return pim;
        }
        catch (Exception e2) {
            Config.warn((String)("Error loading item model " + modelPath + ": " + e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
    }
}

