/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<atk, cis> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(atk entityType, String name, float shadowSize) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, null);
    }

    public ModelAdapter(atk entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(cis tileEntityType, String name, float shadowSize) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(cis tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<atk, cis> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<atk, cis> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract egu makeModel();

    public abstract eir getModelRenderer(egu var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(egu var1, float var2);

    public boolean setTextureLocation(IEntityRenderer er, ww textureLocation) {
        return false;
    }

    public eir[] getModelRenderers(egu model) {
        String[] names = this.getModelRendererNames();
        ArrayList<eir> list = new ArrayList<eir>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            eir mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        eir[] mrs = list.toArray(new eir[list.size()]);
        return mrs;
    }

    public static eir bakeModelLayer(eip loc) {
        return dvp.C().ac().getContext().a(loc);
    }
}

