/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomEntities {
    private static Map<String, RandomEntityProperties> mapProperties = new HashMap();
    private static boolean active = false;
    private static eng renderGlobal;
    private static RandomEntity randomEntity;
    private static epe tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_OPTIFINE_MOB = "optifine/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(atg entity, bwq world) {
        if (world == null) {
            return;
        }
        wi edm = entity.ad();
        edm.spawnPosition = entity.cR();
        edm.spawnBiome = world.w(edm.spawnPosition);
        if (entity instanceof bet) {
            bet esr = (bet)entity;
            RandomEntities.checkEntityShoulder((bet)esr, (boolean)false);
        }
    }

    public static void entityUnloaded(atg entity, bwq world) {
        if (entity instanceof bet) {
            bet esr = (bet)entity;
            RandomEntities.checkEntityShoulder((bet)esr, (boolean)true);
        }
    }

    private static void checkEntityShoulder(bet entity, boolean attach) {
        atu owner = entity.fx();
        if (owner == null) {
            owner = Config.getMinecraft().s;
        }
        if (!(owner instanceof emj)) {
            return;
        }
        emj player = (emj)owner;
        UUID entityUuid = entity.ch();
        if (attach) {
            na nbtRight;
            na nbtLeft = player.fA();
            if (nbtLeft != null && nbtLeft.e("UUID") && Config.equals((Object)nbtLeft.a("UUID"), (Object)entityUuid)) {
                player.entityShoulderLeft = entity;
            }
            if ((nbtRight = player.fB()) != null && nbtRight.e("UUID") && Config.equals((Object)nbtRight.a("UUID"), (Object)entityUuid)) {
                player.entityShoulderRight = entity;
            }
        } else {
            wi edm = entity.ad();
            if (player.entityShoulderLeft != null && Config.equals((Object)player.entityShoulderLeft.ch(), (Object)entityUuid)) {
                wi edmShoulderLeft = player.entityShoulderLeft.ad();
                edm.spawnPosition = edmShoulderLeft.spawnPosition;
                edm.spawnBiome = edmShoulderLeft.spawnBiome;
                player.entityShoulderLeft = null;
            }
            if (player.entityShoulderRight != null && Config.equals((Object)player.entityShoulderRight.ch(), (Object)entityUuid)) {
                wi edmShoulderRight = player.entityShoulderRight.ad();
                edm.spawnPosition = edmShoulderRight.spawnPosition;
                edm.spawnBiome = edmShoulderRight.spawnBiome;
                player.entityShoulderRight = null;
            }
        }
    }

    public static void worldChanged(bwq oldWorld, bwq newWorld) {
        if (newWorld instanceof eji) {
            eji newWorldClient = (eji)newWorld;
            Iterable entities = newWorldClient.b();
            for (atg entity : entities) {
                RandomEntities.entityLoaded((atg)entity, (bwq)newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ww getTextureLocation(ww loc) {
        if (!active) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            IRandomEntity re = RandomEntities.getRandomEntityRendered();
            if (re == null) {
                ww ww2 = loc;
                return ww2;
            }
            String name = loc.a();
            if (name.startsWith("horse/")) {
                name = RandomEntities.getHorseTexturePath((String)name, (int)"horse/".length());
            }
            if (!name.startsWith("textures/entity/") && !name.startsWith("textures/painting/")) {
                ww ww3 = loc;
                return ww3;
            }
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(name);
            if (props == null) {
                ww ww4 = loc;
                return ww4;
            }
            ww ww5 = props.getTextureLocation(loc, re);
            return ww5;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i2 = 0; i2 < HORSE_TEXTURES_ABBR.length; ++i2) {
            String abbr = HORSE_TEXTURES_ABBR[i2];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i2];
        }
        return path;
    }

    public static IRandomEntity getRandomEntityRendered() {
        if (RandomEntities.renderGlobal.renderedEntity != null) {
            randomEntity.setEntity(RandomEntities.renderGlobal.renderedEntity);
            return randomEntity;
        }
        if (epe.tileEntityRendered != null) {
            ciq te = epe.tileEntityRendered;
            if (te.k() != null) {
                randomTileEntity.setTileEntity(te);
                return randomTileEntity;
            }
        }
        return null;
    }

    private static RandomEntityProperties makeProperties(ww loc, boolean optifine) {
        RandomEntityProperties props;
        String path = loc.a();
        ww locProps = RandomEntities.getLocationProperties((ww)loc, (boolean)optifine);
        if (locProps != null && (props = RandomEntities.parseProperties((ww)locProps, (ww)loc)) != null) {
            return props;
        }
        ww[] variants = RandomEntities.getLocationsVariants((ww)loc, (boolean)optifine);
        if (variants == null) {
            return null;
        }
        return new RandomEntityProperties(path, variants);
    }

    private static RandomEntityProperties parseProperties(ww propLoc, ww resLoc) {
        try {
            String path = propLoc.a();
            RandomEntities.dbg((String)(resLoc.a() + ", properties: " + path));
            InputStream in = Config.getResourceStream((ww)propLoc);
            if (in == null) {
                RandomEntities.warn((String)("Properties not found: " + path));
                return null;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            RandomEntityProperties rmp = new RandomEntityProperties((Properties)props, path, resLoc);
            if (!rmp.isValid(path)) {
                return null;
            }
            return rmp;
        }
        catch (FileNotFoundException e2) {
            RandomEntities.warn((String)("File not found: " + resLoc.a()));
            return null;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    private static ww getLocationProperties(ww loc, boolean optifine) {
        String path;
        String pathBase;
        String pathProps;
        ww locMcp = RandomEntities.getLocationRandom((ww)loc, (boolean)optifine);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        ww locProps = new ww(domain, pathProps = (pathBase = StrUtils.removeSuffix((String)(path = locMcp.a()), (String)".png")) + ".properties");
        if (Config.hasResource((ww)locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath((String)pathBase);
        if (pathParent == null) {
            return null;
        }
        ww locParentProps = new ww(domain, pathParent + ".properties");
        if (Config.hasResource((ww)locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static ww getLocationRandom(ww loc, boolean optifine) {
        String domain = loc.b();
        String path = loc.a();
        String prefixTextures = "textures/";
        String prefixRandom = "optifine/random/";
        if (optifine) {
            prefixTextures = "textures/entity/";
            prefixRandom = "optifine/mob/";
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix((String)path, (String)prefixTextures, (String)prefixRandom);
        return new ww(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith("optifine/random/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/random/", (String)"textures/");
        }
        if (pathRandom.startsWith("optifine/mob/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/mob/", (String)"textures/entity/");
        }
        return null;
    }

    protected static ww getLocationIndexed(ww loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String pathNew = prefix + index + suffix;
        ww locNew = new ww(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i2 = 0; i2 < DEPENDANT_SUFFIXES.length; ++i2) {
            String suffix = DEPENDANT_SUFFIXES[i2];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix((String)path, (String)suffix);
            return pathParent;
        }
        return null;
    }

    private static ww[] getLocationsVariants(ww loc, boolean optifine) {
        ArrayList<ww> list = new ArrayList<ww>();
        list.add(loc);
        ww locRandom = RandomEntities.getLocationRandom((ww)loc, (boolean)optifine);
        if (locRandom == null) {
            return null;
        }
        for (int i2 = 1; i2 < list.size() + 10; ++i2) {
            int index = i2 + 1;
            ww locIndex = RandomEntities.getLocationIndexed((ww)locRandom, (int)index);
            if (!Config.hasResource((ww)locIndex)) continue;
            list.add(locIndex);
        }
        if (list.size() <= 1) {
            return null;
        }
        ww[] locs = list.toArray(new ww[list.size()]);
        RandomEntities.dbg((String)(loc.a() + ", variants: " + locs.length));
        return locs;
    }

    public static void update() {
        renderGlobal = Config.getRenderGlobal();
        tileEntityRendererDispatcher = dvp.C().ad();
        mapProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        String[] prefixes = new String[]{"optifine/random/", "optifine/mob/"};
        String[] suffixes = new String[]{".png", ".properties"};
        String[] pathsRandom = ResUtils.collectFiles((String[])prefixes, (String[])suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i2 = 0; i2 < pathsRandom.length; ++i2) {
            RandomEntityProperties props;
            String path = pathsRandom[i2];
            path = StrUtils.removeSuffix((String)path, (String[])suffixes);
            path = StrUtils.trimTrailing((String)path, (String)"0123456789");
            String pathBase = RandomEntities.getPathBase((String)(path = path + ".png"));
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            ww locBase = new ww(pathBase);
            if (!Config.hasResource((ww)locBase) || (props = (RandomEntityProperties)mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties((ww)locBase, (boolean)false);
            if (props == null) {
                props = RandomEntities.makeProperties((ww)locBase, (boolean)true);
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static void dbg(String str) {
        Config.dbg((String)("RandomEntities: " + str));
    }

    public static void warn(String str) {
        Config.warn((String)("RandomEntities: " + str));
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, bfl.class, String[].class, (int)0);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, bfl.class, String[].class, (int)1);
    }
}

