/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import net.optifine.BlockPosM;
import net.optifine.Config;
import net.optifine.CustomColorFader;
import net.optifine.CustomColormap;
import net.optifine.CustomColors;
import net.optifine.LightMap;
import net.optifine.LightMapPack;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.render.RenderEnv;
import net.optifine.util.BiomeUtils;
import net.optifine.util.EntityUtils;
import net.optifine.util.PotionUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import net.optifine.util.WorldUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomColors {
    private static String paletteFormatDefault = "vanilla";
    private static CustomColormap waterColors = null;
    private static CustomColormap foliagePineColors = null;
    private static CustomColormap foliageBirchColors = null;
    private static CustomColormap swampFoliageColors = null;
    private static CustomColormap swampGrassColors = null;
    private static CustomColormap[] colorsBlockColormaps = null;
    private static CustomColormap[][] blockColormaps = null;
    private static CustomColormap skyColors = null;
    private static CustomColorFader skyColorFader = new CustomColorFader();
    private static CustomColormap fogColors = null;
    private static CustomColorFader fogColorFader = new CustomColorFader();
    private static CustomColormap underwaterColors = null;
    private static CustomColorFader underwaterColorFader = new CustomColorFader();
    private static CustomColormap underlavaColors = null;
    private static CustomColorFader underlavaColorFader = new CustomColorFader();
    private static LightMapPack[] lightMapPacks = null;
    private static int lightmapMinDimensionId = 0;
    private static CustomColormap redstoneColors = null;
    private static CustomColormap xpOrbColors = null;
    private static int xpOrbTime = -1;
    private static CustomColormap durabilityColors = null;
    private static CustomColormap stemColors = null;
    private static CustomColormap stemMelonColors = null;
    private static CustomColormap stemPumpkinColors = null;
    private static CustomColormap myceliumParticleColors = null;
    private static boolean useDefaultGrassFoliageColors = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static int expBarTextColor = -1;
    private static int bossTextColor = -1;
    private static int signTextColor = -1;
    private static dna fogColorNether = null;
    private static dna fogColorEnd = null;
    private static dna skyColorEnd = null;
    private static int[] spawnEggPrimaryColors = null;
    private static int[] spawnEggSecondaryColors = null;
    private static float[][] wolfCollarColors = null;
    private static float[][] sheepColors = null;
    private static int[] textColors = null;
    private static int[] mapColorsOriginal = null;
    private static float[][] dyeColorsOriginal = null;
    private static int[] potionColors = null;
    private static final ckt BLOCK_STATE_DIRT = bzq.j.n();
    private static final ckt BLOCK_STATE_WATER = bzq.A.n();
    public static Random random = new Random();
    private static final IColorizer COLORIZER_GRASS = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_FOLIAGE = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_FOLIAGE_PINE = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_FOLIAGE_BIRCH = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_WATER = new /* Unavailable Anonymous Inner Class!! */;

    public static void update() {
        paletteFormatDefault = "vanilla";
        waterColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        underlavaColors = null;
        redstoneColors = null;
        xpOrbColors = null;
        xpOrbTime = -1;
        durabilityColors = null;
        stemColors = null;
        myceliumParticleColors = null;
        lightMapPacks = null;
        particleWaterColor = -1;
        particlePortalColor = -1;
        lilyPadColor = -1;
        expBarTextColor = -1;
        bossTextColor = -1;
        signTextColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        colorsBlockColormaps = null;
        blockColormaps = null;
        useDefaultGrassFoliageColors = true;
        spawnEggPrimaryColors = null;
        spawnEggSecondaryColors = null;
        wolfCollarColors = null;
        sheepColors = null;
        textColors = null;
        CustomColors.setMapColors((int[])mapColorsOriginal);
        CustomColors.setDyeColors((float[][])dyeColorsOriginal);
        potionColors = null;
        paletteFormatDefault = CustomColors.getValidProperty((String)"optifine/color.properties", (String)"palette.format", (String[])CustomColormap.FORMAT_STRINGS, (String)"vanilla");
        String mcpColormap = "optifine/colormap/";
        String[] waterPaths = new String[]{"water.png", "watercolorx.png"};
        waterColors = CustomColors.getCustomColors((String)mcpColormap, (String[])waterPaths, (int)256, (int)256);
        CustomColors.updateUseDefaultGrassFoliageColors();
        if (!Config.isCustomColors()) {
            return;
        }
        String[] pinePaths = new String[]{"pine.png", "pinecolor.png"};
        foliagePineColors = CustomColors.getCustomColors((String)mcpColormap, (String[])pinePaths, (int)256, (int)256);
        String[] birchPaths = new String[]{"birch.png", "birchcolor.png"};
        foliageBirchColors = CustomColors.getCustomColors((String)mcpColormap, (String[])birchPaths, (int)256, (int)256);
        String[] swampGrassPaths = new String[]{"swampgrass.png", "swampgrasscolor.png"};
        swampGrassColors = CustomColors.getCustomColors((String)mcpColormap, (String[])swampGrassPaths, (int)256, (int)256);
        String[] swampFoliagePaths = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
        swampFoliageColors = CustomColors.getCustomColors((String)mcpColormap, (String[])swampFoliagePaths, (int)256, (int)256);
        String[] sky0Paths = new String[]{"sky0.png", "skycolor0.png"};
        skyColors = CustomColors.getCustomColors((String)mcpColormap, (String[])sky0Paths, (int)256, (int)256);
        String[] fog0Paths = new String[]{"fog0.png", "fogcolor0.png"};
        fogColors = CustomColors.getCustomColors((String)mcpColormap, (String[])fog0Paths, (int)256, (int)256);
        String[] underwaterPaths = new String[]{"underwater.png", "underwatercolor.png"};
        underwaterColors = CustomColors.getCustomColors((String)mcpColormap, (String[])underwaterPaths, (int)256, (int)256);
        String[] underlavaPaths = new String[]{"underlava.png", "underlavacolor.png"};
        underlavaColors = CustomColors.getCustomColors((String)mcpColormap, (String[])underlavaPaths, (int)256, (int)256);
        String[] redstonePaths = new String[]{"redstone.png", "redstonecolor.png"};
        redstoneColors = CustomColors.getCustomColors((String)mcpColormap, (String[])redstonePaths, (int)16, (int)1);
        xpOrbColors = CustomColors.getCustomColors((String)(mcpColormap + "xporb.png"), (int)-1, (int)-1);
        durabilityColors = CustomColors.getCustomColors((String)(mcpColormap + "durability.png"), (int)-1, (int)-1);
        String[] stemPaths = new String[]{"stem.png", "stemcolor.png"};
        stemColors = CustomColors.getCustomColors((String)mcpColormap, (String[])stemPaths, (int)8, (int)1);
        stemPumpkinColors = CustomColors.getCustomColors((String)(mcpColormap + "pumpkinstem.png"), (int)8, (int)1);
        stemMelonColors = CustomColors.getCustomColors((String)(mcpColormap + "melonstem.png"), (int)8, (int)1);
        String[] myceliumPaths = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
        myceliumParticleColors = CustomColors.getCustomColors((String)mcpColormap, (String[])myceliumPaths, (int)-1, (int)-1);
        Pair lightMaps = CustomColors.parseLightMapPacks();
        lightMapPacks = (LightMapPack[])lightMaps.getLeft();
        lightmapMinDimensionId = (Integer)lightMaps.getRight();
        CustomColors.readColorProperties((String)"optifine/color.properties");
        blockColormaps = CustomColors.readBlockColormaps((String[])new String[]{mcpColormap + "custom/", mcpColormap + "blocks/"}, (CustomColormap[])colorsBlockColormaps, (int)256, (int)256);
        CustomColors.updateUseDefaultGrassFoliageColors();
    }

    private static String getValidProperty(String fileName, String key, String[] validValues, String valDef) {
        try {
            ww loc = new ww(fileName);
            InputStream in = Config.getResourceStream((ww)loc);
            if (in == null) {
                return valDef;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            String val = props.getProperty(key);
            if (val == null) {
                return valDef;
            }
            List<String> listValidValues = Arrays.asList(validValues);
            if (!listValidValues.contains(val)) {
                CustomColors.warn((String)("Invalid value: " + key + "=" + val));
                CustomColors.warn((String)("Expected values: " + Config.arrayToString((Object[])validValues)));
                return valDef;
            }
            CustomColors.dbg((String)("" + key + "=" + val));
            return val;
        }
        catch (FileNotFoundException e2) {
            return valDef;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return valDef;
        }
    }

    private static Pair<LightMapPack[], Integer> parseLightMapPacks() {
        String lightmapPrefix = "optifine/lightmap/world";
        String lightmapSuffix = ".png";
        String[] pathsLightmap = ResUtils.collectFiles((String)lightmapPrefix, (String)lightmapSuffix);
        HashMap<Integer, String> mapLightmaps = new HashMap<Integer, String>();
        for (int i = 0; i < pathsLightmap.length; ++i) {
            String path = pathsLightmap[i];
            String dimIdStr = StrUtils.removePrefixSuffix((String)path, (String)lightmapPrefix, (String)lightmapSuffix);
            int dimId = Config.parseInt((String)dimIdStr, (int)Integer.MIN_VALUE);
            if (dimId == Integer.MIN_VALUE) {
                CustomColors.warn((String)("Invalid dimension ID: " + dimIdStr + ", path: " + path));
                continue;
            }
            mapLightmaps.put(dimId, path);
        }
        Set setDimIds = mapLightmaps.keySet();
        Object[] dimIds = setDimIds.toArray(new Integer[setDimIds.size()]);
        Arrays.sort(dimIds);
        if (dimIds.length <= 0) {
            return new ImmutablePair(null, (Object)0);
        }
        int minDimId = (Integer)dimIds[0];
        int maxDimId = (Integer)dimIds[dimIds.length - 1];
        int countDim = maxDimId - minDimId + 1;
        CustomColormap[] colormaps = new CustomColormap[countDim];
        for (int i = 0; i < dimIds.length; ++i) {
            Object dimId = dimIds[i];
            String path = (String)mapLightmaps.get(dimId);
            CustomColormap colors = CustomColors.getCustomColors((String)path, (int)-1, (int)-1);
            if (colors == null) continue;
            if (colors.getWidth() < 16) {
                CustomColors.warn((String)("Invalid lightmap width: " + colors.getWidth() + ", path: " + path));
                continue;
            }
            int lightmapIndex = (Integer)dimId - minDimId;
            colormaps[lightmapIndex] = colors;
        }
        LightMapPack[] lmps = new LightMapPack[colormaps.length];
        for (int i = 0; i < colormaps.length; ++i) {
            LightMapPack lmp;
            CustomColormap cm = colormaps[i];
            if (cm == null) continue;
            String name = cm.name;
            String basePath = cm.basePath;
            CustomColormap cmRain = CustomColors.getCustomColors((String)(basePath + "/" + name + "_rain.png"), (int)-1, (int)-1);
            CustomColormap cmThunder = CustomColors.getCustomColors((String)(basePath + "/" + name + "_thunder.png"), (int)-1, (int)-1);
            LightMap lm = new LightMap(cm);
            LightMap lmRain = cmRain != null ? new LightMap(cmRain) : null;
            LightMap lmThunder = cmThunder != null ? new LightMap(cmThunder) : null;
            lmps[i] = lmp = new LightMapPack(lm, lmRain, lmThunder);
        }
        return new ImmutablePair((Object)lmps, (Object)minDimId);
    }

    private static int getTextureHeight(String path, int defHeight) {
        try {
            InputStream in = Config.getResourceStream((ww)new ww(path));
            if (in == null) {
                return defHeight;
            }
            BufferedImage bi = ImageIO.read(in);
            in.close();
            if (bi == null) {
                return defHeight;
            }
            return bi.getHeight();
        }
        catch (IOException e2) {
            return defHeight;
        }
    }

    private static void readColorProperties(String fileName) {
        try {
            float[][] dyeColors;
            ww loc = new ww(fileName);
            InputStream in = Config.getResourceStream((ww)loc);
            if (in == null) {
                return;
            }
            CustomColors.dbg((String)("Loading " + fileName));
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            particleWaterColor = CustomColors.readColor((Properties)props, (String[])new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColors.readColor((Properties)props, (String)"particle.portal");
            lilyPadColor = CustomColors.readColor((Properties)props, (String)"lilypad");
            expBarTextColor = CustomColors.readColor((Properties)props, (String)"text.xpbar");
            bossTextColor = CustomColors.readColor((Properties)props, (String)"text.boss");
            signTextColor = CustomColors.readColor((Properties)props, (String)"text.sign");
            fogColorNether = CustomColors.readColorVec3((Properties)props, (String)"fog.nether");
            fogColorEnd = CustomColors.readColorVec3((Properties)props, (String)"fog.end");
            skyColorEnd = CustomColors.readColorVec3((Properties)props, (String)"sky.end");
            colorsBlockColormaps = CustomColors.readCustomColormaps((Properties)props, (String)fileName);
            spawnEggPrimaryColors = CustomColors.readSpawnEggColors((Properties)props, (String)fileName, (String)"egg.shell.", (String)"Spawn egg shell");
            spawnEggSecondaryColors = CustomColors.readSpawnEggColors((Properties)props, (String)fileName, (String)"egg.spots.", (String)"Spawn egg spot");
            wolfCollarColors = CustomColors.readDyeColors((Properties)props, (String)fileName, (String)"collar.", (String)"Wolf collar");
            sheepColors = CustomColors.readDyeColors((Properties)props, (String)fileName, (String)"sheep.", (String)"Sheep");
            textColors = CustomColors.readTextColors((Properties)props, (String)fileName, (String)"text.code.", (String)"Text");
            int[] mapColors = CustomColors.readMapColors((Properties)props, (String)fileName, (String)"map.", (String)"Map");
            if (mapColors != null) {
                if (mapColorsOriginal == null) {
                    mapColorsOriginal = CustomColors.getMapColors();
                }
                CustomColors.setMapColors((int[])mapColors);
            }
            if ((dyeColors = CustomColors.readDyeColors((Properties)props, (String)fileName, (String)"dye.", (String)"Dye")) != null) {
                if (dyeColorsOriginal == null) {
                    dyeColorsOriginal = CustomColors.getDyeColors();
                }
                CustomColors.setDyeColors((float[][])dyeColors);
            }
            potionColors = CustomColors.readPotionColors((Properties)props, (String)fileName, (String)"potion.", (String)"Potion");
            xpOrbTime = Config.parseInt((String)props.getProperty("xporb.time"), (int)-1);
        }
        catch (FileNotFoundException e2) {
            return;
        }
        catch (IOException e3) {
            Config.warn((String)("Error parsing: " + fileName));
            Config.warn((String)(e3.getClass().getName() + ": " + e3.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static CustomColormap[] readCustomColormaps(Properties props, String fileName) {
        void var7_9;
        ArrayList<CustomColormap> list = new ArrayList<CustomColormap>();
        String palettePrefix = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(palettePrefix)) continue;
            map.put(string, value);
        }
        String[] propNames = map.keySet().toArray(new String[map.size()]);
        boolean bl = false;
        while (var7_9 < propNames.length) {
            String name = propNames[var7_9];
            String value = props.getProperty(name);
            CustomColors.dbg((String)("Block palette: " + name + " = " + value));
            String path = name.substring(palettePrefix.length());
            String basePath = TextureUtils.getBasePath((String)fileName);
            path = TextureUtils.fixResourcePath((String)path, (String)basePath);
            CustomColormap colors = CustomColors.getCustomColors((String)path, (int)256, (int)256);
            if (colors == null) {
                CustomColors.warn((String)("Colormap not found: " + path));
            } else {
                ConnectedParser cp = new ConnectedParser("CustomColors");
                MatchBlock[] mbs = cp.parseMatchBlocks(value);
                if (mbs == null || mbs.length <= 0) {
                    CustomColors.warn((String)("Invalid match blocks: " + value));
                } else {
                    for (int m = 0; m < mbs.length; ++m) {
                        MatchBlock mb = mbs[m];
                        colors.addMatchBlock(mb);
                    }
                    list.add(colors);
                }
            }
            ++var7_9;
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomColormap[] customColormapArray = list.toArray(new CustomColormap[list.size()]);
        return customColormapArray;
    }

    private static CustomColormap[][] readBlockColormaps(String[] basePaths, CustomColormap[] basePalettes, int width, int height) {
        int i;
        Object[] paths = ResUtils.collectFiles((String[])basePaths, (String[])new String[]{".properties"});
        Arrays.sort(paths);
        ArrayList blockList = new ArrayList();
        for (i = 0; i < paths.length; ++i) {
            Object path = paths[i];
            CustomColors.dbg((String)("Block colormap: " + (String)path));
            try {
                ww locFile = new ww("minecraft", (String)path);
                InputStream in = Config.getResourceStream((ww)locFile);
                if (in == null) {
                    CustomColors.warn((String)("File not found: " + (String)path));
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                in.close();
                CustomColormap cm = new CustomColormap((Properties)props, (String)path, width, height, paletteFormatDefault);
                if (!cm.isValid((String)path) || !cm.isValidMatchBlocks((String)path)) continue;
                CustomColors.addToBlockList((CustomColormap)cm, blockList);
                continue;
            }
            catch (FileNotFoundException e2) {
                CustomColors.warn((String)("File not found: " + (String)path));
                continue;
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        if (basePalettes != null) {
            for (i = 0; i < basePalettes.length; ++i) {
                CustomColormap cm = basePalettes[i];
                CustomColors.addToBlockList((CustomColormap)cm, blockList);
            }
        }
        if (blockList.size() <= 0) {
            return null;
        }
        CustomColormap[][] cmArr = CustomColors.blockListToArray(blockList);
        return cmArr;
    }

    private static void addToBlockList(CustomColormap cm, List blockList) {
        int[] ids = cm.getMatchBlockIds();
        if (ids == null || ids.length <= 0) {
            CustomColors.warn((String)("No match blocks: " + Config.arrayToString((int[])ids)));
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            int blockId = ids[i];
            if (blockId < 0) {
                CustomColors.warn((String)("Invalid block ID: " + blockId));
                continue;
            }
            CustomColors.addToList((CustomColormap)cm, (List)blockList, (int)blockId);
        }
    }

    private static void addToList(CustomColormap cm, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomColormap> subList = (ArrayList<CustomColormap>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomColormap>();
            list.set(id, subList);
        }
        subList.add(cm);
    }

    private static CustomColormap[][] blockListToArray(List list) {
        CustomColormap[][] colArr = new CustomColormap[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            CustomColormap[] subArr = subList.toArray(new CustomColormap[subList.size()]);
            colArr[i] = subArr;
        }
        return colArr;
    }

    private static int readColor(Properties props, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int col = CustomColors.readColor((Properties)props, (String)name);
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String str = props.getProperty(name);
        if (str == null) {
            return -1;
        }
        int color = CustomColors.parseColor((String)(str = str.trim()));
        if (color < 0) {
            CustomColors.warn((String)("Invalid color: " + name + " = " + str));
            return color;
        }
        CustomColors.dbg((String)(name + " = " + str));
        return color;
    }

    private static int parseColor(String str) {
        if (str == null) {
            return -1;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e2) {
            return -1;
        }
    }

    private static dna readColorVec3(Properties props, String name) {
        int col = CustomColors.readColor((Properties)props, (String)name);
        if (col < 0) {
            return null;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return new dna((double)redF, (double)greenF, (double)blueF);
    }

    private static CustomColormap getCustomColors(String basePath, String[] paths, int width, int height) {
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            path = basePath + path;
            CustomColormap cols = CustomColors.getCustomColors((String)path, (int)width, (int)height);
            if (cols == null) continue;
            return cols;
        }
        return null;
    }

    public static CustomColormap getCustomColors(String pathImage, int width, int height) {
        try {
            ww loc = new ww(pathImage);
            if (!Config.hasResource((ww)loc)) {
                return null;
            }
            CustomColors.dbg((String)("Colormap " + pathImage));
            PropertiesOrdered props = new PropertiesOrdered();
            String pathProps = StrUtils.replaceSuffix((String)pathImage, (String)".png", (String)".properties");
            ww locProps = new ww(pathProps);
            if (Config.hasResource((ww)locProps)) {
                InputStream in = Config.getResourceStream((ww)locProps);
                props.load(in);
                in.close();
                CustomColors.dbg((String)("Colormap properties: " + pathProps));
            } else {
                props.put("format", paletteFormatDefault);
                props.put("source", pathImage);
                pathProps = pathImage;
            }
            CustomColormap cm = new CustomColormap((Properties)props, pathProps, width, height, paletteFormatDefault);
            if (!cm.isValid(pathProps)) {
                return null;
            }
            return cm;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static void updateUseDefaultGrassFoliageColors() {
        useDefaultGrassFoliageColors = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && Config.isSwampColors();
    }

    public static int getColorMultiplier(eoc quad, ckt blockState, bvs blockAccess, gg blockPos, RenderEnv renderEnv) {
        IColorizer colorizer;
        bzp block = blockState.b();
        ckt blockStateColormap = blockState;
        if (blockColormaps != null) {
            CustomColormap cm;
            if (!quad.c()) {
                if (block == bzq.i) {
                    blockStateColormap = BLOCK_STATE_DIRT;
                }
                if (block == bzq.bY) {
                    return -1;
                }
            }
            if (block instanceof cbn && blockState.c((clw)cbn.a) == clp.a) {
                blockPos = blockPos.c();
                blockStateColormap = blockAccess.a_(blockPos);
            }
            if ((cm = CustomColors.getBlockColormap((ckt)blockStateColormap)) != null) {
                if (Config.isSmoothBiomes() && !cm.isColorConstant()) {
                    return CustomColors.getSmoothColorMultiplier((ckt)blockState, (bvs)blockAccess, (gg)blockPos, (IColorizer)cm, (BlockPosM)renderEnv.getColorizerBlockPosM());
                }
                return cm.getColor(blockAccess, blockPos);
            }
        }
        if (!quad.c()) {
            return -1;
        }
        if (block == bzq.ed) {
            return CustomColors.getLilypadColorMultiplier((bvs)blockAccess, (gg)blockPos);
        }
        if (block == bzq.bY) {
            return CustomColors.getRedstoneColor((ckt)renderEnv.getBlockState());
        }
        if (block instanceof cgo) {
            return CustomColors.getStemColorMultiplier((ckt)blockState, (bvu)blockAccess, (gg)blockPos, (RenderEnv)renderEnv);
        }
        if (useDefaultGrassFoliageColors) {
            return -1;
        }
        if (block == bzq.i || block == bzq.hm || block instanceof cbn) {
            colorizer = COLORIZER_GRASS;
        } else if (block instanceof cbn) {
            colorizer = COLORIZER_GRASS;
            if (blockState.c((clw)cbn.a) == clp.a) {
                blockPos = blockPos.c();
            }
        } else if (block instanceof cdn) {
            colorizer = block == bzq.ak ? COLORIZER_FOLIAGE : (block == bzq.al ? COLORIZER_FOLIAGE_PINE : (block == bzq.am ? COLORIZER_FOLIAGE_BIRCH : COLORIZER_FOLIAGE));
        } else if (block == bzq.dX) {
            colorizer = COLORIZER_FOLIAGE;
        } else {
            return -1;
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier((ckt)blockState, (bvs)blockAccess, (gg)blockPos, (IColorizer)colorizer, (BlockPosM)renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockStateColormap, blockAccess, blockPos);
    }

    protected static bxp getColorBiome(bvs blockAccess, gg blockPos) {
        bxp biome = BiomeUtils.getBiome((bvs)blockAccess, (gg)blockPos);
        if (!(biome != BiomeUtils.SWAMP && biome != BiomeUtils.SWAMP_HILLS || Config.isSwampColors())) {
            biome = BiomeUtils.PLAINS;
        }
        return biome;
    }

    private static CustomColormap getBlockColormap(ckt blockState) {
        if (blockColormaps == null) {
            return null;
        }
        if (!(blockState instanceof ckt)) {
            return null;
        }
        ckt bs = blockState;
        int blockId = bs.getBlockId();
        if (blockId < 0 || blockId >= blockColormaps.length) {
            return null;
        }
        CustomColormap[] cms = blockColormaps[blockId];
        if (cms == null) {
            return null;
        }
        for (int i = 0; i < cms.length; ++i) {
            CustomColormap cm = cms[i];
            if (!cm.matchesBlock(bs)) continue;
            return cm;
        }
        return null;
    }

    private static int getSmoothColorMultiplier(ckt blockState, bvs blockAccess, gg blockPos, IColorizer colorizer, BlockPosM blockPosM) {
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int x = blockPos.u();
        int y = blockPos.v();
        int z = blockPos.w();
        BlockPosM posM = blockPosM;
        int radius = Config.getBiomeBlendRadius();
        int width = radius * 2 + 1;
        int count = width * width;
        for (int ix = x - radius; ix <= x + radius; ++ix) {
            for (int iz = z - radius; iz <= z + radius; ++iz) {
                posM.setXyz(ix, y, iz);
                int col = colorizer.getColor(blockState, blockAccess, (gg)posM);
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
            }
        }
        int r = sumRed / count;
        int g = sumGreen / count;
        int b2 = sumBlue / count;
        return r << 16 | g << 8 | b2;
    }

    public static int getFluidColor(bvs blockAccess, ckt blockState, gg blockPos, RenderEnv renderEnv) {
        bzp block = blockState.b();
        CustomColormap colorizer = CustomColors.getBlockColormap((ckt)blockState);
        if (colorizer == null && blockState.c() == dew.j) {
            colorizer = COLORIZER_WATER;
        }
        if (colorizer == null) {
            return CustomColors.getBlockColors().a(blockState, blockAccess, blockPos, 0);
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier((ckt)blockState, (bvs)blockAccess, (gg)blockPos, (IColorizer)colorizer, (BlockPosM)renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockState, blockAccess, blockPos);
    }

    public static dwf getBlockColors() {
        return dvp.C().al();
    }

    public static void updatePortalFX(eld fx) {
        if (particlePortalColor < 0) {
            return;
        }
        int col = particlePortalColor;
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    public static void updateMyceliumFX(eld fx) {
        if (myceliumParticleColors == null) {
            return;
        }
        int col = myceliumParticleColors.getColorRandom();
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    private static int getRedstoneColor(ckt blockState) {
        if (redstoneColors == null) {
            return -1;
        }
        int level = CustomColors.getRedstoneLevel((ckt)blockState, (int)15);
        int col = redstoneColors.getColor(level);
        return col;
    }

    public static void updateReddustFX(eld fx, bvs blockAccess, double x, double y, double z) {
        if (redstoneColors == null) {
            return;
        }
        ckt state = blockAccess.a_(new gg(x, y, z));
        int level = CustomColors.getRedstoneLevel((ckt)state, (int)15);
        int col = redstoneColors.getColor(level);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    private static int getRedstoneLevel(ckt state, int def) {
        bzp block = state.b();
        if (!(block instanceof cfa)) {
            return def;
        }
        Comparable val = state.c((clw)cfa.e);
        if (!(val instanceof Integer)) {
            return def;
        }
        Integer valInt = (Integer)val;
        return valInt;
    }

    public static float getXpOrbTimer(float timer) {
        if (xpOrbTime <= 0) {
            return timer;
        }
        float kt = 628.0f / (float)xpOrbTime;
        return timer * kt;
    }

    public static int getXpOrbColor(float timer) {
        if (xpOrbColors == null) {
            return -1;
        }
        int index = (int)Math.round((double)((ahb.a((float)timer) + 1.0f) * (float)(xpOrbColors.getLength() - 1)) / 2.0);
        int col = xpOrbColors.getColor(index);
        return col;
    }

    public static int getDurabilityColor(float dur, int color) {
        if (durabilityColors == null) {
            return color;
        }
        int index = (int)(dur * (float)durabilityColors.getLength());
        int col = durabilityColors.getColor(index);
        return col;
    }

    public static void updateWaterFX(eld fx, bvs blockAccess, double x, double y, double z, RenderEnv renderEnv) {
        if (waterColors == null && blockColormaps == null && particleWaterColor < 0) {
            return;
        }
        gg blockPos = new gg(x, y, z);
        renderEnv.reset(BLOCK_STATE_WATER, blockPos);
        int col = CustomColors.getFluidColor((bvs)blockAccess, (ckt)BLOCK_STATE_WATER, (gg)blockPos, (RenderEnv)renderEnv);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        if (particleWaterColor >= 0) {
            int redDrop = particleWaterColor >> 16 & 0xFF;
            int greenDrop = particleWaterColor >> 8 & 0xFF;
            int blueDrop = particleWaterColor & 0xFF;
            redF = (float)redDrop / 255.0f;
            greenF = (float)greenDrop / 255.0f;
            blueF = (float)blueDrop / 255.0f;
            redF *= (float)redDrop / 255.0f;
            greenF *= (float)greenDrop / 255.0f;
            blueF *= (float)blueDrop / 255.0f;
        }
        fx.a(redF, greenF, blueF);
    }

    private static int getLilypadColorMultiplier(bvs blockAccess, gg blockPos) {
        if (lilyPadColor < 0) {
            return CustomColors.getBlockColors().a(bzq.ed.n(), blockAccess, blockPos, 0);
        }
        return lilyPadColor;
    }

    private static dna getFogColorNether(dna col) {
        if (fogColorNether == null) {
            return col;
        }
        return fogColorNether;
    }

    private static dna getFogColorEnd(dna col) {
        if (fogColorEnd == null) {
            return col;
        }
        return fogColorEnd;
    }

    private static dna getSkyColorEnd(dna col) {
        if (skyColorEnd == null) {
            return col;
        }
        return skyColorEnd;
    }

    public static dna getSkyColor(dna skyColor3d, bvs blockAccess, double x, double y, double z) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int col = skyColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)skyColor3d.b / 0.5f;
        float cGreen = (float)skyColor3d.c / 0.66275f;
        float cBlue = (float)skyColor3d.d;
        dna newCol = skyColorFader.getColor((double)(redF *= cRed), (double)(greenF *= cGreen), (double)(blueF *= cBlue));
        return newCol;
    }

    private static dna getFogColor(dna fogColor3d, bvs blockAccess, double x, double y, double z) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int col = fogColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)fogColor3d.b / 0.753f;
        float cGreen = (float)fogColor3d.c / 0.8471f;
        float cBlue = (float)fogColor3d.d;
        dna newCol = fogColorFader.getColor((double)(redF *= cRed), (double)(greenF *= cGreen), (double)(blueF *= cBlue));
        return newCol;
    }

    public static dna getUnderwaterColor(bvs blockAccess, double x, double y, double z) {
        return CustomColors.getUnderFluidColor((bvs)blockAccess, (double)x, (double)y, (double)z, (CustomColormap)underwaterColors, (CustomColorFader)underwaterColorFader);
    }

    public static dna getUnderlavaColor(bvs blockAccess, double x, double y, double z) {
        return CustomColors.getUnderFluidColor((bvs)blockAccess, (double)x, (double)y, (double)z, (CustomColormap)underlavaColors, (CustomColorFader)underlavaColorFader);
    }

    public static dna getUnderFluidColor(bvs blockAccess, double x, double y, double z, CustomColormap underFluidColors, CustomColorFader underFluidColorFader) {
        if (underFluidColors == null) {
            return null;
        }
        int col = underFluidColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        dna newCol = underFluidColorFader.getColor((double)redF, (double)greenF, (double)blueF);
        return newCol;
    }

    private static int getStemColorMultiplier(ckt blockState, bvu blockAccess, gg blockPos, RenderEnv renderEnv) {
        CustomColormap colors = stemColors;
        bzp blockStem = blockState.b();
        if (blockStem == bzq.dV && stemPumpkinColors != null) {
            colors = stemPumpkinColors;
        }
        if (blockStem == bzq.dW && stemMelonColors != null) {
            colors = stemMelonColors;
        }
        if (colors == null) {
            return -1;
        }
        if (!(blockStem instanceof cgo)) {
            return -1;
        }
        int level = (Integer)blockState.c((clw)cgo.b);
        return colors.getColor(level);
    }

    public static boolean updateLightmap(eji world, float torchFlickerX, dpm lmColors, boolean nightvision, float partialTicks) {
        if (world == null) {
            return false;
        }
        if (lightMapPacks == null) {
            return false;
        }
        int dimensionId = WorldUtils.getDimensionId((bwq)world);
        int lightMapIndex = dimensionId - lightmapMinDimensionId;
        if (lightMapIndex < 0 || lightMapIndex >= lightMapPacks.length) {
            return false;
        }
        LightMapPack lightMapPack = lightMapPacks[lightMapIndex];
        if (lightMapPack == null) {
            return false;
        }
        return lightMapPack.updateLightmap(world, torchFlickerX, lmColors, nightvision, partialTicks);
    }

    public static dna getWorldFogColor(dna fogVec, bwq world, atg renderViewEntity, float partialTicks) {
        dvp mc = dvp.C();
        if (WorldUtils.isNether((bwq)world)) {
            return CustomColors.getFogColorNether((dna)fogVec);
        }
        if (WorldUtils.isOverworld((bwq)world)) {
            return CustomColors.getFogColor((dna)fogVec, (bvs)mc.r, (double)renderViewEntity.cX(), (double)(renderViewEntity.cZ() + 1.0), (double)renderViewEntity.dd());
        }
        if (WorldUtils.isEnd((bwq)world)) {
            return CustomColors.getFogColorEnd((dna)fogVec);
        }
        return fogVec;
    }

    public static dna getWorldSkyColor(dna skyVec, bwq world, atg renderViewEntity, float partialTicks) {
        dvp mc = dvp.C();
        if (WorldUtils.isOverworld((bwq)world) && renderViewEntity != null) {
            return CustomColors.getSkyColor((dna)skyVec, (bvs)mc.r, (double)renderViewEntity.cX(), (double)(renderViewEntity.cZ() + 1.0), (double)renderViewEntity.dd());
        }
        if (WorldUtils.isEnd((bwq)world)) {
            return CustomColors.getSkyColorEnd((dna)skyVec);
        }
        return skyVec;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] readSpawnEggColors(Properties props, String fileName, String prefix, String logName) {
        void var8_10;
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set<Object> keys = props.keySet();
        int countColors = 0;
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            int id = EntityUtils.getEntityIdByName((String)name);
            try {
                if (id < 0) {
                    id = EntityUtils.getEntityIdByLocation((String)new ww(name).toString());
                }
            }
            catch (aa e2) {
                Config.warn((String)("ResourceLocationException: " + e2.getMessage()));
            }
            if (id < 0) {
                CustomColors.warn((String)("Invalid spawn egg name: " + string));
                continue;
            }
            int color = CustomColors.parseColor((String)value);
            if (color < 0) {
                CustomColors.warn((String)("Invalid spawn egg color: " + string + " = " + value));
                continue;
            }
            while (list.size() <= id) {
                list.add(-1);
            }
            list.set(id, color);
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        int[] colors = new int[list.size()];
        boolean bl = false;
        while (var8_10 < colors.length) {
            colors[var8_10] = (Integer)list.get((int)var8_10);
            ++var8_10;
        }
        return colors;
    }

    private static int getSpawnEggColor(brr item, bqq itemStack, int layer, int color) {
        int[] eggColors;
        if (spawnEggPrimaryColors == null && spawnEggSecondaryColors == null) {
            return color;
        }
        atk entityType = item.a(itemStack.s());
        if (entityType == null) {
            return color;
        }
        int id = gw.Y.a((Object)entityType);
        if (id < 0) {
            return color;
        }
        int[] nArray = eggColors = layer == 0 ? spawnEggPrimaryColors : spawnEggSecondaryColors;
        if (eggColors == null) {
            return color;
        }
        if (id < 0 || id >= eggColors.length) {
            return color;
        }
        int eggColor = eggColors[id];
        if (eggColor < 0) {
            return color;
        }
        return eggColor;
    }

    public static int getColorFromItemStack(bqq itemStack, int layer, int color) {
        if (itemStack == null) {
            return color;
        }
        bqm item = itemStack.c();
        if (item == null) {
            return color;
        }
        if (item instanceof brr) {
            return CustomColors.getSpawnEggColor((brr)((brr)item), (bqq)itemStack, (int)layer, (int)color);
        }
        return color;
    }

    private static float[][] readDyeColors(Properties props, String fileName, String prefix, String logName) {
        bpm[] dyeValues = bpm.values();
        HashMap<String, bpm> mapDyes = new HashMap<String, bpm>();
        for (int i = 0; i < dyeValues.length; ++i) {
            bpm dye = dyeValues[i];
            mapDyes.put(dye.c(), dye);
        }
        mapDyes.put("lightBlue", bpm.d);
        mapDyes.put("silver", bpm.i);
        float[][] colors = new float[dyeValues.length][];
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            bpm dye = (bpm)mapDyes.get(name);
            int color = CustomColors.parseColor((String)value);
            if (dye == null || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            colors[dye.ordinal()] = rgb;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    private static float[] getDyeColors(bpm dye, float[][] dyeColors, float[] colors) {
        if (dyeColors == null) {
            return colors;
        }
        if (dye == null) {
            return colors;
        }
        float[] customColors = dyeColors[dye.ordinal()];
        if (customColors == null) {
            return colors;
        }
        return customColors;
    }

    public static float[] getWolfCollarColors(bpm dye, float[] colors) {
        return CustomColors.getDyeColors((bpm)dye, (float[][])wolfCollarColors, (float[])colors);
    }

    public static float[] getSheepColors(bpm dye, float[] colors) {
        return CustomColors.getDyeColors((bpm)dye, (float[][])sheepColors, (float[])colors);
    }

    private static int[] readTextColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[32];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            int code = Config.parseInt((String)name, (int)-1);
            int color = CustomColors.parseColor((String)value);
            if (code < 0 || code >= colors.length || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            colors[code] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    public static int getTextColor(int index, int color) {
        if (textColors == null) {
            return color;
        }
        if (index < 0 || index >= textColors.length) {
            return color;
        }
        int customColor = textColors[index];
        if (customColor < 0) {
            return color;
        }
        return customColor;
    }

    private static int[] readMapColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[dex.a.length];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            int index = CustomColors.getMapColorIndex((String)name);
            int color = CustomColors.parseColor((String)value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    private static int[] readPotionColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[CustomColors.getMaxPotionId()];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = string;
            int index = CustomColors.getPotionId((String)name);
            int color = CustomColors.parseColor((String)value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    private static int getMaxPotionId() {
        int maxId = 0;
        Set keys = gw.V.c();
        for (ww rl : keys) {
            asy potion = PotionUtils.getPotion((ww)rl);
            int id = asy.a((asy)potion);
            if (id <= maxId) continue;
            maxId = id;
        }
        return maxId;
    }

    private static int getPotionId(String name) {
        if (name.equals("potion.water")) {
            return 0;
        }
        name = StrUtils.replacePrefix((String)name, (String)"potion.", (String)"effect.");
        String nameMc = StrUtils.replacePrefix((String)name, (String)"effect.", (String)"effect.minecraft.");
        Set keys = gw.V.c();
        for (ww rl : keys) {
            asy potion = PotionUtils.getPotion((ww)rl);
            if (potion.c().equals(name)) {
                return asy.a((asy)potion);
            }
            if (!potion.c().equals(nameMc)) continue;
            return asy.a((asy)potion);
        }
        return -1;
    }

    public static int getPotionColor(asy potion, int color) {
        int potionId = 0;
        if (potion != null) {
            potionId = asy.a((asy)potion);
        }
        return CustomColors.getPotionColor((int)potionId, (int)color);
    }

    public static int getPotionColor(int potionId, int color) {
        if (potionColors == null) {
            return color;
        }
        if (potionId < 0 || potionId >= potionColors.length) {
            return color;
        }
        int potionColor = potionColors[potionId];
        if (potionColor < 0) {
            return color;
        }
        return potionColor;
    }

    private static int getMapColorIndex(String name) {
        if (name == null) {
            return -1;
        }
        if (name.equals("air")) {
            return dex.b.am;
        }
        if (name.equals("grass")) {
            return dex.c.am;
        }
        if (name.equals("sand")) {
            return dex.d.am;
        }
        if (name.equals("cloth")) {
            return dex.e.am;
        }
        if (name.equals("tnt")) {
            return dex.f.am;
        }
        if (name.equals("ice")) {
            return dex.g.am;
        }
        if (name.equals("iron")) {
            return dex.h.am;
        }
        if (name.equals("foliage")) {
            return dex.i.am;
        }
        if (name.equals("clay")) {
            return dex.k.am;
        }
        if (name.equals("dirt")) {
            return dex.l.am;
        }
        if (name.equals("stone")) {
            return dex.m.am;
        }
        if (name.equals("water")) {
            return dex.n.am;
        }
        if (name.equals("wood")) {
            return dex.o.am;
        }
        if (name.equals("quartz")) {
            return dex.p.am;
        }
        if (name.equals("gold")) {
            return dex.F.am;
        }
        if (name.equals("diamond")) {
            return dex.G.am;
        }
        if (name.equals("lapis")) {
            return dex.H.am;
        }
        if (name.equals("emerald")) {
            return dex.I.am;
        }
        if (name.equals("obsidian")) {
            return dex.J.am;
        }
        if (name.equals("netherrack")) {
            return dex.K.am;
        }
        if (name.equals("snow") || name.equals("white")) {
            return dex.j.am;
        }
        if (name.equals("adobe") || name.equals("orange")) {
            return dex.q.am;
        }
        if (name.equals("magenta")) {
            return dex.r.am;
        }
        if (name.equals("light_blue") || name.equals("lightBlue")) {
            return dex.s.am;
        }
        if (name.equals("yellow")) {
            return dex.t.am;
        }
        if (name.equals("lime")) {
            return dex.u.am;
        }
        if (name.equals("pink")) {
            return dex.v.am;
        }
        if (name.equals("gray")) {
            return dex.w.am;
        }
        if (name.equals("silver") || name.equals("light_gray")) {
            return dex.x.am;
        }
        if (name.equals("cyan")) {
            return dex.y.am;
        }
        if (name.equals("purple")) {
            return dex.z.am;
        }
        if (name.equals("blue")) {
            return dex.A.am;
        }
        if (name.equals("brown")) {
            return dex.B.am;
        }
        if (name.equals("green")) {
            return dex.C.am;
        }
        if (name.equals("red")) {
            return dex.D.am;
        }
        if (name.equals("black")) {
            return dex.E.am;
        }
        if (name.equals("white_terracotta")) {
            return dex.L.am;
        }
        if (name.equals("orange_terracotta")) {
            return dex.M.am;
        }
        if (name.equals("magenta_terracotta")) {
            return dex.N.am;
        }
        if (name.equals("light_blue_terracotta")) {
            return dex.O.am;
        }
        if (name.equals("yellow_terracotta")) {
            return dex.P.am;
        }
        if (name.equals("lime_terracotta")) {
            return dex.Q.am;
        }
        if (name.equals("pink_terracotta")) {
            return dex.R.am;
        }
        if (name.equals("gray_terracotta")) {
            return dex.S.am;
        }
        if (name.equals("light_gray_terracotta")) {
            return dex.T.am;
        }
        if (name.equals("cyan_terracotta")) {
            return dex.U.am;
        }
        if (name.equals("purple_terracotta")) {
            return dex.V.am;
        }
        if (name.equals("blue_terracotta")) {
            return dex.W.am;
        }
        if (name.equals("brown_terracotta")) {
            return dex.X.am;
        }
        if (name.equals("green_terracotta")) {
            return dex.Y.am;
        }
        if (name.equals("red_terracotta")) {
            return dex.Z.am;
        }
        if (name.equals("black_terracotta")) {
            return dex.aa.am;
        }
        if (name.equals("crimson_nylium")) {
            return dex.ab.am;
        }
        if (name.equals("crimson_stem")) {
            return dex.ac.am;
        }
        if (name.equals("crimson_hyphae")) {
            return dex.ad.am;
        }
        if (name.equals("warped_nylium")) {
            return dex.ae.am;
        }
        if (name.equals("warped_stem")) {
            return dex.af.am;
        }
        if (name.equals("warped_hyphae")) {
            return dex.ag.am;
        }
        if (name.equals("warped_wart_block")) {
            return dex.ah.am;
        }
        return -1;
    }

    private static int[] getMapColors() {
        dex[] mapColors = dex.a;
        int[] colors = new int[mapColors.length];
        Arrays.fill(colors, -1);
        for (int i = 0; i < mapColors.length && i < colors.length; ++i) {
            dex mapColor = mapColors[i];
            if (mapColor == null) continue;
            colors[i] = mapColor.al;
        }
        return colors;
    }

    private static void setMapColors(int[] colors) {
        if (colors == null) {
            return;
        }
        dex[] mapColors = dex.a;
        for (int i = 0; i < mapColors.length && i < colors.length; ++i) {
            int color;
            dex mapColor = mapColors[i];
            if (mapColor == null || (color = colors[i]) < 0 || mapColor.al == color) continue;
            mapColor.al = color;
        }
    }

    private static float[][] getDyeColors() {
        bpm[] dyeColors = bpm.values();
        float[][] colors = new float[dyeColors.length][];
        for (int i = 0; i < dyeColors.length && i < colors.length; ++i) {
            bpm dyeColor = dyeColors[i];
            if (dyeColor == null) continue;
            colors[i] = dyeColor.d();
        }
        return colors;
    }

    private static void setDyeColors(float[][] colors) {
        if (colors == null) {
            return;
        }
        bpm[] dyeColors = bpm.values();
        for (int i = 0; i < dyeColors.length && i < colors.length; ++i) {
            float[] color;
            bpm dyeColor = dyeColors[i];
            if (dyeColor == null || (color = colors[i]) == null || dyeColor.d().equals(color)) continue;
            dyeColor.setColorComponentValues(color);
        }
    }

    private static void dbg(String str) {
        Config.dbg((String)("CustomColors: " + str));
    }

    private static void warn(String str) {
        Config.warn((String)("CustomColors: " + str));
    }

    public static int getExpBarTextColor(int color) {
        if (expBarTextColor < 0) {
            return color;
        }
        return expBarTextColor;
    }

    public static int getBossTextColor(int color) {
        if (bossTextColor < 0) {
            return color;
        }
        return bossTextColor;
    }

    public static int getSignTextColor(int color) {
        if (color != 0) {
            return color;
        }
        if (signTextColor < 0) {
            return color;
        }
        return signTextColor;
    }

    static /* synthetic */ CustomColormap access$000() {
        return swampGrassColors;
    }

    static /* synthetic */ CustomColormap access$100() {
        return swampFoliageColors;
    }

    static /* synthetic */ CustomColormap access$200() {
        return foliagePineColors;
    }

    static /* synthetic */ CustomColormap access$300() {
        return foliageBirchColors;
    }

    static /* synthetic */ CustomColormap access$400() {
        return waterColors;
    }
}

