/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PasteNbtBehavior;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class TaskPasteSchematicPerChunkCommand
extends TaskPasteSchematicPerChunkBase {
    protected final PasteNbtBehavior nbtBehavior;
    protected final String setBlockCommand;
    protected final Consumer<class_2561> gameRuleListener;
    protected final boolean ignoreBlocks;
    protected final boolean ignoreEntities;
    protected TaskPhase phase = TaskPhase.INIT;
    @Nullable
    protected class_1923 currentChunk;
    @Nullable
    protected IntBoundingBox currentBox;
    @Nullable
    protected Iterator<class_1297> entityIterator;
    @Nullable
    protected Iterator<class_2338> positionIterator;
    protected int maxCommandsPerTick = Configs.Generic.PASTE_COMMAND_LIMIT.getIntegerValue();
    protected int processedChunksThisTick;
    protected int sentCommandsThisTick;
    protected int sentCommandsTotal;
    protected int sentSetblockCommands;
    protected long gameRuleProbeTimeout;
    protected long maxGameRuleProbeTime = 2000000000L;
    protected boolean shouldEnableFeedback;

    public TaskPasteSchematicPerChunkCommand(Collection<SchematicPlacement> placements, LayerRange range, boolean changedBlocksOnly) {
        super(placements, range, changedBlocksOnly);
        this.ignoreBlocks = false;
        this.ignoreEntities = Configs.Generic.PASTE_IGNORE_ENTITIES.getBooleanValue();
        this.setBlockCommand = Configs.Generic.PASTE_COMMAND_SETBLOCK.getStringValue();
        this.nbtBehavior = (PasteNbtBehavior)Configs.Generic.PASTE_NBT_BEHAVIOR.getOptionListValue();
        this.gameRuleListener = this::checkGameRuleState;
    }

    @Override
    public boolean execute() {
        if (this.ignoreBlocks && this.ignoreEntities) {
            return true;
        }
        if (this.phase == TaskPhase.INIT) {
            if (Configs.Generic.PASTE_DISABLE_FEEDBACK.getBooleanValue()) {
                DataManager.addChatListener(this.gameRuleListener);
                this.mc.field_1724.method_3142("/gamerule sendCommandFeedback");
                this.gameRuleProbeTimeout = class_156.method_648() + this.maxGameRuleProbeTime;
                this.phase = TaskPhase.GAMERULE_PROBE;
            } else {
                this.shouldEnableFeedback = false;
                this.phase = TaskPhase.WAIT_FOR_CHUNKS;
            }
        }
        if (this.phase == TaskPhase.GAMERULE_PROBE) {
            if (class_156.method_648() > this.gameRuleProbeTimeout) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (int)8000, (String)"litematica.message.error.schematic_paste_failed.game_rule_probe_timeout", (Object[])new Object[0]);
                this.finished = false;
                return true;
            }
            return false;
        }
        this.sentCommandsThisTick = 0;
        this.processedChunksThisTick = 0;
        if (this.currentChunk != null && !this.canProcessChunk(this.currentChunk, this.schematicWorld, this.mc.field_1687)) {
            return false;
        }
        int commandsLast = -1;
        class_1923 lastChunk = this.currentChunk;
        while (!(this.sentCommandsThisTick >= this.maxCommandsPerTick || this.sentCommandsThisTick <= commandsLast && Objects.equals(lastChunk, this.currentChunk))) {
            commandsLast = this.sentCommandsThisTick;
            lastChunk = this.currentChunk;
            if (this.phase == TaskPhase.WAIT_FOR_CHUNKS) {
                this.fetchNextChunk();
            }
            if (this.phase == TaskPhase.PROCESS_BOX_BLOCKS) {
                this.processBlocksInBox(this.currentChunk, this.currentBox);
            }
            if (this.phase == TaskPhase.PROCESS_BOX_ENTITIES) {
                this.processEntitiesInBox(this.currentBox);
            }
            if (this.phase != TaskPhase.FINISHED) continue;
            this.finished = true;
            return true;
        }
        if (this.processedChunksThisTick > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    public void checkGameRuleState(class_2561 message) {
        class_2588 translatableText;
        class_2561 class_25612 = message;
        if (class_25612 instanceof class_2588 && "commands.gamerule.query".equals((translatableText = (class_2588)class_25612).method_11022())) {
            this.shouldEnableFeedback = translatableText.getString().contains("true");
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
            if (this.shouldEnableFeedback) {
                this.mc.field_1724.method_3142("/gamerule sendCommandFeedback false");
            }
        }
    }

    protected void fetchNextChunk() {
        if (!this.pendingChunks.isEmpty()) {
            this.sortChunkList();
            class_1923 pos = (class_1923)this.pendingChunks.get(0);
            if (this.canProcessChunk(pos, this.schematicWorld, this.mc.field_1687)) {
                this.currentChunk = pos;
                this.startNextBox(pos);
            }
        } else {
            this.phase = TaskPhase.FINISHED;
            this.finished = true;
        }
    }

    protected void fetchNextBoxForChunk(class_1923 pos) {
        List list = this.boxesInChunks.get((Object)pos);
        if (!list.isEmpty()) {
            this.currentBox = (IntBoundingBox)list.get(0);
            if (!this.ignoreBlocks) {
                IntBoundingBox box = this.currentBox;
                this.positionIterator = class_2338.method_10094((int)box.minX, (int)box.minY, (int)box.minZ, (int)box.maxX, (int)box.maxY, (int)box.maxZ).iterator();
            }
        } else {
            this.currentBox = null;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        }
    }

    protected void startNextBox(class_1923 chunkPos) {
        List list = this.boxesInChunks.get((Object)chunkPos);
        if (!list.isEmpty()) {
            this.currentBox = (IntBoundingBox)list.get(0);
            if (!this.ignoreBlocks) {
                this.startSettingBlocks(this.currentBox);
            } else {
                this.startSummoningEntities(this.currentBox);
            }
        } else {
            this.currentBox = null;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        }
    }

    protected void startSettingBlocks(IntBoundingBox box) {
        this.positionIterator = class_2338.method_10094((int)box.minX, (int)box.minY, (int)box.minZ, (int)box.maxX, (int)box.maxY, (int)box.maxZ).iterator();
        this.phase = TaskPhase.PROCESS_BOX_BLOCKS;
    }

    protected void startSummoningEntities(IntBoundingBox box) {
        class_238 bb = new class_238((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
        this.entityIterator = this.schematicWorld.method_8333(null, bb, e -> true).iterator();
        this.phase = TaskPhase.PROCESS_BOX_ENTITIES;
    }

    protected void onFinishedProcessingBox(class_1923 chunkPos, IntBoundingBox box) {
        this.boxesInChunks.remove((Object)chunkPos, (Object)box);
        this.currentBox = null;
        this.entityIterator = null;
        this.positionIterator = null;
        if (this.boxesInChunks.get((Object)chunkPos).isEmpty()) {
            this.pendingChunks.remove(chunkPos);
            this.currentChunk = null;
            ++this.processedChunksThisTick;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
            this.fetchNextChunk();
        } else {
            this.startNextBox(chunkPos);
        }
    }

    protected void processBlocksInBox(class_1923 chunkPos, IntBoundingBox box) {
        ChunkSchematic schematicChunk = this.schematicWorld.getChunkProvider().getChunk(chunkPos.field_9181, chunkPos.field_9180);
        class_2818 clientChunk = this.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180);
        while (this.sentCommandsThisTick < this.maxCommandsPerTick && this.positionIterator.hasNext()) {
            class_2338 pos = this.positionIterator.next();
            this.pasteBlock(pos, schematicChunk, (class_2791)clientChunk);
        }
        if (!this.positionIterator.hasNext()) {
            if (this.ignoreEntities) {
                this.onFinishedProcessingBox(this.currentChunk, box);
            } else {
                this.startSummoningEntities(box);
            }
        }
    }

    protected void processEntitiesInBox(IntBoundingBox box) {
        while (this.sentCommandsThisTick < this.maxCommandsPerTick && this.entityIterator.hasNext()) {
            this.summonEntity(this.entityIterator.next());
        }
        if (!this.entityIterator.hasNext()) {
            this.onFinishedProcessingBox(this.currentChunk, box);
        }
    }

    protected void pasteBlock(class_2338 pos, class_2818 schematicChunk, class_2791 clientChunk) {
        class_2680 stateSchematic = schematicChunk.method_8320(pos);
        class_2680 stateClient = clientChunk.method_8320(pos);
        if (!(stateSchematic.method_26215() && stateClient.method_26215() || this.changedBlockOnly && stateClient == stateSchematic)) {
            if (this.replace == ReplaceBehavior.NONE && !stateClient.method_26215() || this.replace == ReplaceBehavior.WITH_NON_AIR && stateSchematic.method_26215()) {
                return;
            }
            class_746 player = this.mc.field_1724;
            PasteNbtBehavior nbtBehavior = this.nbtBehavior;
            class_2586 be = schematicChunk.method_8321(pos);
            if (be != null && nbtBehavior != PasteNbtBehavior.NONE) {
                class_1937 schematicWorld = schematicChunk.method_12200();
                class_638 clientWorld = this.mc.field_1687;
                if (nbtBehavior == PasteNbtBehavior.PLACE_MODIFY) {
                    this.setDataViaDataModify(pos, stateSchematic, be, schematicWorld, clientWorld, player);
                } else if (nbtBehavior == PasteNbtBehavior.PLACE_CLONE) {
                    this.placeBlockViaClone(pos, stateSchematic, be, schematicWorld, clientWorld, player);
                } else if (nbtBehavior == PasteNbtBehavior.TELEPORT_PLACE) {
                    this.placeBlockDirectly(pos, stateSchematic, be, schematicWorld, clientWorld, player);
                }
            } else {
                this.sendSetBlockCommand(pos.method_10263(), pos.method_10264(), pos.method_10260(), stateSchematic, player);
            }
        }
    }

    protected void summonEntity(class_1297 entity) {
        String id = EntityUtils.getEntityId(entity);
        if (id != null) {
            String command = String.format(Locale.ROOT, "summon %s %f %f %f", id, entity.method_23317(), entity.method_23318(), entity.method_23321());
            class_1297 class_12972 = entity;
            if (class_12972 instanceof class_1533) {
                class_1533 itemFrame = (class_1533)class_12972;
                command = this.getSummonCommandForItemFrame(itemFrame, command);
            }
            this.sendCommand(command, this.mc.field_1724);
        }
    }

    protected String getSummonCommandForItemFrame(class_1533 itemFrame, String originalCommand) {
        class_1799 stack = itemFrame.method_6940();
        if (!stack.method_7960()) {
            class_2960 itemId = class_2378.field_11142.method_10221((Object)stack.method_7909());
            int facingId = itemFrame.method_5735().method_10146();
            String nbtStr = String.format(" {Facing:%db,Item:{id:\"%s\",Count:1b}}", facingId, itemId);
            class_2487 tag = stack.method_7969();
            if (tag != null) {
                String itemNbt = tag.toString();
                String tmp = String.format(" {Facing:%db,Item:{id:\"%s\",Count:1b,tag:%s}}", facingId, itemId, itemNbt);
                if (originalCommand.length() + tmp.length() < 255) {
                    nbtStr = tmp;
                }
            }
            return originalCommand + nbtStr;
        }
        return originalCommand;
    }

    protected void sendSetBlockCommand(int x, int y, int z, class_2680 state, class_746 player) {
        String cmdName = this.setBlockCommand;
        String blockString = class_2259.method_9685((class_2680)state);
        String strCommand = String.format("%s %d %d %d %s", cmdName, x, y, z, blockString);
        this.sendCommand(strCommand, player);
        ++this.sentSetblockCommands;
    }

    protected void setDataViaDataModify(class_2338 pos, class_2680 state, class_2586 be, class_1937 schematicWorld, class_638 clientWorld, class_746 player) {
        class_2338 placementPos = TaskPasteSchematicPerChunkCommand.findEmptyNearbyPosition((class_1937)clientWorld, player.method_24515(), 3);
        if (placementPos != null && this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            class_243 posVec = new class_243((double)placementPos.method_10263() + 0.5, (double)placementPos.method_10264() + 1.0, (double)placementPos.method_10260() + 0.5);
            class_3965 hitResult = new class_3965(posVec, class_2350.field_11036, placementPos, false);
            this.mc.field_1761.method_2896(player, clientWorld, class_1268.field_5810, hitResult);
            this.sendSetBlockCommand(pos.method_10263(), pos.method_10264(), pos.method_10260(), state, player);
            try {
                HashSet keys = new HashSet(be.method_11007(new class_2487()).method_10541());
                keys.remove("id");
                keys.remove("x");
                keys.remove("y");
                keys.remove("z");
                for (String key : keys) {
                    String command = String.format("data modify block %d %d %d %s set from block %d %d %d %s", pos.method_10263(), pos.method_10264(), pos.method_10260(), key, placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260(), key);
                    this.sendCommand(command, player);
                }
            }
            catch (Exception keys) {
                // empty catch block
            }
            String cmdName = this.setBlockCommand;
            String command = String.format("%s %d %d %d air", cmdName, placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260());
            this.sendCommand(command, player);
        }
    }

    protected void placeBlockViaClone(class_2338 pos, class_2680 state, class_2586 be, class_1937 schematicWorld, class_638 clientWorld, class_746 player) {
        class_2338 placementPos = TaskPasteSchematicPerChunkCommand.findEmptyNearbyPosition((class_1937)clientWorld, player.method_24515(), 3);
        if (placementPos != null && this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            class_243 posVec = new class_243((double)placementPos.method_10263() + 0.5, (double)placementPos.method_10264() + 1.0, (double)placementPos.method_10260() + 0.5);
            class_3965 hitResult = new class_3965(posVec, class_2350.field_11036, placementPos, false);
            this.mc.field_1761.method_2896(player, clientWorld, class_1268.field_5810, hitResult);
            String command = String.format("clone %d %d %d %d %d %d %d %d %d", placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260(), placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260(), pos.method_10263(), pos.method_10264(), pos.method_10260());
            this.sendCommand(command, player);
            String cmdName = this.setBlockCommand;
            command = String.format("%s %d %d %d air", cmdName, placementPos.method_10263(), placementPos.method_10264(), placementPos.method_10260());
            this.sendCommand(command, player);
        }
    }

    protected void placeBlockDirectly(class_2338 pos, class_2680 state, class_2586 be, class_1937 schematicWorld, class_638 clientWorld, class_746 player) {
        if (this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            player.method_23327((double)pos.method_10263(), (double)(pos.method_10264() + 2), (double)pos.method_10260());
            String command = String.format("tp @p %d %d %d", pos.method_10263(), pos.method_10264() + 2, pos.method_10260());
            this.sendCommand(command, player);
            class_243 posVec = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5);
            class_3965 hitResult = new class_3965(posVec, class_2350.field_11036, pos, false);
            this.mc.field_1761.method_2896(player, clientWorld, class_1268.field_5810, hitResult);
        }
    }

    protected void sendCommand(String command, class_746 player) {
        this.sendCommandToServer(command, player);
        ++this.sentCommandsThisTick;
        ++this.sentCommandsTotal;
    }

    protected void sendCommandToServer(String command, class_746 player) {
        if (command.length() > 0 && command.charAt(0) != '/') {
            player.method_3142("/" + command);
        } else {
            player.method_3142(command);
        }
    }

    @Nullable
    public static class_2338 findEmptyNearbyPosition(class_1937 world, class_2338 centerPos, int radius) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2338.class_2339 sidePos = new class_2338.class_2339();
        for (int y = centerPos.method_10264(); y <= centerPos.method_10264() + radius; ++y) {
            for (int z = centerPos.method_10260() - radius; z <= centerPos.method_10260() + radius; ++z) {
                for (int x = centerPos.method_10263() - radius; x <= centerPos.method_10263() + radius; ++x) {
                    pos.method_10103(x, y, z);
                    if (!TaskPasteSchematicPerChunkCommand.isPositionAndSidesEmpty(world, pos, sidePos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    public static boolean isPositionAndSidesEmpty(class_1937 world, class_2338.class_2339 centerPos, class_2338.class_2339 pos) {
        if (!world.method_22347((class_2338)centerPos)) {
            return false;
        }
        for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
            if (world.method_22347((class_2338)pos.method_25505((class_2382)centerPos, side))) continue;
            return false;
        }
        return true;
    }

    protected boolean preparePickedStack(class_2338 pos, class_2680 state, class_2586 be, class_1937 world, class_746 player) {
        class_1799 stack = state.method_26204().method_9574((class_1922)world, pos, state);
        if (!stack.method_7960()) {
            TaskPasteSchematicPerChunkCommand.addBlockEntityNbt(stack, be);
            player.method_31548().field_7544.set(0, (Object)stack);
            this.mc.field_1761.method_2909(stack, 45);
            return true;
        }
        return false;
    }

    public static void addBlockEntityNbt(class_1799 stack, class_2586 be) {
        class_2487 tag = be.method_11007(new class_2487());
        if (stack.method_7909() instanceof class_1809 && tag.method_10545("SkullOwner")) {
            class_2487 ownerTag = tag.method_10562("SkullOwner");
            stack.method_7948().method_10566("SkullOwner", (class_2520)ownerTag);
        } else {
            stack.method_7959("BlockEntityTag", (class_2520)tag);
        }
    }

    @Override
    public void stop() {
        if (this.finished) {
            if (this.printCompletionMessage) {
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted_using_setblock", (Object[])new Object[]{this.sentSetblockCommands});
            }
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        if (this.mc.field_1724 != null && this.shouldEnableFeedback) {
            this.mc.field_1724.method_3142("/gamerule sendCommandFeedback true");
        }
        DataManager.removeChatListener(this.gameRuleListener);
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.stop();
    }

    public static enum TaskPhase {
        INIT,
        GAMERULE_PROBE,
        WAIT_FOR_CHUNKS,
        PROCESS_BOX_BLOCKS,
        PROCESS_BOX_ENTITIES,
        FINISHED;

    }
}

