/*
 * Decompiled with CFR 0.152.
 */
package monkey.lumpy.horse.stats.vanilla.mixin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.math.Color;
import monkey.lumpy.horse.stats.vanilla.config.ModConfig;
import monkey.lumpy.horse.stats.vanilla.util.Converter;
import net.minecraft.class_1492;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1724;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_491;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_491.class})
public abstract class HorseScreenMixin
extends class_465<class_1724> {
    @Shadow
    @Final
    private class_1496 field_2941;
    private ModConfig config;

    public HorseScreenMixin(class_1724 handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        super.method_2388(matrices, mouseX, mouseY);
        if (this.config == null) {
            this.config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        }
        boolean hasChest = false;
        if (class_1492.class.isAssignableFrom(this.field_2941.getClass()) && ((class_1492)this.field_2941).method_6703()) {
            hasChest = true;
        }
        DecimalFormat df = new DecimalFormat("#.#");
        String jumpstrength = df.format(Converter.jumpStrengthToJumpHeight(this.field_2941.method_6771()));
        String maxHealth = df.format(this.field_2941.method_6063());
        String speed = df.format(Converter.genericSpeedToBlocPerSec(this.field_2941.method_6127().method_26852(class_5134.field_23719)));
        Color jumpColor = this.config.getNeutralColor();
        Color speedColor = this.config.getNeutralColor();
        Color hearthColor = this.config.getNeutralColor();
        if (this.config.useColors()) {
            double jumpValue = new BigDecimal(jumpstrength.replace(',', '.')).doubleValue();
            double speedValue = new BigDecimal(speed.replace(',', '.')).doubleValue();
            double healthValue = new BigDecimal(maxHealth.replace(',', '.')).doubleValue();
            if (jumpValue > (double)this.config.getGoodHorseJumpValue()) {
                jumpColor = this.config.getGoodColor();
            } else if (jumpValue < (double)this.config.getBadHorseJumpValue()) {
                jumpColor = this.config.getBadColor();
            }
            if (speedValue > (double)this.config.getGoodHorseSpeedValue()) {
                speedColor = this.config.getGoodColor();
            } else if (speedValue < (double)this.config.getBadHorseSpeedValue()) {
                speedColor = this.config.getBadColor();
            }
            if (healthValue > (double)this.config.getGoodHorseHeartsValue()) {
                hearthColor = this.config.getGoodColor();
            } else if (healthValue < (double)this.config.getBadHorseHeartsValue()) {
                hearthColor = this.config.getBadColor();
            }
        }
        if (!hasChest) {
            float spacer = 1.0f;
            if (this.config.showMaxMin()) {
                this.field_22793.method_1729(matrices, "(4.7-14.2)", 119.0f, 26.0f, this.config.getNeutralColor().hashCode());
                this.field_22793.method_1729(matrices, "(1-5.3)", 119.0f, 36.0f, this.config.getNeutralColor().hashCode());
                this.field_22793.method_1729(matrices, "(15-30)", 119.0f, 46.0f, this.config.getNeutralColor().hashCode());
            } else {
                spacer = 10.0f;
            }
            this.field_22793.method_1729(matrices, "\u279f", 82.0f + spacer, 26.0f, speedColor.hashCode());
            this.field_22793.method_1729(matrices, speed, 93.0f + spacer, 26.0f, speedColor.hashCode());
            this.field_22793.method_1729(matrices, "\u21ee", 84.0f + spacer, 36.0f, jumpColor.hashCode());
            this.field_22793.method_1729(matrices, jumpstrength, 93.0f + spacer, 36.0f, jumpColor.hashCode());
            this.field_22793.method_1729(matrices, "\u2665", 83.0f + spacer, 46.0f, hearthColor.hashCode());
            this.field_22793.method_1729(matrices, maxHealth, 93.0f + spacer, 46.0f, hearthColor.hashCode());
        } else {
            this.field_22793.method_1729(matrices, "\u279f " + speed, 80.0f, 6.0f, speedColor.hashCode());
            this.field_22793.method_1729(matrices, "\u21ee " + jumpstrength, 115.0f, 6.0f, jumpColor.hashCode());
            this.field_22793.method_1729(matrices, "\u2665 " + maxHealth, 140.0f, 6.0f, hearthColor.hashCode());
        }
        Color strengthColor = this.config.getNeutralColor();
        if (class_1501.class.isAssignableFrom(this.field_2941.getClass())) {
            int strength = 3 * ((class_1501)this.field_2941).method_6803();
            if (this.config.useColors()) {
                if ((float)strength > this.config.getGoodHorseJumpValue()) {
                    strengthColor = this.config.getGoodColor();
                } else if ((float)strength < this.config.getBadHorseJumpValue()) {
                    strengthColor = this.config.getBadColor();
                }
            }
            if (!hasChest) {
                this.field_22793.method_1729(matrices, "\u25a6", 91.0f, 56.0f, strengthColor.hashCode());
                this.field_22793.method_1729(matrices, "" + strength, 100.0f, 56.0f, strengthColor.hashCode());
            }
        }
    }
}

