/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.firstperson.MinecraftWrapper;
import dev.tr7zw.firstperson.config.CustomConfigScreen;
import dev.tr7zw.firstperson.config.FirstPersonSettings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_316;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public abstract class FirstPersonModelCore {
    public static MinecraftWrapper wrapper;
    public static FirstPersonModelCore instance;
    public static boolean isRenderingPlayer;
    public static boolean enabled;
    public static FirstPersonSettings config;
    protected static boolean isHeld;
    public static class_304 keyBinding;
    private File settingsFile = new File("config", "firstperson.json");
    public static final float sneakBodyOffset = 0.27f;
    public static final float swimUpBodyOffset = 0.6f;
    public static final float swimDownBodyOffset = 0.5f;
    public static final float inVehicleBodyOffset = 0.2f;

    public void sharedSetup() {
        System.out.println("Loading FirstPerson Mod");
        wrapper = new MinecraftWrapper(class_310.method_1551());
        if (this.settingsFile.exists()) {
            try {
                config = (FirstPersonSettings)new Gson().fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), FirstPersonSettings.class);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new FirstPersonSettings();
        }
        this.writeSettings();
        enabled = FirstPersonModelCore.config.enabledByDefault;
        this.registerKeybinds();
    }

    public abstract void registerKeybinds();

    public static MinecraftWrapper getWrapper() {
        return wrapper;
    }

    public static boolean fixBodyShadow(class_4587 matrixStack) {
        return enabled && (FirstPersonModelCore.config.forceActive || isRenderingPlayer);
    }

    public void onTick() {
        if (keyBinding.method_1434()) {
            if (isHeld) {
                return;
            }
            isHeld = true;
            enabled = !enabled;
        } else {
            isHeld = false;
        }
    }

    public void writeSettings() {
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((Object)config);
        try {
            Files.write(this.settingsFile.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class_437 createConfigScreen(class_437 parent) {
        CustomConfigScreen screen = new CustomConfigScreen(parent, "text.firstperson.title"){

            @Override
            public void initialize() {
                this.getOptions().method_20406(this.getOnOffOption("text.firstperson.option.firstperson.enabledByDefault", () -> FirstPersonModelCore.config.enabledByDefault, b -> {
                    FirstPersonModelCore.config.enabledByDefault = b;
                }));
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getIntOption("text.firstperson.option.firstperson.xOffset", -40.0f, 40.0f, () -> FirstPersonModelCore.config.xOffset, i -> {
                    FirstPersonModelCore.config.xOffset = i;
                }));
                options.add(this.getIntOption("text.firstperson.option.firstperson.sneakXOffset", -40.0f, 40.0f, () -> FirstPersonModelCore.config.sneakXOffset, i -> {
                    FirstPersonModelCore.config.sneakXOffset = i;
                }));
                options.add(this.getIntOption("text.firstperson.option.firstperson.sitXOffset", -40.0f, 40.0f, () -> FirstPersonModelCore.config.sitXOffset, i -> {
                    FirstPersonModelCore.config.sitXOffset = i;
                }));
                options.add(this.getOnOffOption("text.firstperson.option.firstperson.vanillaHands", () -> FirstPersonModelCore.config.vanillaHands, b -> {
                    FirstPersonModelCore.config.vanillaHands = b;
                }));
                options.add(this.getOnOffOption("text.firstperson.option.firstperson.doubleHands", () -> FirstPersonModelCore.config.doubleHands, b -> {
                    FirstPersonModelCore.config.doubleHands = b;
                }));
                options.add(this.getOnOffOption("text.firstperson.option.firstperson.forceActive", () -> FirstPersonModelCore.config.forceActive, b -> {
                    FirstPersonModelCore.config.forceActive = b;
                }));
                this.getOptions().method_20408(options.toArray(new class_316[0]));
            }

            @Override
            public void save() {
                FirstPersonModelCore.this.writeSettings();
            }
        };
        return screen;
    }

    static {
        isRenderingPlayer = false;
        enabled = true;
        config = null;
        isHeld = false;
        keyBinding = new class_304("key.firstperson.toggle", 295, "Firstperson");
    }
}

