/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.network;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.github.kosmx.emotes.api.events.impl.EventResult;
import io.github.kosmx.emotes.api.events.server.ServerEmoteEvents;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.GeyserEmotePacket;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.common.tools.BiMap;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.server.config.Serializer;
import io.github.kosmx.emotes.server.geyser.EmoteMappings;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import javax.annotation.Nullable;

public abstract class AbstractServerEmotePlay<P> {
    protected EmoteMappings bedrockEmoteMap = new EmoteMappings(new BiMap<UUID, UUID>());

    public AbstractServerEmotePlay() {
        try {
            this.initMappings(EmoteInstance.instance.getGameDirectory().resolve("config"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initMappings(Path configPath) throws IOException {
        Path filePath = configPath.resolve("emotecraft_emote_map.json");
        if (filePath.toFile().isFile()) {
            BufferedReader reader = Files.newBufferedReader(filePath);
            try {
                this.bedrockEmoteMap = new EmoteMappings((BiMap)Serializer.serializer.fromJson((Reader)reader, new TypeToken<BiMap<UUID, UUID>>(){}.getType()));
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            reader.close();
        } else {
            BiMap<UUID, UUID> example = new BiMap<UUID, UUID>();
            example.put(new UUID(4822678189205111L, -8603657889541918977L), new UUID(-4822678189205112L, 8603657889541918976L));
            BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);
            Serializer.serializer.toJson(example, new TypeToken<BiMap<UUID, UUID>>(){}.getType(), (Appendable)writer);
            writer.close();
        }
    }

    protected boolean doValidate() {
        return (Boolean)EmoteInstance.config.validateEmote.get();
    }

    protected abstract UUID getUUIDFromPlayer(P var1);

    protected abstract long getRuntimePlayerID(P var1);

    public void receiveMessage(byte[] bytes, P player, INetworkInstance instance) throws IOException {
        this.receiveMessage(new EmotePacket.Builder().setThreshold(((Float)EmoteInstance.config.validThreshold.get()).floatValue()).build().read(ByteBuffer.wrap(bytes)), player, instance);
    }

    public void receiveMessage(NetData data, P player, INetworkInstance instance) throws IOException {
        switch (data.purpose) {
            case STOP: {
                data.player = this.getUUIDFromPlayer(player);
                this.sendForEveryoneElse(data, null, player);
                break;
            }
            case CONFIG: {
                instance.setVersions(data.versions);
                instance.presenceResponse();
                break;
            }
            case STREAM: {
                this.streamEmote(data, player, instance);
                break;
            }
            default: {
                throw new IOException("Unknown packet task");
            }
        }
    }

    public void receiveBEEmote(P player, GeyserEmotePacket emotePacket) throws IOException {
        UUID javaEmote = this.bedrockEmoteMap.getJavaEmote(emotePacket.getEmoteID());
        if (javaEmote != null && UniversalEmoteSerializer.getEmote(javaEmote) != null) {
            NetData data = new NetData();
            data.emoteData = UniversalEmoteSerializer.getEmote(javaEmote);
            data.purpose = PacketTask.STREAM;
            this.streamEmote(data, player, null);
        } else {
            this.sendForEveryoneElse(emotePacket, player);
        }
    }

    protected void streamEmote(NetData data, P player, INetworkInstance instance) throws IOException {
        EventResult result;
        if (!data.valid && this.doValidate() && (result = ServerEmoteEvents.EMOTE_VERIFICATION.invoker().verify(data.emoteData, this.getUUIDFromPlayer(player))) != EventResult.FAIL) {
            EmotePacket.Builder stopMSG = new EmotePacket.Builder().configureToSendStop(data.emoteData.getUuid()).configureTarget(this.getUUIDFromPlayer(player)).setSizeLimit(0x100000);
            if (instance != null) {
                instance.sendMessage(stopMSG, null);
            }
            return;
        }
        UUID target = data.player;
        data.player = this.getUUIDFromPlayer(player);
        if (target == null) {
            UUID bedrockEmoteID = this.bedrockEmoteMap.getBeEmote(data.emoteData.getUuid());
            GeyserEmotePacket geyserEmotePacket = null;
            if (bedrockEmoteID != null) {
                geyserEmotePacket = new GeyserEmotePacket();
                geyserEmotePacket.setEmoteID(bedrockEmoteID);
                geyserEmotePacket.setRuntimeEntityID(this.getRuntimePlayerID(player));
            }
            this.sendForEveryoneElse(data, geyserEmotePacket, player);
        } else {
            this.sendForPlayerInRange(data, player, target);
        }
    }

    public void receiveGeyserMessage(P player, byte[] data) {
        try {
            GeyserEmotePacket packet = new GeyserEmotePacket();
            packet.read(data);
            packet.setRuntimeEntityID(this.getRuntimePlayerID(player));
            this.receiveBEEmote(player, packet);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected abstract void sendForEveryoneElse(GeyserEmotePacket var1, P var2);

    protected abstract void sendForEveryoneElse(NetData var1, @Nullable GeyserEmotePacket var2, P var3);

    protected abstract void sendForPlayerInRange(NetData var1, P var2, UUID var3);

    protected abstract void sendForPlayer(NetData var1, P var2, UUID var3);
}

