/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.network;

import io.github.kosmx.emotes.api.proxy.EmotesProxyManager;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.logging.Level;

public final class ClientPacketManager
extends EmotesProxyManager {
    private static final INetworkInstance defaultNetwork = EmoteInstance.instance.getClientMethods().getServerNetworkController();

    public static void init() {
        ClientPacketManager.setManager(new ClientPacketManager());
    }

    private ClientPacketManager() {
    }

    private static boolean useAlwaysAlt() {
        return false;
    }

    static void send(EmotePacket.Builder packetBuilder, UUID target) {
        block9: {
            if (!defaultNetwork.isActive() || ClientPacketManager.useAlwaysAlt()) {
                for (INetworkInstance network : networkInstances) {
                    if (!network.isActive()) continue;
                    try {
                        EmotePacket.Builder builder = packetBuilder.copy();
                        if (!network.sendPlayerID()) {
                            builder.removePlayerID();
                        }
                        builder.setSizeLimit(network.maxDataSize());
                        network.sendMessage(builder, target);
                    }
                    catch (IOException exception) {
                        EmoteInstance.instance.getLogger().log(Level.WARNING, "Error while sending packet: " + exception.getMessage(), true);
                        if (!((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) continue;
                        exception.printStackTrace();
                    }
                }
            }
            if (defaultNetwork.isActive()) {
                if (!defaultNetwork.sendPlayerID()) {
                    packetBuilder.removePlayerID();
                }
                try {
                    packetBuilder.setSizeLimit(defaultNetwork.maxDataSize());
                    defaultNetwork.sendMessage(packetBuilder, target);
                }
                catch (IOException exception) {
                    EmoteInstance.instance.getLogger().log(Level.WARNING, "Error while sending packet: " + exception.getMessage(), true);
                    if (!((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) break block9;
                    exception.printStackTrace();
                }
            }
        }
    }

    static void receiveMessage(ByteBuffer buffer, UUID player, INetworkInstance networkInstance) {
        block8: {
            try {
                NetData data = new EmotePacket.Builder().setThreshold(((Float)EmoteInstance.config.validThreshold.get()).floatValue()).build().read(buffer);
                if (data == null) {
                    throw new IOException("no valid data");
                }
                if (!networkInstance.trustReceivedPlayer()) {
                    data.player = null;
                }
                if (player != null) {
                    data.player = player;
                }
                if (data.player == null && data.purpose.playerBound) {
                    throw new IOException("Didn't received any player information");
                }
                try {
                    ClientEmotePlay.executeMessage(data, networkInstance);
                }
                catch (Exception e) {
                    EmoteInstance.instance.getLogger().log(Level.SEVERE, "Critical error has occurred while receiving emote: " + e.getMessage(), true);
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, "Error while receiving packet: " + e.getMessage(), true);
                if (!((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) break block8;
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void logMSG(Level level, String msg) {
        EmoteInstance.instance.getLogger().log(level, "[emotes proxy module] " + msg, level.intValue() >= Level.WARNING.intValue());
    }

    @Override
    protected void dispatchReceive(ByteBuffer buffer, UUID player, INetworkInstance networkInstance) {
        ClientPacketManager.receiveMessage(buffer, player, networkInstance);
    }

    public static boolean isRemoveAvailable() {
        return defaultNetwork.isActive();
    }

    public static boolean isAvailableProxy() {
        for (INetworkInstance instance : networkInstances) {
            if (!instance.isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onDisconnectFromServer(INetworkInstance networkInstance) {
        if (networkInstance == null) {
            throw new NullPointerException("network instance must be non-null");
        }
        EmoteHolder.list.removeIf(emoteHolder -> emoteHolder.fromInstance == networkInstance);
    }
}

