/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.emotePlay;

import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.opennbs.SoundPlayer;
import io.github.kosmx.emotes.common.opennbs.format.Layer;
import io.github.kosmx.emotes.common.tools.Easing;
import io.github.kosmx.emotes.common.tools.MathHelper;
import io.github.kosmx.emotes.common.tools.Vector3;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class EmotePlayer<T>
implements IEmotePlayer {
    private final EmoteData data;
    @Nullable
    final SoundPlayer song;
    private boolean isRunning = true;
    private int currentTick = 0;
    private boolean isLoopStarted = false;
    protected float tickDelta;
    @Deprecated
    public final BodyPart head;
    @Deprecated
    public final BodyPart torso;
    @Deprecated
    public final BodyPart rightArm;
    @Deprecated
    public final BodyPart leftArm;
    @Deprecated
    public final BodyPart rightLeg;
    @Deprecated
    public final BodyPart leftLeg;
    public final HashMap<String, BodyPart> bodyParts;
    public int perspective = 0;

    @Nullable
    public EmotePlayer(EmoteData emote, Consumer<Layer.Note> noteConsumer, int t) {
        this.data = emote;
        this.song = emote.song != null ? new SoundPlayer(emote.song, noteConsumer, 0) : null;
        this.bodyParts = new HashMap(emote.bodyParts.size());
        for (Map.Entry<String, EmoteData.StateCollection> part : emote.bodyParts.entrySet()) {
            this.bodyParts.put(part.getKey(), new BodyPart(part.getValue()));
        }
        this.head = this.bodyParts.get(this.data.head.name);
        this.torso = this.bodyParts.get(this.data.body.name);
        this.rightArm = this.bodyParts.get(this.data.rightArm.name);
        this.leftArm = this.bodyParts.get(this.data.leftArm.name);
        this.rightLeg = this.bodyParts.get(this.data.rightLeg.name);
        this.leftLeg = this.bodyParts.get(this.data.leftLeg.name);
        this.currentTick = t;
        if (this.isInfinite() && t > this.data.returnToTick) {
            this.currentTick = (t - this.data.returnToTick) % (this.data.endTick - this.data.returnToTick) + this.data.returnToTick;
        }
        this.perspective = this.perspective;
    }

    @Override
    public void tick() {
        if (this.isRunning) {
            ++this.currentTick;
            if (this.data.isInfinite && this.currentTick >= this.data.endTick) {
                this.currentTick = this.data.returnToTick;
                this.isLoopStarted = true;
            }
            if (this.currentTick >= this.data.stopTick) {
                this.stop();
            }
            if (SoundPlayer.isPlayingSong(this.song)) {
                this.song.tick();
            }
        }
    }

    @Override
    public int getTick() {
        return this.currentTick;
    }

    public static boolean isRunningEmote(@Nullable EmotePlayer emote) {
        return emote != null && emote.isRunning;
    }

    public void stop() {
        this.isRunning = false;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public boolean isLoopStarted() {
        return this.isLoopStarted;
    }

    @Override
    public EmoteData getData() {
        return this.data;
    }

    public BodyPart getPart(String string) {
        BodyPart part = this.bodyParts.get(string);
        return part == null ? new BodyPart(null) : part;
    }

    public void setTickDelta(float tickDelta) {
        this.tickDelta = tickDelta;
    }

    public int getStopTick() {
        return this.data.stopTick;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public boolean isInfinite() {
        return this.data.isInfinite;
    }

    protected abstract void updateBodyPart(BodyPart var1, T var2);

    public class BodyPart {
        @Nullable
        public final EmoteData.StateCollection part;
        public final Axis x;
        public final Axis y;
        public final Axis z;
        public final RotationAxis pitch;
        public final RotationAxis yaw;
        public final RotationAxis roll;
        public final RotationAxis bendAxis;
        public final RotationAxis bend;

        public BodyPart(EmoteData.StateCollection part) {
            this.part = part;
            if (part != null) {
                this.x = new Axis(part.x);
                this.y = new Axis(part.y);
                this.z = new Axis(part.z);
                this.pitch = new RotationAxis(part.pitch);
                this.yaw = new RotationAxis(part.yaw);
                this.roll = new RotationAxis(part.roll);
                this.bendAxis = new RotationAxis(part.bendDirection);
                this.bend = new RotationAxis(part.bend);
            } else {
                this.x = null;
                this.y = null;
                this.z = null;
                this.pitch = null;
                this.yaw = null;
                this.roll = null;
                this.bendAxis = null;
                this.bend = null;
            }
        }

        public void updateBodyPart(T modelPart) {
            if (this.part != null) {
                EmotePlayer.this.updateBodyPart(this, modelPart);
            }
        }

        public Pair<Float, Float> getBend() {
            if (this.bend == null) {
                return new Pair<Float, Float>(Float.valueOf(0.0f), Float.valueOf(0.0f));
            }
            return new Pair<Float, Float>(Float.valueOf(this.bendAxis.getValueAtCurrentTick(0.0f)), Float.valueOf(this.bend.getValueAtCurrentTick(0.0f)));
        }

        public Vector3<Double> getBodyOffset() {
            if (this.part == null) {
                return new Vector3<Double>(0.0, 0.0, 0.0);
            }
            double x = this.x.getValueAtCurrentTick(0.0f);
            double y = this.y.getValueAtCurrentTick(0.0f);
            double z = this.z.getValueAtCurrentTick(0.0f);
            return new Vector3<Double>(x, y, z);
        }

        public Vector3<Float> getBodyRotation() {
            if (this.part == null) {
                return new Vector3<Float>(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
            }
            return new Vector3<Float>(Float.valueOf(this.pitch.getValueAtCurrentTick(0.0f)), Float.valueOf(this.yaw.getValueAtCurrentTick(0.0f)), Float.valueOf(this.roll.getValueAtCurrentTick(0.0f)));
        }
    }

    public class RotationAxis
    extends Axis {
        public RotationAxis(EmoteData.StateCollection.State keyframes) {
            super(keyframes);
        }

        @Override
        public float getValueAtCurrentTick(float currentValue) {
            return MathHelper.clampToRadian(super.getValueAtCurrentTick(MathHelper.clampToRadian(currentValue)));
        }
    }

    public class Axis {
        protected final EmoteData.StateCollection.State keyframes;

        public Axis(EmoteData.StateCollection.State keyframes) {
            this.keyframes = keyframes;
        }

        private EmoteData.KeyFrame findBefore(int pos, float currentState) {
            if (pos == -1) {
                return EmotePlayer.this.currentTick < ((EmotePlayer)EmotePlayer.this).data.beginTick || this.keyframes.length() != 0 ? new EmoteData.KeyFrame(0, currentState) : (EmotePlayer.this.currentTick < ((EmotePlayer)EmotePlayer.this).data.endTick ? new EmoteData.KeyFrame(((EmotePlayer)EmotePlayer.this).data.beginTick, this.keyframes.defaultValue) : new EmoteData.KeyFrame(((EmotePlayer)EmotePlayer.this).data.endTick, this.keyframes.defaultValue));
            }
            return this.keyframes.keyFrames.get(pos);
        }

        private EmoteData.KeyFrame findAfter(int pos, float currentState) {
            if (this.keyframes.length() > pos + 1) {
                return this.keyframes.keyFrames.get(pos + 1);
            }
            if (((EmotePlayer)EmotePlayer.this).data.isInfinite) {
                return this.getLastFrame();
            }
            return EmotePlayer.this.currentTick >= ((EmotePlayer)EmotePlayer.this).data.endTick || this.keyframes.length() != 0 ? new EmoteData.KeyFrame(((EmotePlayer)EmotePlayer.this).data.stopTick, currentState) : (EmotePlayer.this.currentTick >= EmotePlayer.this.getData().beginTick ? new EmoteData.KeyFrame(EmotePlayer.this.getData().endTick, this.keyframes.defaultValue) : new EmoteData.KeyFrame(EmotePlayer.this.getData().beginTick, this.keyframes.defaultValue));
        }

        private EmoteData.KeyFrame getLastFrame() {
            if (this.keyframes.length() > 0) {
                return this.keyframes.keyFrames.get(this.keyframes.length() - 1);
            }
            return new EmoteData.KeyFrame(EmotePlayer.this.getData().beginTick, this.keyframes.defaultValue);
        }

        public float getValueAtCurrentTick(float currentValue) {
            if (this.keyframes.isEnabled) {
                int pos = this.keyframes.findAtTick(EmotePlayer.this.currentTick);
                EmoteData.KeyFrame keyBefore = this.findBefore(pos, currentValue);
                if (EmotePlayer.this.isLoopStarted && keyBefore.tick < ((EmotePlayer)EmotePlayer.this).data.returnToTick) {
                    keyBefore = this.findBefore(this.keyframes.findAtTick(((EmotePlayer)EmotePlayer.this).data.endTick), currentValue);
                }
                EmoteData.KeyFrame keyAfter = this.findAfter(pos, currentValue);
                if (((EmotePlayer)EmotePlayer.this).data.isInfinite && keyAfter.tick >= ((EmotePlayer)EmotePlayer.this).data.endTick) {
                    keyAfter = this.findAfter(this.keyframes.findAtTick(((EmotePlayer)EmotePlayer.this).data.returnToTick - 1), currentValue);
                }
                return this.getValueFromKeyframes(keyBefore, keyAfter);
            }
            return currentValue;
        }

        protected final float getValueFromKeyframes(EmoteData.KeyFrame before, EmoteData.KeyFrame after) {
            int tickBefore = before.tick;
            int tickAfter = after.tick;
            if (tickBefore >= tickAfter) {
                if (EmotePlayer.this.currentTick < tickBefore) {
                    tickBefore -= ((EmotePlayer)EmotePlayer.this).data.endTick - ((EmotePlayer)EmotePlayer.this).data.returnToTick;
                } else {
                    tickAfter += ((EmotePlayer)EmotePlayer.this).data.endTick - ((EmotePlayer)EmotePlayer.this).data.returnToTick;
                }
            }
            if (tickBefore == tickAfter) {
                return before.value;
            }
            float f = ((float)EmotePlayer.this.currentTick + EmotePlayer.this.tickDelta - (float)tickBefore) / (float)(tickAfter - tickBefore);
            return MathHelper.lerp(Easing.easingFromEnum(((EmotePlayer)EmotePlayer.this).data.isEasingBefore ? after.ease : before.ease, f), before.value, after.value);
        }
    }
}

